/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CustomArmor;
import com.vicmatskiv.weaponlib.Weapon;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class CustomGui
extends Gui {
    private Minecraft mc;
    private static final int BUFF_ICON_SIZE = 256;

    public CustomGui(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderHud(RenderGameOverlayEvent.Pre event) {
        String hudTexture;
        ItemStack helmet;
        if (event.type == RenderGameOverlayEvent.ElementType.HELMET && (helmet = this.mc.field_71439_g.func_71124_b(4)) != null && this.mc.field_71474_y.field_74320_O == 0 && helmet.func_77973_b() instanceof CustomArmor && (hudTexture = ((CustomArmor)helmet.func_77973_b()).getHudTexture()) != null) {
            ScaledResolution scaledResolution = event.resolution;
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.mc.field_71446_o.func_110577_a(new ResourceLocation(hudTexture));
            CustomGui.drawTexturedQuadFit(0.0, 0.0, width, height, 0.0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (event.type != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        ItemStack weapon = this.mc.field_71439_g.func_70694_bm();
        if (weapon == null || !(weapon.func_77973_b() instanceof Weapon) || this.mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        Weapon weaponItem = (Weapon)weapon.func_77973_b();
        String crosshair = weaponItem.getCrosshair(weapon, (EntityPlayer)this.mc.field_71439_g);
        if (crosshair != null) {
            ScaledResolution scaledResolution = event.resolution;
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int xPos = width / 2 - 128;
            int yPos = height / 2 - 128;
            this.mc.field_71446_o.func_110577_a(new ResourceLocation(crosshair));
            if (weaponItem.isCrosshairFullScreen(weapon)) {
                CustomGui.drawTexturedQuadFit(0.0, 0.0, width, height, 0.0);
            } else {
                this.func_73729_b(xPos, yPos, 0, 0, 256, 256);
            }
            FontRenderer fontRender = this.mc.field_71466_p;
            this.mc.field_71460_t.func_78478_c();
            int color = 0xFFFFFF;
            if (weaponItem.getState(weapon) == 4) {
                fontRender.func_78261_a("Attachment selection mode. Press [f] to exit.", 10, 10, color);
                fontRender.func_78261_a("Press [up] to add optic", width / 2 - 40, 60, color);
                fontRender.func_78261_a("Press [left] to add barrel rig", 10, height / 2 - 10, color);
                fontRender.func_78261_a("Press [right] to change camo", width / 2 + 60, height / 2 - 20, color);
                fontRender.func_78261_a("Press [down] to add under-barrel rig", 10, height - 40, color);
            } else {
                String text = "Ammo: " + weaponItem.getCurrentAmmo((EntityPlayer)this.mc.field_71439_g) + "/" + weaponItem.getAmmoCapacity();
                int x = width - 80;
                int y = 10;
                fontRender.func_78261_a(text, x, y, color);
            }
            event.setCanceled(true);
        }
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, zLevel, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y + 0.0, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }
}

