/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.render;

import com.enderio.core.common.util.BlockCoord;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.common.Profiler;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.render.CachableRenderStatement;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class RenderingContext {
    private static Field xOffset_field;
    private static Field yOffset_field;
    private static Field zOffset_field;
    private static Field tessIsDrawing_field;
    private static Field vertexCount_field;
    private static boolean derpedTess;
    private static int glErrorCount;
    public final double xOffset;
    public final double yOffset;
    public final double zOffset;
    private final boolean tessIsDrawing;
    private final int vertexCount;
    public final float[] blockLight = new float[ForgeDirection.values().length];
    public final float[] skyLight = new float[ForgeDirection.values().length];
    public final int[] mixedLight = new int[ForgeDirection.values().length];
    public final boolean hasLight;
    int lastError;

    public RenderingContext() {
        this.hasLight = false;
        this.zOffset = 0.0;
        this.yOffset = 0.0;
        this.xOffset = 0.0;
        this.tessIsDrawing = false;
        this.vertexCount = 0;
    }

    public RenderingContext(IBlockAccess world, BlockCoord bc) {
        if (world != null && bc != null) {
            this.hasLight = true;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord to = bc.getLocation(dir);
                int brightness = to.getBlock(world).func_149677_c(world, to.x, to.y, to.z);
                if (brightness == 0) {
                    brightness = bc.getBlock(world).func_149677_c(world, bc.x, bc.y, bc.z);
                }
                this.mixedLight[dir.ordinal()] = brightness;
                this.skyLight[dir.ordinal()] = brightness >>> 16;
                this.blockLight[dir.ordinal()] = brightness & 0xFFFF;
            }
        } else {
            this.hasLight = false;
        }
        RenderingContext.setupTessellatorFields();
        this.xOffset = RenderingContext.getDouble(xOffset_field);
        this.yOffset = RenderingContext.getDouble(yOffset_field);
        this.zOffset = RenderingContext.getDouble(zOffset_field);
        this.vertexCount = RenderingContext.getInt(vertexCount_field);
        this.tessIsDrawing = RenderingContext.getBoolean(tessIsDrawing_field);
    }

    private static double getDouble(Field field) {
        if (!derpedTess) {
            try {
                return field.getDouble(Tessellator.field_78398_a);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Log.warn("Some mod has replaced Minecraft's tesselator. Help, without that one I don't now where to render!\n" + e);
                derpedTess = true;
            }
        }
        return 0.0;
    }

    private static boolean getBoolean(Field field) {
        if (!derpedTess) {
            try {
                return field.getBoolean(Tessellator.field_78398_a);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Log.warn("Some mod has replaced Minecraft's tesselator. Help, without that one I don't now where to render!\n" + e);
                derpedTess = true;
            }
        }
        return false;
    }

    private static int getInt(Field field) {
        if (!derpedTess) {
            try {
                return field.getInt(Tessellator.field_78398_a);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Log.warn("Some mod has replaced Minecraft's tesselator. Help, without that one I don't now where to render!\n" + e);
                derpedTess = true;
            }
        }
        return 0;
    }

    public void execute(List<CachableRenderStatement> csr, String profilerContext) {
        if (!derpedTess && Config.directDrawingEnabled.getBoolean() && glErrorCount != -1) {
            if (this.tessIsDrawing) {
                if (this.vertexCount == 0) {
                    Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                    Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                    Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                    Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                }
                Tessellator.field_78398_a.func_78381_a();
            }
            this.clearGLerrors();
            long id = Profiler.client.start();
            for (CachableRenderStatement statement : csr) {
                statement.execute(this);
            }
            Profiler.client.stop(id, profilerContext + " (direct)");
            if (this.hasGLerrors() && glErrorCount++ > 1000) {
                glErrorCount = -1;
                Log.warn("Disabled direct drawing after too many OpenGL errors. If you got rendering errors, you can disabled direct drawing completely in the mod options. Last error was: " + this.lastError + " (" + GLU.gluErrorString((int)this.lastError) + ")");
                Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText("Disabled direct drawing after too many OpenGL errors. If you got rendering errors, you can disabled direct drawing completely in the mod options for Ender IO Addons."));
            }
            if (this.tessIsDrawing) {
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
                Tessellator.field_78398_a.func_78377_a(0.0, 0.0, 0.0);
            }
        } else {
            this.execute_tesselated(csr, profilerContext);
        }
    }

    public void execute_tesselated(List<CachableRenderStatement> csr, String profilerContext) {
        if (!this.tessIsDrawing) {
            Tessellator.field_78398_a.func_78382_b();
        }
        long id = Profiler.client.start();
        for (CachableRenderStatement statement : csr) {
            statement.execute_tesselated(this);
        }
        Profiler.client.stop(id, profilerContext + " (tesselator)");
        if (!this.tessIsDrawing) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public static void setupTessellatorFields() {
        if (!derpedTess) {
            try {
                if (xOffset_field == null) {
                    xOffset_field = RenderingContext.getField("xOffset", "field_78408_v");
                    xOffset_field.setAccessible(true);
                    yOffset_field = RenderingContext.getField("yOffset", "field_78407_w");
                    yOffset_field.setAccessible(true);
                    zOffset_field = RenderingContext.getField("zOffset", "field_78417_x");
                    zOffset_field.setAccessible(true);
                    tessIsDrawing_field = RenderingContext.getField("isDrawing", "field_78415_z");
                    tessIsDrawing_field.setAccessible(true);
                    vertexCount_field = RenderingContext.getField("vertexCount", "field_78406_i");
                    vertexCount_field.setAccessible(true);
                }
            }
            catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Log.warn("Some mod has replaced Minecraft's tesselator. Help, without that one I don't now where to render!\n" + e);
                String b = "";
                for (Field f : Tessellator.class.getDeclaredFields()) {
                    b = b + " <" + f.toGenericString() + ">";
                }
                Log.warn("Fields available:" + b);
                derpedTess = true;
            }
        }
    }

    private static Field getField(String name, String alternative) throws NoSuchFieldException, SecurityException {
        Field result;
        try {
            result = Tessellator.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            result = Tessellator.class.getDeclaredField(alternative);
        }
        return result;
    }

    public boolean clearGLerrors() {
        for (int i = 0; i < 10; ++i) {
            this.lastError = GL11.glGetError();
            if (this.lastError != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasGLerrors() {
        this.lastError = GL11.glGetError();
        return this.lastError != 0;
    }

    static {
        derpedTess = false;
        glErrorCount = 0;
    }
}

