/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class FaceRenderer {
    public static final float[] stdBrightness = new float[6];
    public static final float[] stdBrightnessInside = new float[6];
    public static int[][] sideAndFacingToSpriteOffset;
    public static final Vector3d[] verts;
    private static final ForgeDirection[] AROUND;
    private static Block block;
    private static IBlockAccess world;
    private static BlockCoord bc;
    private static final double ROTATION_AMOUNT = 1.5707963267948966;

    private FaceRenderer() {
    }

    public static void setupVertices(BoundingBox bound, VertexTransform xForm) {
        verts[0].set((double)bound.minX, (double)bound.minY, (double)bound.minZ);
        verts[1].set((double)bound.maxX, (double)bound.minY, (double)bound.minZ);
        verts[2].set((double)bound.maxX, (double)bound.maxY, (double)bound.minZ);
        verts[3].set((double)bound.minX, (double)bound.maxY, (double)bound.minZ);
        verts[4].set((double)bound.minX, (double)bound.minY, (double)bound.maxZ);
        verts[5].set((double)bound.maxX, (double)bound.minY, (double)bound.maxZ);
        verts[6].set((double)bound.maxX, (double)bound.maxY, (double)bound.maxZ);
        verts[7].set((double)bound.minX, (double)bound.maxY, (double)bound.maxZ);
        if (xForm != null) {
            for (Vector3d vec : verts) {
                xForm.apply(vec);
            }
        }
    }

    public static void addVecWithUV(Vector3d vec, double u, double v) {
        Tessellator.field_78398_a.func_78374_a(vec.x, vec.y, vec.z, u, v);
    }

    public static void renderCube(BoundingBox bb, IIcon[] icons, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        FaceRenderer.setupVertices(bb, xForm);
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            IIcon tex = icons[face.ordinal()];
            if (tex == null) continue;
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            FaceRenderer.renderSingleFace(face, minU, maxU, minV, maxV, xForm, brightnessPerSide, inside);
        }
    }

    public static void renderCube(BoundingBox bb, IIcon tex, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        FaceRenderer.setupVertices(bb, xForm);
        if (tex != null) {
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                FaceRenderer.renderSingleFace(face, minU, maxU, minV, maxV, xForm, brightnessPerSide, inside);
            }
        }
    }

    public static void renderSkirt(BoundingBox bb, IIcon[] icons, double texMinU, double texMaxU, double texMinV, double texMaxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        for (ForgeDirection face : AROUND) {
            IIcon tex = icons[face.ordinal()];
            if (tex == null) continue;
            FaceRenderer.renderSingleFace(bb, face, tex, texMinU, texMaxU, texMinV, texMaxV, xForm, brightnessPerSide, inside);
        }
    }

    public static void renderSkirt(BoundingBox bb, IIcon tex, double texMinU, double texMaxU, double texMinV, double texMaxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        if (tex != null) {
            for (ForgeDirection face : AROUND) {
                FaceRenderer.renderSingleFace(bb, face, tex, texMinU, texMaxU, texMinV, texMaxV, xForm, brightnessPerSide, inside);
            }
        }
    }

    public static void renderSkirt(BoundingBox bb, IIcon[] icons, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        for (ForgeDirection face : AROUND) {
            IIcon tex = icons[face.ordinal()];
            if (tex == null) continue;
            FaceRenderer.renderSingleFace(bb, face, tex, 0.0, 16.0, 0.0, 16.0, xForm, brightnessPerSide, inside);
        }
    }

    public static void renderSkirt(BoundingBox bb, IIcon tex, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        if (tex != null) {
            for (ForgeDirection face : AROUND) {
                FaceRenderer.renderSingleFace(bb, face, tex, 0.0, 16.0, 0.0, 16.0, xForm, brightnessPerSide, inside);
            }
        }
    }

    public static void renderSingleFace(BoundingBox bb, ForgeDirection face, IIcon[] icons, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        FaceRenderer.setupVertices(bb, xForm);
        IIcon tex = icons[face.ordinal()];
        if (tex != null) {
            float minU = tex.func_94209_e();
            float maxU = tex.func_94212_f();
            float minV = tex.func_94206_g();
            float maxV = tex.func_94210_h();
            FaceRenderer.renderSingleFace(face, minU, maxU, minV, maxV, xForm, brightnessPerSide, inside);
        }
    }

    public static void renderSingleFace(BoundingBox bb, ForgeDirection face, IIcon[] icons, double texMinU, double texMaxU, double texMinV, double texMaxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        IIcon tex = icons[face.ordinal()];
        if (tex != null) {
            FaceRenderer.renderSingleFace(bb, face, tex, texMinU, texMaxU, texMinV, texMaxV, xForm, brightnessPerSide, inside);
        }
    }

    public static void renderSingleFace(BoundingBox bb, ForgeDirection face, IIcon tex, double texMinU, double texMaxU, double texMinV, double texMaxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        FaceRenderer.setupVertices(bb, xForm);
        float minU = tex.func_94214_a(texMinU);
        float maxU = tex.func_94214_a(texMaxU);
        float minV = tex.func_94207_b(texMinV);
        float maxV = tex.func_94207_b(texMaxV);
        FaceRenderer.renderSingleFace(face, minU, maxU, minV, maxV, xForm, brightnessPerSide, inside);
    }

    public static void renderSingleFace(BoundingBox bb, ForgeDirection face, IIcon tex, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        FaceRenderer.setupVertices(bb, xForm);
        float minU = tex.func_94209_e();
        float maxU = tex.func_94212_f();
        float minV = tex.func_94206_g();
        float maxV = tex.func_94210_h();
        FaceRenderer.renderSingleFace(face, minU, maxU, minV, maxV, xForm, brightnessPerSide, inside);
    }

    public static void setLightingReference(IBlockAccess world, Block block, BlockCoord bc) {
        FaceRenderer.world = world;
        FaceRenderer.block = block;
        FaceRenderer.bc = bc;
    }

    public static void setLightingReference(IBlockAccess world, Block block, int x, int y, int z) {
        FaceRenderer.world = world;
        FaceRenderer.block = block;
        bc = new BlockCoord(x, y, z);
    }

    public static void clearLightingReference() {
        world = null;
        block = null;
        bc = null;
    }

    public static void setLighting(int blockLight, int skylight) {
        int mixedBrightness = (blockLight & 0xF) << 4 | (skylight & 0xF) << 20;
        Tessellator.field_78398_a.func_78380_c(mixedBrightness);
        world = null;
        block = null;
        bc = null;
    }

    public static ForgeDirection rotate(VertexTransform xForm, ForgeDirection dir) {
        if (xForm instanceof VertexRotationFacing) {
            double angle = ((VertexRotationFacing)xForm).getAngle();
            if (angle < 0.7853981633974483 || angle >= 5.497787143782138) {
                return dir;
            }
            if (angle >= 0.7853981633974483 && angle < 2.356194490192345) {
                return dir.getRotation(ForgeDirection.DOWN);
            }
            if (angle >= 2.356194490192345 && angle < 3.9269908169872414) {
                return dir.getOpposite();
            }
            if (angle >= 3.9269908169872414 && angle < 5.497787143782138) {
                return dir.getRotation(ForgeDirection.UP);
            }
        }
        return dir;
    }

    public static void renderSingleFace(ForgeDirection face, float minU, float maxU, float minV, float maxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
        ForgeDirection normal = FaceRenderer.rotate(xForm, inside ? face.getOpposite() : face);
        Tessellator.field_78398_a.func_78375_b((float)normal.offsetX, (float)normal.offsetY, (float)normal.offsetZ);
        if (block != null && world != null && bc != null) {
            BlockCoord to = bc.getLocation(normal);
            int mixedBrightnessForBlock = block.func_149677_c(world, to.x, to.y, to.z);
            if (mixedBrightnessForBlock == 0) {
                Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, FaceRenderer.bc.x, FaceRenderer.bc.y, FaceRenderer.bc.z));
            } else {
                Tessellator.field_78398_a.func_78380_c(mixedBrightnessForBlock);
            }
        }
        if (brightnessPerSide != null) {
            float cm = brightnessPerSide[normal.ordinal()];
            Tessellator.field_78398_a.func_78386_a(cm, cm, cm);
        }
        if (inside) {
            switch (face) {
                case NORTH: {
                    FaceRenderer.addVecWithUV(verts[0], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[1], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[2], minU, minV);
                    FaceRenderer.addVecWithUV(verts[3], maxU, minV);
                    break;
                }
                case SOUTH: {
                    FaceRenderer.addVecWithUV(verts[5], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[4], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[7], minU, minV);
                    FaceRenderer.addVecWithUV(verts[6], maxU, minV);
                    break;
                }
                case UP: {
                    FaceRenderer.addVecWithUV(verts[2], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[6], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[7], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[3], minU, minV);
                    break;
                }
                case DOWN: {
                    FaceRenderer.addVecWithUV(verts[1], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[0], minU, minV);
                    FaceRenderer.addVecWithUV(verts[4], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[5], maxU, maxV);
                    break;
                }
                case EAST: {
                    FaceRenderer.addVecWithUV(verts[6], minU, minV);
                    FaceRenderer.addVecWithUV(verts[2], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[1], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[5], minU, maxV);
                    break;
                }
                case WEST: {
                    FaceRenderer.addVecWithUV(verts[4], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[0], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[3], minU, minV);
                    FaceRenderer.addVecWithUV(verts[7], maxU, minV);
                    break;
                }
            }
        } else {
            switch (face) {
                case NORTH: {
                    FaceRenderer.addVecWithUV(verts[1], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[0], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[3], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[2], minU, minV);
                    break;
                }
                case SOUTH: {
                    FaceRenderer.addVecWithUV(verts[4], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[5], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[6], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[7], minU, minV);
                    break;
                }
                case UP: {
                    FaceRenderer.addVecWithUV(verts[6], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[2], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[3], minU, minV);
                    FaceRenderer.addVecWithUV(verts[7], minU, maxV);
                    break;
                }
                case DOWN: {
                    FaceRenderer.addVecWithUV(verts[0], minU, minV);
                    FaceRenderer.addVecWithUV(verts[1], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[5], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[4], minU, maxV);
                    break;
                }
                case EAST: {
                    FaceRenderer.addVecWithUV(verts[2], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[6], minU, minV);
                    FaceRenderer.addVecWithUV(verts[5], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[1], maxU, maxV);
                    break;
                }
                case WEST: {
                    FaceRenderer.addVecWithUV(verts[0], minU, maxV);
                    FaceRenderer.addVecWithUV(verts[4], maxU, maxV);
                    FaceRenderer.addVecWithUV(verts[7], maxU, minV);
                    FaceRenderer.addVecWithUV(verts[3], minU, minV);
                }
            }
        }
    }

    static {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            FaceRenderer.stdBrightness[dir.ordinal()] = RenderUtil.getColorMultiplierForFace((ForgeDirection)dir);
            FaceRenderer.stdBrightnessInside[dir.ordinal()] = RenderUtil.getColorMultiplierForFace((ForgeDirection)dir) * 0.75f;
        }
        sideAndFacingToSpriteOffset = new int[][]{{3, 2, 0, 0, 0, 0}, {2, 3, 1, 1, 1, 1}, {1, 1, 3, 2, 4, 5}, {0, 0, 2, 3, 5, 4}, {4, 5, 5, 4, 3, 2}, {5, 4, 4, 5, 2, 3}};
        verts = new Vector3d[8];
        for (int i = 0; i < verts.length; ++i) {
            FaceRenderer.verts[i] = new Vector3d();
        }
        AROUND = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    }
}

