/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.plant;

import com.InfinityRaider.AgriCraft.api.v1.ICropPlant;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.ItemWithMeta;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.config.ItemHelper;
import info.loenwind.enderioaddons.config.WeightedItemStack;
import info.loenwind.enderioaddons.machine.afarm.BlockAfarm;
import info.loenwind.enderioaddons.machine.part.ItemMachinePart;
import info.loenwind.enderioaddons.machine.part.MachinePart;
import info.loenwind.enderioaddons.plant.EioaGrowthRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class EioaCropPlant
implements ICropPlant {
    private final ItemStack seed;
    public final EioaGrowthRequirement eioaGrowthRequirement = new EioaGrowthRequirement();

    public EioaCropPlant() {
        this.seed = new ItemStack((Item)ItemMachinePart.itemMachinePart, 1, MachinePart.SEED.ordinal());
    }

    public int tier() {
        return crazypants.enderio.config.Config.useHardRecipes ? Config.seedsTierHard.getInt() : Config.seedsTierEasy.getInt();
    }

    public ItemStack getSeed() {
        return this.seed;
    }

    public Block getBlock() {
        return null;
    }

    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> allfruits = new ArrayList<ItemStack>();
        for (WeightedItemStack fruit : ItemHelper.readWeightedList(Config.plantDropsHighGain)) {
            allfruits.add(fruit.getStack());
        }
        for (WeightedItemStack fruit : ItemHelper.readWeightedList(Config.plantDropsLowGain)) {
            if (EioaCropPlant.contains(allfruits, fruit.getStack())) continue;
            allfruits.add(fruit.getStack());
        }
        return allfruits;
    }

    private static boolean contains(List<ItemStack> list, ItemStack stack) {
        for (ItemStack itemStack : list) {
            if (!itemStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getRandomFruit(Random rand) {
        return ((WeightedItemStack)WeightedRandom.func_76271_a((Random)rand, ItemHelper.readWeightedList(Config.plantDropsHighGain))).getStack().func_77946_l();
    }

    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        int i;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (i = 0; i < (gain > 2 ? 2 : 1); ++i) {
            result.add(((WeightedItemStack)WeightedRandom.func_76271_a((Random)rand, ItemHelper.readWeightedList(Config.plantDropsLowGain))).getStack().func_77946_l());
        }
        if (gain > 5) {
            for (i = 0; i < (gain == 10 ? 2 : 1); ++i) {
                result.add(this.getRandomFruit(rand));
            }
        }
        return result;
    }

    public boolean onHarvest(World world, int x, int y, int z, EntityPlayer player) {
        return player != null && !(player instanceof FakePlayer) || Config.seedsAutomaticHarvestingEnabled.getBoolean();
    }

    public void onSeedPlanted(World world, int x, int y, int z) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(new BlockCoord(x, y, z)), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0));
    }

    public void onPlantRemoved(World world, int x, int y, int z) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(new BlockCoord(x, y, z)), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0));
    }

    public boolean canBonemeal() {
        return Config.seedsBonemealEnabled.getBoolean();
    }

    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage) {
        if (!EioaCropPlant.isMature(oldGrowthStage)) {
            EioaGrowthRequirement.usePower(world, x, y, z);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(new BlockCoord(x, y, z)), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0));
            return true;
        }
        return false;
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return this.eioaGrowthRequirement.canGrow(world, x, y, z);
    }

    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        return EioaCropPlant.isMature(world.func_72805_g(x, y, z));
    }

    private static boolean isMature(int meta) {
        return meta >= 7;
    }

    public float getHeight(int meta) {
        return 0.8125f;
    }

    public IIcon getPlantIcon(int growthStage) {
        return BlockAfarm.darkPlantIcons[growthStage];
    }

    public boolean renderAsFlower() {
        return false;
    }

    public String getInformation() {
        return "enderioaddons.agricraft_journal.darkplant";
    }

    public boolean overrideRendering() {
        return false;
    }

    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
    }

    public ItemWithMeta getSeedIWM() {
        return new ItemWithMeta(this.seed.func_77973_b(), this.seed.func_77960_j());
    }

    public IGrowthRequirement getGrowthRequirement() {
        return this.eioaGrowthRequirement;
    }
}

