/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks.engine;

import com.enderio.core.common.util.ItemUtil;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.waterworks.engine.Component;
import info.loenwind.enderioaddons.machine.waterworks.engine.Material;
import info.loenwind.enderioaddons.machine.waterworks.engine.Stash;
import info.loenwind.enderioaddons.machine.waterworks.engine.Water;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class Engine {
    private static final int num_levels = 5;
    @Nonnull
    private final List<Water> levels = new ArrayList<Water>();
    private int waterWorksWaterReductionPercentageUsedInCalcs = 0;
    @Nonnull
    private final Water config;
    private double progress = 0.0;

    public Engine(@Nonnull Water config) {
        this.config = config;
        this.computeLevels();
    }

    private void computeLevels() {
        if (this.waterWorksWaterReductionPercentageUsedInCalcs != Config.waterWorksWaterReductionPercentage.getInt()) {
            this.waterWorksWaterReductionPercentageUsedInCalcs = Config.waterWorksWaterReductionPercentage.getInt();
            this.levels.clear();
            Stash input = this.config;
            for (int i = 0; i < 5; ++i) {
                input = this.computeLevel(input, i);
            }
        }
    }

    @Nonnull
    private Stash computeLevel(@Nonnull Stash input, int level) {
        Stash remains = new Stash();
        Water used = new Water();
        remains.getContents().putAll(input.getContents());
        Collections.sort(this.config.getMaterials());
        for (Material material : this.config.getMaterials()) {
            if (material.getItem().getItemStack() == null) continue;
            boolean good2go = true;
            for (Component comp : material.getComponents()) {
                Double available = remains.getContents().get(comp.getName());
                if (available != null && !(available < comp.getGranularity())) continue;
                good2go = false;
            }
            if (!good2go) continue;
            used.getMaterials().add(material);
            while (good2go) {
                for (Component comp : material.getComponents()) {
                    Double needed = comp.getGranularity();
                    Double available = remains.getContents().get(comp.getName());
                    remains.getContents().put(comp.getName(), available - needed);
                    if (used.getContents().get(comp.getName()) == null) {
                        used.getContents().put(comp.getName(), needed * comp.getFactor());
                    } else {
                        used.getContents().put(comp.getName(), used.getContents().get(comp.getName()) + needed * comp.getFactor());
                    }
                    if (!(available < 2.0 * needed)) continue;
                    good2go = false;
                }
            }
        }
        for (Map.Entry entry : remains.getContents().entrySet()) {
            entry.setValue((Double)entry.getValue() * 100.0 / (double)Config.waterWorksWaterReductionPercentage.getInt());
        }
        this.levels.add(level, used);
        return remains;
    }

    public void processWater(@Nonnull Stash stash, int level, double factor) {
        this.computeLevels();
        if (level < 0) {
            return;
        }
        Stash use = this.levels.get(level);
        for (Map.Entry<String, Double> comp : use.getContents().entrySet()) {
            stash.getContents().put(comp.getKey(), (stash.getContents().containsKey(comp.getKey()) ? stash.getContents().get(comp.getKey()) : 0.0) + comp.getValue() * factor);
        }
    }

    public double getLastProgress() {
        return this.progress;
    }

    @Nonnull
    public CreationResult createItems(@Nonnull Stash stash, int level, @Nonnull IInventory inv, int startSlot, int endSlot, boolean doCreate) {
        this.computeLevels();
        if (level < 0) {
            return CreationResult.NO_INPUTS;
        }
        boolean haveInserted = false;
        this.progress = 0.0;
        for (Material mat : this.levels.get(level).getMaterials()) {
            double needed_mass = mat.getVolume() * mat.getDensity();
            int parts = 0;
            for (Component comp : mat.getComponents()) {
                parts += comp.getCount();
            }
            double needed_mass_per_part = needed_mass / (double)parts;
            boolean good2go = true;
            while (good2go) {
                double this_progress;
                double all_needed = 0.0;
                double all_there = 0.0;
                for (Component comp : mat.getComponents()) {
                    double needed = (double)comp.getCount() * needed_mass_per_part;
                    all_needed += needed;
                    double there = stash.getContents().containsKey(comp.getName()) ? stash.getContents().get(comp.getName()) : 0.0;
                    all_there += there;
                    if (!(there < needed)) continue;
                    good2go = false;
                }
                if (good2go) {
                    ItemStack item = mat.getItem().getItemStack();
                    if (ItemUtil.doInsertItem((IInventory)inv, (int)startSlot, (int)endSlot, (ItemStack)item, (boolean)doCreate) > 0) {
                        if (!doCreate) {
                            return CreationResult.OK;
                        }
                        haveInserted = true;
                        for (Component comp : mat.getComponents()) {
                            stash.getContents().put(comp.getName(), stash.getContents().get(comp.getName()) - (double)comp.getCount() * needed_mass_per_part);
                        }
                        continue;
                    }
                    return haveInserted ? CreationResult.LOW_OUTPUTS : CreationResult.NO_OUTPUTS;
                }
                if (!(all_needed > 0.0) || !((this_progress = all_there / all_needed) > this.progress)) continue;
                this.progress = this_progress;
            }
        }
        return haveInserted ? CreationResult.OK : CreationResult.NO_INPUTS;
    }

    public static enum CreationResult {
        NO_INPUTS,
        OK,
        LOW_OUTPUTS,
        NO_OUTPUTS;

    }
}

