/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.spawner.DummyRecipe;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class TaskWaterworks
implements IPoweredTask {
    private float usedEnergy = 0.0f;
    private final float requiredEnergy;
    private final float liquidinfactor;
    public static final String KEY_USED_ENERGY = "usedEnergy";
    public static final String KEY_REQUIRED_ENERGY = "requiredEnergy";
    public static final String KEY_LIQUID_IN_FACTOR = "liquidinfactor";

    public TaskWaterworks(float requiredEnergy, float liquidinfactor) {
        this.requiredEnergy = requiredEnergy;
        this.liquidinfactor = liquidinfactor;
    }

    private TaskWaterworks(float requiredEnergy, float usedEnergy, float liquidinfactor) {
        this(requiredEnergy, liquidinfactor);
        this.usedEnergy = usedEnergy;
    }

    public void update(float availableEnergy) {
        this.usedEnergy += availableEnergy;
    }

    public boolean isComplete() {
        return this.usedEnergy >= this.requiredEnergy;
    }

    public float getProgress() {
        return MathHelper.func_76131_a((float)(this.usedEnergy / this.requiredEnergy), (float)0.0f, (float)1.0f);
    }

    public IMachineRecipe.ResultStack[] getCompletedResult() {
        return new IMachineRecipe.ResultStack[0];
    }

    public float getRequiredEnergy() {
        return this.requiredEnergy;
    }

    public float getChance() {
        return 0.0f;
    }

    public RecipeBonusType getBonusType() {
        return RecipeBonusType.NONE;
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74776_a(KEY_USED_ENERGY, this.usedEnergy);
        nbtRoot.func_74776_a(KEY_REQUIRED_ENERGY, this.requiredEnergy);
        nbtRoot.func_74776_a(KEY_LIQUID_IN_FACTOR, this.liquidinfactor);
    }

    @Nullable
    public static IPoweredTask readFromNBT(NBTTagCompound nbtRoot) {
        return new TaskWaterworks(nbtRoot.func_74760_g(KEY_REQUIRED_ENERGY), nbtRoot.func_74760_g(KEY_USED_ENERGY), nbtRoot.func_74760_g(KEY_LIQUID_IN_FACTOR));
    }

    public IMachineRecipe getRecipe() {
        return new DummyRecipe();
    }

    public MachineRecipeInput[] getInputs() {
        return new MachineRecipeInput[0];
    }

    public float getLiquidInFactor() {
        return this.liquidinfactor;
    }
}

