/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks;

import info.loenwind.enderioaddons.fluid.Fluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;

public class ColMap {
    private static final int COL_INPUT_FLUID = 0;
    private static final int COL_INPUT_FLUID_ID = 1;
    private static final int COL_OUTPUT_FLUID = 2;
    private static final int COL_OUTPUT_FLUID_ID = 3;
    private static final int COL_LEVEL = 4;
    private static final int COL_OUTPUT_AMOUNT = 5;
    @Nonnull
    private final Object[] x;
    private final int cols = 6;
    private final int elements;

    public ColMap(int elements) {
        this.x = new Object[elements * 6];
        this.elements = elements;
    }

    @Nullable
    private Object get(int col, int elem) {
        return this.x[elem * 6 + col];
    }

    private void set(int col, int elem, @Nullable Object o) {
        this.x[elem * 6 + col] = o;
    }

    private boolean contains(int col, @Nullable Object o) {
        for (int i = 0; i < this.elements; ++i) {
            Object c = this.get(col, i);
            if ((o != null || c != null) && (o == null || !o.equals(c))) continue;
            return true;
        }
        return false;
    }

    private int find(int col, @Nullable Object o) {
        for (int i = 0; i < this.elements; ++i) {
            Object c = this.get(col, i);
            if ((o != null || c != null) && (o == null || !o.equals(c))) continue;
            return i;
        }
        return -1;
    }

    public boolean containsInputLiquid(@Nonnull Fluid l) {
        return this.contains(1, l.getID());
    }

    public boolean isMatchingInputForOutput(@Nullable Fluid input, @Nullable Fluid output) {
        if (input == null || output == null) {
            return false;
        }
        int elem = this.find(3, output.getID());
        if (elem < 0) {
            return false;
        }
        Object result = this.get(1, elem);
        return result != null && result.equals(input.getID());
    }

    public boolean isMatchingOutputForInput(@Nullable Fluid input, @Nullable Fluid output) {
        if (input == null) {
            return false;
        }
        if (output == null) {
            return true;
        }
        int elem = this.find(1, input.getID());
        if (elem < 0) {
            return false;
        }
        Object expectedOutput = this.get(3, elem);
        return expectedOutput != null && expectedOutput.equals(output.getID());
    }

    public int getLevelFromInput(@Nullable Fluid input) {
        if (input == null) {
            return -1;
        }
        int elem = this.find(1, input.getID());
        if (elem < 0) {
            return -1;
        }
        Object result = this.get(4, elem);
        return result != null ? (Integer)result : -1;
    }

    public int getOutputAmountFromInput(@Nullable Fluid input) {
        if (input == null) {
            return -1;
        }
        int elem = this.find(1, input.getID());
        if (elem < 0) {
            return -1;
        }
        Object result = this.get(5, elem);
        return result != null ? (Integer)result : -1;
    }

    public Fluid getOutputFromInput(@Nullable Fluid input) {
        if (input == null) {
            return null;
        }
        int elem = this.find(1, input.getID());
        if (elem < 0) {
            return null;
        }
        return (Fluid)this.get(2, elem);
    }

    public void set(int elem, @Nonnull Fluid input, @Nonnull Fluids output, int level, int amount) {
        this.set(0, elem, input);
        this.set(1, elem, (Object)input.getID());
        this.set(2, elem, output.getFluid());
        this.set(3, elem, (Object)output.getFluid().getID());
        this.set(4, elem, (Object)level);
        this.set(5, elem, (Object)amount);
    }

    public void set(int elem, @Nonnull Fluids input, @Nonnull Fluids output, int level, int amount) {
        this.set(0, elem, input.getFluid());
        this.set(1, elem, (Object)input.getFluid().getID());
        this.set(2, elem, output.getFluid());
        this.set(3, elem, (Object)output.getFluid().getID());
        this.set(4, elem, (Object)level);
        this.set(5, elem, (Object)amount);
    }

    public void set(int elem, @Nonnull Fluids input, int level) {
        this.set(0, elem, input.getFluid());
        this.set(1, elem, (Object)input.getFluid().getID());
        this.set(2, elem, null);
        this.set(3, elem, null);
        this.set(4, elem, (Object)level);
        this.set(5, elem, (Object)0);
    }
}

