/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.pmon;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.baseclass.TileEnderIOAddons;
import info.loenwind.enderioaddons.common.SideRestriction;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.pmon.BlockPMon;
import info.loenwind.enderioaddons.machine.pmon.DynaTextureProvider;
import info.loenwind.enderioaddons.machine.pmon.PacketPMon;
import info.loenwind.enderioaddons.machine.pmon.StatCollector;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Storable
public class TilePMon
extends TileEnderIOAddons {
    private static final int iconUpdateRate = 1500;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats10s = new StatCollector(2);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats01m = new StatCollector(12);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats10m = new StatCollector(120);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats01h = new StatCollector(720);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats06h = new StatCollector(7200);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats24h = new StatCollector(17280);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats07d = new StatCollector(120960);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector statsIcn = new StatCollector(1500, 28);
    protected StatCollector[] stats = new StatCollector[]{this.stats10s, this.stats01m, this.stats10m, this.stats01h, this.stats06h, this.stats24h, this.stats07d, this.statsIcn};
    private int slowstart = 100;
    private static final long bit62 = Integer.MAX_VALUE;
    private static final long bit63 = 0xFFFFFFFEL;
    @SideRestriction(value=Side.CLIENT)
    private long[] lastUpdateRequest = new long[this.stats.length];
    @SideRestriction(value=Side.CLIENT)
    protected Object dynaTextureProvider = null;
    @SideRestriction(value=Side.CLIENT)
    protected int[] iconMins = new int[32];
    @SideRestriction(value=Side.CLIENT)
    protected int[] iconMaxs = new int[32];

    public TilePMon() {
        super(new SlotDefinition(0, 0, 0));
    }

    public String getMachineName() {
        return BlockPMon.ModObject_blockPMon.unlocalisedName;
    }

    protected boolean isMachineItemValidForSlot(int i, @Nullable ItemStack item) {
        return false;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.slowstart > 0) {
            --this.slowstart;
            return false;
        }
        this.usePower();
        NetworkPowerManager pm = this.getPowerManager();
        if (pm != null) {
            int capPower = TilePMon.logSrqt2(pm.getPowerInCapacitorBanks());
            for (StatCollector statCollector : this.stats) {
                statCollector.addValue(capPower);
            }
        }
        if (this.shouldDoWorkThisTick(150) && Config.pMonEnableDynamicTextures.getBoolean()) {
            PacketHandler.sendToAllAround((IMessage)PacketPMon.sendUpdate(this, this.stats.length - 1), (TileEntity)this);
        }
        return false;
    }

    private static int logSrqt2(long value) {
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0xFFFFFFFEL) {
            return 63;
        }
        if (value >= Integer.MAX_VALUE) {
            return 62;
        }
        for (int i = 30; i >= 0; --i) {
            if ((value & (long)(1 << i)) == 0L) continue;
            if (i == 0) {
                return 1;
            }
            if ((value & (long)(1 << i - 1)) != 0L) {
                return i * 2 + 1;
            }
            return i * 2;
        }
        return 0;
    }

    private NetworkPowerManager getPowerManager() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            NetworkPowerManager pm;
            AbstractConduitNetwork n;
            IPowerConduit con = (IPowerConduit)ConduitUtil.getConduit((World)this.field_145850_b, (TileEntity)this, (ForgeDirection)dir, IPowerConduit.class);
            if (con == null || !((n = con.getNetwork()) instanceof PowerConduitNetwork) || (pm = ((PowerConduitNetwork)n).getPowerManager()) == null) continue;
            return pm;
        }
        return null;
    }

    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return new ContinuousTask((float)this.getPowerUsePerTick());
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return this.createTask(null);
    }

    public void onCapacitorTypeChange() {
        this.setCapacitor((ICapacitor)new BasicCapacitor(100, 10000, 10));
        this.currentTask = this.createTask(null);
    }

    @SideOnly(value=Side.CLIENT)
    public StatCollector getStatCollector(int id) {
        if (id < 0 || id >= this.stats.length) {
            return null;
        }
        long now = EnderIO.proxy.getTickCount();
        if (this.lastUpdateRequest[id] < now) {
            this.lastUpdateRequest[id] = now + 10L;
            PacketHandler.INSTANCE.sendToServer(PacketPMon.requestUpdate(this, id));
        }
        return this.stats[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        if (this.dynaTextureProvider == null) {
            this.dynaTextureProvider = new DynaTextureProvider(this);
        }
        ((DynaTextureProvider)this.dynaTextureProvider).bindTexture();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        super.func_145843_s();
        if (this.dynaTextureProvider != null) {
            ((DynaTextureProvider)this.dynaTextureProvider).free();
            this.dynaTextureProvider = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int[][] getIconValues() {
        return this.statsIcn.getValues();
    }
}

