/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.pmon;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.enderioaddons.machine.pmon.DynaTextureProvider;
import info.loenwind.enderioaddons.machine.pmon.StatArray;
import info.loenwind.enderioaddons.machine.pmon.TilePMon;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketPMon
extends MessageTileEntity<TilePMon> {
    private int no;
    private int collectCount;
    private int pos;
    private byte[] data;

    public PacketPMon() {
    }

    private PacketPMon(TilePMon tile) {
        super((TileEntity)tile);
    }

    public static IMessage requestUpdate(TilePMon te, int no) {
        PacketPMon msg = new PacketPMon(te);
        msg.no = no;
        msg.collectCount = -1;
        msg.pos = -1;
        msg.data = null;
        return msg;
    }

    public static IMessage sendUpdate(TilePMon te, int no) {
        PacketPMon msg = new PacketPMon(te);
        msg.no = no;
        msg.collectCount = te.stats[no].getCollectCount();
        msg.pos = te.stats[no].getPos();
        msg.data = te.stats[no].getData();
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.no = buf.readShort();
        this.collectCount = buf.readShort();
        if (this.collectCount >= 0) {
            this.pos = buf.readShort();
            this.data = new byte[StatArray.BYTES * 2];
            buf.readBytes(this.data);
        } else {
            this.pos = -1;
            this.data = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.no);
        buf.writeShort(this.collectCount);
        if (this.collectCount >= 0) {
            buf.writeShort(this.pos);
            buf.writeBytes(this.data);
        }
    }

    public static class ClientHandler
    implements IMessageHandler<PacketPMon, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPMon msg, MessageContext ctx) {
            TilePMon te;
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            if (player != null && (te = (TilePMon)msg.getTileEntity(player.field_70170_p)) != null && msg.no >= 0 && msg.no < te.stats.length) {
                te.stats[msg.no].setCollectCount(msg.collectCount);
                te.stats[msg.no].setPos(msg.pos);
                te.stats[msg.no].setData(msg.data);
                if (msg.no == te.stats.length - 1 && te.dynaTextureProvider != null) {
                    ((DynaTextureProvider)te.dynaTextureProvider).updateTexture();
                }
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketPMon, IMessage> {
        public IMessage onMessage(PacketPMon msg, MessageContext ctx) {
            TilePMon te = (TilePMon)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null && msg.no >= 0 && msg.no < te.stats.length && ctx.getServerHandler() != null && ctx.getServerHandler().field_147369_b != null) {
                PacketHandler.sendTo((IMessage)PacketPMon.sendUpdate(te, msg.no), (EntityPlayerMP)ctx.getServerHandler().field_147369_b);
            }
            return null;
        }
    }
}

