/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.magcharger;

import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.Profiler;
import info.loenwind.enderioaddons.common.SideRestriction;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.flag.BlockFlag;
import info.loenwind.enderioaddons.machine.flag.ItemFlag;
import info.loenwind.enderioaddons.machine.framework.AbstractTileFramework;
import info.loenwind.enderioaddons.machine.magcharger.BlockMagCharger;
import info.loenwind.enderioaddons.network.INetworkUpdatable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Storable
public class TileMagCharger
extends AbstractTileFramework
implements INetworkUpdatable {
    @Store
    protected int progress = -1;
    @Store(value={Store.StoreFor.CLIENT})
    public int itemsInQueue = 0;
    @SideRestriction(value=Side.CLIENT)
    public int renderOffset = 0;
    @SideRestriction(value=Side.CLIENT)
    public float renderLastProgress = 0.0f;
    private static final String[] soundsIds = new String[]{"machine.magcharger", "machine.magcharger.cont"};
    private static final int[] soundDurations = new int[]{19, 10};
    private final long[] lastSoundTick = new long[soundsIds.length];

    public TileMagCharger() {
        super(new SlotDefinition(1, 1, 1));
    }

    public String getMachineName() {
        return BlockMagCharger.ModObject_blockMagCharger.unlocalisedName;
    }

    public void init() {
        super.init();
    }

    public void func_145834_a(World p_145834_1_) {
        super.func_145834_a(p_145834_1_);
        EnderIOAddons.network.register(this);
    }

    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (this.slotDefinition.isInputSlot(i)) {
            return itemstack != null && itemstack.func_77973_b() != null && itemstack.func_77973_b() instanceof ItemFlag && itemstack.func_77960_j() != 0;
        }
        return false;
    }

    public boolean isActive() {
        return this.redstoneCheckPassed && this.progress >= 0;
    }

    protected boolean processTasks(boolean rsCheckPassed) {
        boolean needClientUpdate = false;
        if (rsCheckPassed) {
            long id = Profiler.server.start();
            if (this.progress > 0 && this.usePower(Config.magcMagnetizingPowerPerTick.getInt())) {
                this.progress -= this.getCapacitorBasedSpeed();
                if (this.progress < 0) {
                    this.progress = 0;
                }
            }
            if (this.progress == 0 && (this.outputSlotIsEmpty() || this.outputSlotsIsNotFull())) {
                if (this.outputSlotIsEmpty()) {
                    this.inventory[this.slotDefinition.getMinOutputSlot()] = new ItemStack((Block)BlockFlag.blockFlag, 1, 0);
                } else {
                    ++this.inventory[this.slotDefinition.getMinOutputSlot()].field_77994_a;
                }
                this.func_70296_d();
                this.usePower(Config.magcMagnetizingPowerPerTick.getInt());
                this.progress = -1;
                needClientUpdate = true;
            }
            if (this.progress < 0 && this.inputSlotIsNotEmpty() && (this.outputSlotIsEmpty() || this.outputSlotsIsNotFull())) {
                this.progress = Config.magcMagnetizingTicksPerItem.getInt() + 1;
                --this.inventory[this.slotDefinition.getMinInputSlot()].field_77994_a;
                if (this.inventory[this.slotDefinition.getMinInputSlot()].field_77994_a <= 0) {
                    this.inventory[this.slotDefinition.getMinInputSlot()] = null;
                }
                this.func_70296_d();
                this.playSound_in();
                needClientUpdate = true;
            }
            Profiler.server.stop(id, "magcharger tick");
        }
        this.itemsInQueue = this.inputSlotIsNotEmpty() ? this.inventory[this.slotDefinition.getMinInputSlot()].field_77994_a : 0;
        return needClientUpdate;
    }

    private boolean inputSlotIsNotEmpty() {
        return this.inventory[this.slotDefinition.getMinInputSlot()] != null;
    }

    private boolean outputSlotsIsNotFull() {
        return this.inventory[this.slotDefinition.getMinOutputSlot()].field_77994_a < this.inventory[this.slotDefinition.getMinOutputSlot()].func_77976_d();
    }

    private boolean outputSlotIsEmpty() {
        return this.inventory[this.slotDefinition.getMinOutputSlot()] == null;
    }

    public void playSound(int id) {
        if (crazypants.enderio.config.Config.machineSoundsEnabled && this.lastSoundTick[id] <= EnderIO.proxy.getTickCount()) {
            this.lastSoundTick[id] = EnderIO.proxy.getTickCount() + (long)soundDurations[id];
            this.func_145831_w().func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), EnderIOAddons.DOMAIN + ":" + soundsIds[id], this.getVolume(), 1.0f);
        }
    }

    private void playSound_in() {
        this.playSound(0);
    }

    public boolean canUsePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return EnderIOAddons.mode24 || (w < 1 ? 1 : w) <= this.getEnergyStored();
    }

    public boolean canUsePower(int wantToUse) {
        return EnderIOAddons.mode24 || wantToUse <= this.getEnergyStored();
    }

    public boolean usePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return this.usePower(w < 1 ? 1 : w);
    }

    public boolean usePower(int wantToUse) {
        if (EnderIOAddons.mode24) {
            return true;
        }
        if (wantToUse > this.getEnergyStored()) {
            return false;
        }
        this.setEnergyStored(this.getEnergyStored() - wantToUse);
        return true;
    }

    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.magcPowerIntakePerTick.getInt(), 10000, Config.magcMagnetizingPowerPerTick.getInt()));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.magcPowerIntakePerTick.getInt() * 2, 10000, Config.magcMagnetizingPowerPerTick.getInt()));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.magcPowerIntakePerTick.getInt() * 8, 10000, Config.magcMagnetizingPowerPerTick.getInt()));
            }
        }
    }

    private int getCapacitorBasedSpeed() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return 1;
            }
            case ACTIVATED_CAPACITOR: {
                return 2;
            }
            case ENDER_CAPACITOR: {
                return 8;
            }
        }
        return 1;
    }

    public float getProgressScaled() {
        if (this.progress <= 0) {
            return 0.0f;
        }
        return (float)(Config.magcMagnetizingTicksPerItem.getInt() + 1 - this.progress) / (Config.magcMagnetizingTicksPerItem.getFloat() + 1.0f);
    }

    @Override
    public void networkUpdate(int id, int data) {
        switch (id) {
            case 0: {
                this.progress = data;
                break;
            }
            case 1: {
                this.itemsInQueue = data;
                break;
            }
        }
    }

    @Override
    public int getNetworkUpdate(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.itemsInQueue;
            }
        }
        return 0;
    }

    @Override
    public int getNetworkUpdateCount() {
        return 2;
    }

    @Override
    public int getNetworkUpdateCheckInterval() {
        return 1;
    }
}

