/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.drain;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Log;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.machine.drain.IWaterSensitive;
import info.loenwind.waterhooks.WaterFormEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class InfiniteWaterSourceStopper {
    @Nonnull
    private static final InfiniteWaterSourceStopper instance = new InfiniteWaterSourceStopper();
    @Nonnull
    private final Map<Integer, Map<IWaterSensitive, Object>> teblMap = new HashMap<Integer, Map<IWaterSensitive, Object>>();

    @Nonnull
    public static InfiniteWaterSourceStopper getInstance() {
        return instance;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
            Log.info((String)(modContainer.getModId() + " version " + modContainer.getVersion() + " from " + modContainer.getSource().getName()));
        }
    }

    @SubscribeEvent
    public void onWaterForming(WaterFormEvent event) {
        World world = NullHelper.notnullM(event.world, "event.world");
        Map<IWaterSensitive, Object> tebl = this.teblMap.get(world.field_73011_w.field_76574_g);
        if (tebl != null) {
            BlockCoord bc = new BlockCoord(event.x, event.y, event.z);
            for (IWaterSensitive hook : tebl.keySet()) {
                if (!hook.preventInfiniteWaterForming(world, bc)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.teblMap.remove(event.world.field_73011_w.field_76574_g);
    }

    public void unregister(@Nonnull World world, @Nonnull IWaterSensitive hook) {
        Map<IWaterSensitive, Object> tebl = this.teblMap.get(world.field_73011_w.field_76574_g);
        if (tebl != null) {
            tebl.remove(hook);
            if (tebl.isEmpty()) {
                this.teblMap.remove(world.field_73011_w.field_76574_g);
            }
        }
    }

    public void register(@Nonnull World world, @Nonnull IWaterSensitive hook) {
        Map<IWaterSensitive, Object> tebl = this.teblMap.get(world.field_73011_w.field_76574_g);
        if (tebl == null) {
            tebl = new WeakHashMap<IWaterSensitive, Object>();
            this.teblMap.put(world.field_73011_w.field_76574_g, tebl);
        }
        tebl.put(hook, null);
    }
}

