/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.afarm;

import com.InfinityRaider.AgriCraft.api.API;
import com.InfinityRaider.AgriCraft.api.APIBase;
import com.InfinityRaider.AgriCraft.api.v1.APIv1;
import com.InfinityRaider.AgriCraft.api.v1.ICropPlant;
import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.farm.FakeFarmPlayer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.baseclass.TileEnderIOAddons;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.common.Profiler;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.afarm.AgriDetector;
import info.loenwind.enderioaddons.machine.afarm.BlockAfarm;
import info.loenwind.enderioaddons.machine.afarm.IAfarmControlModuleItem;
import info.loenwind.enderioaddons.machine.afarm.Notif;
import info.loenwind.enderioaddons.machine.afarm.NotifSet;
import info.loenwind.enderioaddons.machine.afarm.SlotDefinitionAfarm;
import info.loenwind.enderioaddons.machine.afarm.WorkTile;
import info.loenwind.enderioaddons.machine.afarm.module.CropModule;
import info.loenwind.enderioaddons.machine.afarm.module.CrossBreedModule;
import info.loenwind.enderioaddons.machine.afarm.module.CrossCropModule;
import info.loenwind.enderioaddons.machine.afarm.module.FertilizerModule;
import info.loenwind.enderioaddons.machine.afarm.module.HarvestModule;
import info.loenwind.enderioaddons.machine.afarm.module.IAfarmControlModule;
import info.loenwind.enderioaddons.machine.afarm.module.NSEWmodule;
import info.loenwind.enderioaddons.machine.afarm.module.PlantModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteCropsModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteCrossCropsModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteDestroyModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteFertilizerModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteHarvestingModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecutePlantingModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteTillModule;
import info.loenwind.enderioaddons.machine.afarm.module.execute.ExecuteWeedModule;
import info.loenwind.enderioaddons.machine.niard.RadiusIterator;
import info.loenwind.enderioaddons.machine.part.ItemMachinePart;
import info.loenwind.enderioaddons.machine.part.MachinePart;
import info.loenwind.enderioaddons.network.INetworkUpdatable;
import info.loenwind.enderioaddons.plant.EioaCropPlant;
import info.loenwind.enderioaddons.recipe.Recipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

@Storable
public class TileAfarm
extends TileEnderIOAddons
implements INetworkUpdatable {
    public static final int NUM_CONTROL_SLOTS = 6;
    public static final int NUM_CONTROL_STORAGE_SLOTS = 12;
    public static final int NUM_SEED_GHOST_SLOTS = 4;
    public static final int NUM_SEED_STORAGE_SLOTS = 12;
    public static final int NUM_OUTPUT_SLOTS = 18;
    public static final int NUM_TOOL_SLOTS = 2;
    public static final int NUM_FERTILIZER_SLOTS = 3;
    public static final int NUM_CROPSTICK_SLOTS = 6;
    private EntityPlayerMP farmerJoe;
    private static APIv1 agricraft = null;
    private static List<ItemStack> cropSticks;
    private static List<ItemStack> rakes;
    private RadiusIterator itr = null;
    private BlockCoord currentTile = null;
    @Store(value={Store.StoreFor.CLIENT})
    public NotifSet notifications = new NotifSet();
    @Store
    public boolean tillAggresively = false;
    private static final IAfarmControlModuleComparator moduleComperator;
    private static final List<IAfarmControlModule> standardModules;
    private static List<ItemStack> seedCache;
    private static List<ItemStack> produceCache;
    private static List<ItemStack> toolsCache;

    public TileAfarm() {
        super(new SlotDefinitionAfarm(6, 12, 4, 12, 18, 2, 3, 6, 1));
        if (agricraft == null) {
            throw new RuntimeException("Agricraft not installed but trying to create Agricraft Farmer. This is a coding error in Ender IO Addons. Please report this.");
        }
        this.tillAggresively = Config.farmAggressiveTillingDefault.getBoolean();
    }

    public static void detectAgri() {
        APIBase api = API.getAPI((int)1);
        if (api.getStatus().isOK() && api.getVersion() == 1) {
            agricraft = (APIv1)api;
            cropSticks = agricraft.getCropsItems();
            rakes = agricraft.getRakeItems();
            AgriDetector.hasAgri = true;
        }
    }

    public static void registerPlants() {
        EioaCropPlant plant = new EioaCropPlant();
        agricraft.registerCropPlant((ICropPlant)plant);
        agricraft.registerGrowthRequirement(plant.getSeedIWM(), plant.getGrowthRequirement());
    }

    public void init() {
        super.init();
        this.currentTask = this.createTask(null);
    }

    private EntityPlayerMP getFarmerJoe() {
        if (this.farmerJoe == null || this.farmerJoe.field_70170_p != this.field_145850_b) {
            this.farmerJoe = new FakeFarmPlayer(MinecraftServer.func_71276_C().func_71218_a(this.field_145850_b.field_73011_w.field_76574_g));
        }
        return this.farmerJoe;
    }

    public String getMachineName() {
        return BlockAfarm.ModObject_blockAfarm.unlocalisedName;
    }

    protected boolean isMachineItemValidForSlot(int slotno, @Nullable ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        switch (((SlotDefinitionAfarm)this.slotDefinition).getSlotType(slotno)) {
            case CONTROL_STORAGE: {
                return item.func_77973_b() instanceof IAfarmControlModuleItem;
            }
            case CROPSTICK: {
                for (ItemStack cropStick : cropSticks) {
                    if (cropStick.func_77960_j() == Short.MAX_VALUE && cropStick.func_77973_b() == item.func_77973_b() && ItemStack.func_77970_a((ItemStack)cropStick, (ItemStack)item)) {
                        return true;
                    }
                    if (!ItemUtil.areStacksEqual((ItemStack)cropStick, (ItemStack)item)) continue;
                    return true;
                }
                return false;
            }
            case FERTILIZER: {
                return agricraft.isSupportedFertilizer(item);
            }
            case SEED: {
                return agricraft.isHandledByAgricraft(item);
            }
            case TOOL: {
                if (TileAfarm.isRake(item)) {
                    return this.getRakeSlot_silent() == -1;
                }
                if (TileFarmStation.ToolType.HOE.itemMatches(item)) {
                    return this.getHoeSlot_silent() == -1;
                }
                return false;
            }
            case CONTROL: {
                if (item.func_77973_b() instanceof IAfarmControlModuleItem) {
                    IAfarmControlModule candidate = ((IAfarmControlModuleItem)item.func_77973_b()).getWorker(item);
                    for (IAfarmControlModule installed : this.getControlModules()) {
                        if (candidate.isCompatibleWith(installed) && installed.isCompatibleWith(candidate)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void setGhostSlotContents(int slot, ItemStack contents) {
        if (((SlotDefinitionAfarm)this.slotDefinition).getSlotType(slot) == SlotDefinitionAfarm.SLOT.SEED_GHOST && (contents == null || agricraft.isHandledByAgricraft(contents))) {
            super.func_70299_a(slot, contents);
            this.forceClientUpdate = true;
        }
    }

    private int getHoeSlot_silent() {
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.TOOL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.TOOL); ++i) {
            if (!TileFarmStation.ToolType.HOE.itemMatches(this.inventory[i])) continue;
            this.notifications.remove((Object)Notif.NO_HOE);
            return i;
        }
        return -1;
    }

    public int getHoeSlot() {
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.TOOL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.TOOL); ++i) {
            if (!TileFarmStation.ToolType.HOE.itemMatches(this.inventory[i])) continue;
            this.notifications.remove((Object)Notif.NO_HOE);
            return i;
        }
        this.notifications.add(Notif.NO_HOE);
        return -1;
    }

    private int getRakeSlot_silent() {
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.TOOL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.TOOL); ++i) {
            if (!TileAfarm.isRake(this.inventory[i])) continue;
            this.notifications.remove((Object)Notif.NO_RAKE);
            return i;
        }
        return -1;
    }

    public int getRakeSlot() {
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.TOOL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.TOOL); ++i) {
            if (!TileAfarm.isRake(this.inventory[i]) || this.tryToBrakeRake(i)) continue;
            this.notifications.remove((Object)Notif.NO_RAKE);
            return i;
        }
        this.notifications.add(Notif.NO_RAKE);
        return -1;
    }

    private boolean tryToBrakeRake(int i) {
        if (Recipes.handRake_wood != null && this.inventory[i].func_77973_b() == Recipes.handRake_wood.func_77973_b() && this.inventory[i].func_77960_j() == Recipes.handRake_wood.func_77960_j() && Config.farmBreaksWoodenRakesEnabled.getBoolean() && this.random.nextDouble() < Config.farmBreaksWoodenRakesChance.getDouble()) {
            if (this.inventory[i].field_77994_a > 1) {
                --this.inventory[i].field_77994_a;
            } else {
                this.inventory[i] = null;
            }
            this.putIntoOutputOrWorld(new ItemStack((Item)ItemMachinePart.itemMachinePart, 1, MachinePart.RAKE_BR1.ordinal()));
        } else if (Recipes.handRake_iron != null && this.inventory[i].func_77973_b() == Recipes.handRake_iron.func_77973_b() && this.inventory[i].func_77960_j() == Recipes.handRake_iron.func_77960_j() && Config.farmBreaksIronRakesEnabled.getBoolean() && this.random.nextDouble() < Config.farmBreaksIronRakesChance.getDouble()) {
            if (this.inventory[i].field_77994_a > 1) {
                --this.inventory[i].field_77994_a;
            } else {
                this.inventory[i] = null;
            }
            this.putIntoOutputOrWorld(new ItemStack((Item)ItemMachinePart.itemMachinePart, 1, MachinePart.RAKE_BR2.ordinal()));
        }
        return this.inventory[i] == null;
    }

    private void putIntoOutputOrWorld(ItemStack stack) {
        int firstfree = -1;
        if (stack != null) {
            SlotDefinitionAfarm slotDef = (SlotDefinitionAfarm)this.getSlotDefinition();
            for (int oslot = slotDef.getMinSlot(SlotDefinitionAfarm.SLOT.OUTPUT); oslot <= slotDef.getMaxSlot(SlotDefinitionAfarm.SLOT.OUTPUT); ++oslot) {
                ItemStack ostack = this.func_70301_a(oslot);
                if (ostack != null) {
                    if (!ItemUtil.areStackMergable((ItemStack)stack, (ItemStack)ostack) || ostack.field_77994_a >= ostack.func_77976_d()) continue;
                    int free = ostack.func_77976_d() - ostack.field_77994_a;
                    if (free >= stack.field_77994_a) {
                        ostack.field_77994_a += stack.field_77994_a;
                        stack.field_77994_a = 0;
                        break;
                    }
                    ostack.field_77994_a = ostack.func_77976_d();
                    stack.field_77994_a -= free;
                    continue;
                }
                if (firstfree != -1) continue;
                firstfree = oslot;
            }
            if (stack.field_77994_a > 0) {
                if (firstfree != -1) {
                    this.func_70299_a(firstfree, stack);
                    stack.field_77994_a = 0;
                } else {
                    this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.9, (double)this.field_145849_e + 0.5, stack));
                }
            }
        }
    }

    private static boolean isRake(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        for (ItemStack rake : rakes) {
            if ((rake.func_77960_j() == Short.MAX_VALUE || rake.func_77984_f()) && rake.func_77973_b() == item.func_77973_b() && ItemStack.func_77970_a((ItemStack)rake, (ItemStack)item)) {
                return true;
            }
            if (!ItemUtil.areStacksEqual((ItemStack)rake, (ItemStack)item)) continue;
            return true;
        }
        return item.func_77973_b() == ItemMachinePart.itemMachinePart && item.func_77960_j() == MachinePart.IRAKE.ordinal();
    }

    private int calcPowerUsePerTick() {
        return (int)Math.round((double)this.getFarmSize() * Config.farmRFperTickPerArea.getDouble() + (double)this.controlModuleCount() * Config.farmRFperTickPerModule.getDouble());
    }

    private int controlModuleCount() {
        int count = 0;
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.CONTROL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.CONTROL); ++i) {
            if (this.inventory[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int getFarmSize() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return Config.farmArea1.getInt();
            }
            case ACTIVATED_CAPACITOR: {
                return Config.farmArea2.getInt();
            }
            case ENDER_CAPACITOR: {
                return Config.farmArea3.getInt();
            }
        }
        return 0;
    }

    public int getDelay() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return Config.farmDelay1.getInt();
            }
            case ACTIVATED_CAPACITOR: {
                return Config.farmDelay2.getInt();
            }
            case ENDER_CAPACITOR: {
                return Config.farmDelay3.getInt();
            }
        }
        return Integer.MAX_VALUE;
    }

    public void onCapacitorTypeChange() {
        int ppt = this.calcPowerUsePerTick();
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(ppt * 15, 25000, ppt));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(ppt * 50, 50000, ppt));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(ppt * 100, 100000, ppt));
            }
        }
        this.currentTask = this.createTask(null);
        this.itr = null;
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return this.createTask(null);
    }

    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return new ContinuousTask((float)this.getPowerUsePerTick());
    }

    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed) {
            return super.processTasks(redstoneChecksPassed);
        }
        this.notifications.clear();
        this.notifications.add(Notif.OFFLINE);
        return this.notifications.isChanged();
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.canTick()) {
            long id = Profiler.server.start();
            boolean ret = this.doTick();
            Profiler.server.stop(id, "farm tick");
            return ret;
        }
        return this.notifications.isChanged();
    }

    protected boolean canTick() {
        this.notifications.remove((Object)Notif.OFFLINE);
        if (this.usePower(this.getPowerUsePerTick()) == 0) {
            this.notifications.add(Notif.NO_POWER);
            return false;
        }
        this.notifications.remove((Object)Notif.NO_POWER);
        return true;
    }

    protected boolean doTick() {
        if (agricraft != null && this.getFarmerJoe() != null && this.shouldDoWorkThisTick(this.getDelay())) {
            if (this.shouldDoWorkThisTick(3600)) {
                this.notifications.clear();
            }
            if (this.itr == null) {
                this.itr = new RadiusIterator(this.getLocation(), this.getFarmSize());
            }
            int loop = 0;
            while (this.currentTile == null || this.currentTile.equals((Object)this.getLocation()) || !this.isTileViable(this.currentTile)) {
                this.currentTile = this.itr.next();
                if (loop++ <= 20) continue;
                return this.notifications.isChanged();
            }
            WorkTile tile = new WorkTile(this.currentTile, this, agricraft, this.farmerJoe);
            List<IAfarmControlModule> controls = this.getControlModules();
            for (IAfarmControlModule control : controls) {
                control.doWork(tile);
                if (!Config.farmDebugLoggingEnabled.getBoolean()) continue;
                Log.info(tile + " after " + control);
            }
            if (!tile.doneSomething) {
                this.currentTile = this.itr.next();
            }
        }
        return this.notifications.isChanged();
    }

    private boolean isTileViable(BlockCoord bc) {
        if (!this.field_145850_b.func_72863_F().func_73149_a(bc.x >> 4, bc.z >> 4)) {
            return false;
        }
        if (this.field_145850_b.func_147437_c(bc.x, bc.y - 1, bc.z) || !this.field_145850_b.func_147437_c(bc.x, bc.y + 1, bc.z)) {
            return false;
        }
        if (this.field_145850_b.func_147437_c(bc.x, bc.y, bc.z) || agricraft.isCrops(this.field_145850_b, bc.x, bc.y, bc.z)) {
            return true;
        }
        return this.tillAggresively && this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z).isReplaceable((IBlockAccess)this.field_145850_b, bc.x, bc.y, bc.z) && (this.field_145850_b.func_147439_a(bc.x, bc.y - 1, bc.z) == Blocks.field_150346_d || this.field_145850_b.func_147439_a(bc.x, bc.y - 1, bc.z) == Blocks.field_150349_c) && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z)) == null;
    }

    private List<IAfarmControlModule> getControlModules() {
        ArrayList<IAfarmControlModule> result = new ArrayList<IAfarmControlModule>();
        result.addAll(standardModules);
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.CONTROL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.CONTROL); ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IAfarmControlModuleItem)) continue;
            result.add(((IAfarmControlModuleItem)this.inventory[i].func_77973_b()).getWorker(this.inventory[i]));
        }
        Collections.sort(result, moduleComperator);
        return result;
    }

    public boolean twoGhosts() {
        for (int i = ((SlotDefinitionAfarm)this.slotDefinition).getMinSlot(SlotDefinitionAfarm.SLOT.CONTROL); i <= ((SlotDefinitionAfarm)this.slotDefinition).getMaxSlot(SlotDefinitionAfarm.SLOT.CONTROL); ++i) {
            if (this.inventory[i] == null || !(this.inventory[i].func_77973_b() instanceof IAfarmControlModuleItem) || !(((IAfarmControlModuleItem)this.inventory[i].func_77973_b()).getWorker(this.inventory[i]) instanceof CrossBreedModule)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsMode(ForgeDirection faceHit, IoMode mode) {
        if (faceHit != ForgeDirection.DOWN) {
            return mode == IoMode.DISABLED;
        }
        return super.supportsMode(faceHit, mode);
    }

    public boolean isSideDisabled(int var1) {
        if (var1 != ForgeDirection.DOWN.ordinal()) {
            return true;
        }
        return super.isSideDisabled(var1);
    }

    public IoMode getIoMode(ForgeDirection face) {
        if (face != ForgeDirection.DOWN) {
            return IoMode.DISABLED;
        }
        return super.getIoMode(face);
    }

    public void setIoMode(ForgeDirection faceHit, IoMode mode) {
        if (faceHit != ForgeDirection.DOWN) {
            super.setIoMode(faceHit, IoMode.DISABLED);
            return;
        }
        super.setIoMode(faceHit, mode);
    }

    @Override
    public void networkUpdate(int id, int data) {
        if (id == 0) {
            this.tillAggresively = data == 1;
        }
        this.func_70296_d();
        this.notifications.setChanged();
    }

    @Override
    public int getNetworkUpdate(int id) {
        return 0;
    }

    @Override
    public int getNetworkUpdateCount() {
        return 0;
    }

    @Override
    public int getNetworkUpdateCheckInterval() {
        return 0;
    }

    public static List<ItemStack> getModules() {
        return Collections.singletonList(new ItemStack((Item)ItemMachinePart.itemMachinePart, 1, MachinePart.FCM_BASE.ordinal()));
    }

    public static List<ItemStack> getFertilizers() {
        return Collections.singletonList(new ItemStack(Items.field_151100_aR, 1, 15));
    }

    public static List<ItemStack> getCropsticks() {
        return cropSticks;
    }

    public static List<ItemStack> getTools() {
        if (toolsCache.isEmpty()) {
            toolsCache.add(new ItemStack(Items.field_151017_I));
            toolsCache.add(new ItemStack(Items.field_151018_J));
            toolsCache.add(new ItemStack(Items.field_151019_K));
            toolsCache.add(new ItemStack(Items.field_151013_M));
            toolsCache.add(new ItemStack(Items.field_151012_L));
            for (ItemStack hoe : crazypants.enderio.config.Config.farmHoes) {
                TileAfarm.addToToolsCache(hoe);
            }
            for (ItemStack rake : rakes) {
                TileAfarm.addToToolsCache(rake);
            }
            toolsCache.add(new ItemStack((Item)ItemMachinePart.itemMachinePart, 1, MachinePart.IRAKE.ordinal()));
        }
        return toolsCache;
    }

    private static void addToToolsCache(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        for (ItemStack itemStack : toolsCache) {
            if (!itemStack.func_77969_a(stack)) continue;
            return;
        }
        toolsCache.add(stack.func_77946_l());
    }

    public static List<ItemStack> getProduce() {
        TileAfarm.getSeeds();
        return produceCache;
    }

    public static List<ItemStack> getSeeds() {
        if (seedCache.isEmpty()) {
            IMutation[] registeredMutations;
            for (IMutation mutation : registeredMutations = agricraft.getRegisteredMutations()) {
                ItemStack[] parents;
                for (ItemStack itemStack : parents = mutation.getParents()) {
                    TileAfarm.addToSeedCache(itemStack);
                }
                TileAfarm.addToSeedCache(mutation.getResult());
            }
        }
        return seedCache;
    }

    private static void addToSeedCache(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        for (ItemStack itemStack : seedCache) {
            if (!itemStack.func_77969_a(stack)) continue;
            return;
        }
        seedCache.add(stack.func_77946_l());
        ICropPlant cropPlant = agricraft.getCropPlant(stack);
        ArrayList fruits = cropPlant.getAllFruits();
        for (ItemStack itemStack : fruits) {
            TileAfarm.addToProduceCache(itemStack);
        }
    }

    private static void addToProduceCache(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        for (ItemStack itemStack : produceCache) {
            if (!itemStack.func_77969_a(stack)) continue;
            return;
        }
        produceCache.add(stack.func_77946_l());
    }

    static {
        moduleComperator = new IAfarmControlModuleComparator();
        standardModules = new ArrayList<IAfarmControlModule>();
        standardModules.add(new NSEWmodule());
        standardModules.add(new HarvestModule());
        standardModules.add(new PlantModule());
        standardModules.add(new CrossCropModule());
        standardModules.add(new CropModule());
        standardModules.add(new FertilizerModule());
        standardModules.add(new ExecuteHarvestingModule());
        standardModules.add(new ExecuteDestroyModule());
        standardModules.add(new ExecutePlantingModule());
        standardModules.add(new ExecuteCropsModule());
        standardModules.add(new ExecuteCrossCropsModule());
        standardModules.add(new ExecuteWeedModule());
        standardModules.add(new ExecuteTillModule());
        standardModules.add(new ExecuteFertilizerModule());
        Collections.sort(standardModules, moduleComperator);
        seedCache = new ArrayList<ItemStack>();
        produceCache = new ArrayList<ItemStack>();
        toolsCache = new ArrayList<ItemStack>();
    }

    private static class IAfarmControlModuleComparator
    implements Comparator<IAfarmControlModule> {
        private IAfarmControlModuleComparator() {
        }

        @Override
        public int compare(IAfarmControlModule o1, IAfarmControlModule o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    }
}

