/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.common;

import crazypants.enderio.EnderIO;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.config.Config;
import java.util.HashMap;
import java.util.Map;

public class Profiler {
    public static final Profiler client = new Profiler();
    public static final Profiler server = new Profiler();
    private Map<String, Long> profiler = new HashMap<String, Long>();
    private Map<String, Long> profilerC = new HashMap<String, Long>();
    private long lastProfiled = 0L;
    private boolean on = false;

    public long start() {
        this.on = Config.profilingEnabled.getBoolean() && EnderIO.proxy.getTickCount() > 600L;
        return this.on ? System.nanoTime() : Long.MAX_VALUE;
    }

    public long start_always() {
        this.on = true;
        return System.nanoTime();
    }

    public long pause(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public long resume(long start) {
        return this.on ? System.nanoTime() - start : Long.MAX_VALUE;
    }

    public void stop(long start, String source) {
        long elapsed;
        long l = elapsed = this.on ? System.nanoTime() - start : -1L;
        if (elapsed >= 0L) {
            if (!this.profiler.containsKey(source)) {
                this.profiler.put(source, 0L);
                this.profilerC.put(source, 0L);
            }
            this.profiler.put(source, this.profiler.get(source) + elapsed);
            this.profilerC.put(source, this.profilerC.get(source) + 1L);
            if (EnderIO.proxy.getTickCount() > this.lastProfiled) {
                this.lastProfiled = EnderIO.proxy.getTickCount() + 200L;
                for (Map.Entry<String, Long> e : this.profiler.entrySet()) {
                    long avg = e.getValue() / this.profilerC.get(e.getKey());
                    Log.info(e.getKey() + ": " + avg + " ns avg over " + this.profilerC.get(e.getKey()) + " calls");
                }
            }
        }
    }
}

