/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.applecore.asm.TransformerModuleHandler;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModulePlantFertilization
implements IClassTransformerModule {
    private static final HashMap<String, FertilizeMethodInfo> customFertilizeMethods = new HashMap();

    @Override
    public String[] getClassesToTransform() {
        return TransformerModuleHandler.ALL_CLASSES;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        if (ASMHelper.doesClassImplement(classReader, ObfHelper.getInternalClassName("net.minecraft.block.IGrowable"))) {
            FertilizeMethodInfo methodInfo = FertilizeMethodInfo.IGROWABLE_BLOCK;
            ClassNode classNode = ASMHelper.readClassFromBytes(bytes, 8);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodInfo.name, methodInfo.desc);
            if (method != null) {
                ASMHelper.copyAndRenameMethod(classNode, method, "AppleCore_fertilize");
                classNode.interfaces.add(ASMHelper.toInternalClassName("squeek.applecore.asm.util.IAppleCoreFertilizable"));
                this.replaceFertilizeMethod(method, methodInfo);
                return ASMHelper.writeClassToBytes(classNode);
            }
        } else if (customFertilizeMethods.containsKey(transformedName)) {
            FertilizeMethodInfo methodInfo = customFertilizeMethods.get(transformedName);
            ClassNode classNode = ASMHelper.readClassFromBytes(bytes, 8);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodInfo.name, methodInfo.desc);
            if (method != null) {
                ASMHelper.copyAndRenameMethod(classNode, method, "AppleCore_fertilize");
                classNode.interfaces.add(ASMHelper.toInternalClassName("squeek.applecore.asm.util.IAppleCoreFertilizable"));
                this.replaceFertilizeMethod(method, methodInfo);
                return ASMHelper.writeClassToBytes(classNode);
            }
        }
        return bytes;
    }

    private void replaceFertilizeMethod(MethodNode method, FertilizeMethodInfo methodInfo) {
        if (ASMHelper.isMethodAbstract(method)) {
            return;
        }
        if (method.localVariables != null) {
            method.localVariables.clear();
        }
        if (method.tryCatchBlocks != null) {
            method.tryCatchBlocks.clear();
        }
        method.instructions.clear();
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add(methodInfo.getLoadWorldInsns());
        method.instructions.add(methodInfo.getLoadCoordinatesInsns());
        method.instructions.add(methodInfo.getLoadRandomInsns());
        method.instructions.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireAppleCoreFertilizeEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;IIILjava/util/Random;)V", false));
        method.instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    static {
        customFertilizeMethods.put("com.pam.harvestcraft.BlockPamFruit", FertilizeMethodInfo.BLOCK_PAM_FRUIT);
        customFertilizeMethods.put("com.pam.harvestcraft.BlockPamSapling", FertilizeMethodInfo.BLOCK_PAM_SAPLING);
    }

    public static enum FertilizeMethodInfo {
        IGROWABLE_BLOCK("func_149853_b", "(Lnet/minecraft/world/World;Ljava/util/Random;III)V", 1, 3, 4, 5, 2),
        BLOCK_PAM_FRUIT("fertilize", "(Lnet/minecraft/world/World;III)V", 1, 2, 3, 4, -1),
        BLOCK_PAM_SAPLING("markOrGrowMarked", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V", 1, 2, 3, 4, 5);

        public static final int NULL_PARAM = -1;
        public final String name;
        public final String desc;
        public final int worldIndex;
        public final int xIndex;
        public final int yIndex;
        public final int zIndex;
        public final int randomIndex;

        private FertilizeMethodInfo(String methodName, String methodDesc, int worldIndex, int xIndex, int yIndex, int zIndex, int randomIndex) {
            this.name = methodName;
            this.desc = methodDesc;
            this.worldIndex = worldIndex;
            this.xIndex = xIndex;
            this.yIndex = yIndex;
            this.zIndex = zIndex;
            this.randomIndex = randomIndex;
        }

        public InsnList getLoadCoordinatesInsns() {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(21, this.xIndex));
            insnList.add((AbstractInsnNode)new VarInsnNode(21, this.yIndex));
            insnList.add((AbstractInsnNode)new VarInsnNode(21, this.zIndex));
            return insnList;
        }

        public InsnList getLoadWorldInsns() {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, this.worldIndex));
            return insnList;
        }

        public InsnList getLoadRandomInsns() {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)(this.randomIndex != -1 ? new VarInsnNode(25, this.randomIndex) : new InsnNode(1)));
            return insnList;
        }

        public String toString() {
            return this.name + this.desc;
        }
    }
}

