/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.render;

import com.xcompwiz.lookingglass.client.proxyworld.ProxyWorldManager;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.client.render.RenderUtils;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import java.io.PrintStream;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class WorldViewRenderManager {
    public static void onRenderTick(PrintStream printstream) {
        Minecraft mc = Minecraft.func_71410_x();
        Collection<WorldClient> worlds = ProxyWorldManager.getProxyworlds();
        if (worlds == null || worlds.isEmpty()) {
            return;
        }
        long renderT = Minecraft.func_71386_F();
        WorldClient worldBackup = mc.field_71441_e;
        RenderGlobal renderBackup = mc.field_71438_f;
        EffectRenderer effectBackup = mc.field_71452_i;
        EntityClientPlayerMP playerBackup = mc.field_71439_g;
        EntityLivingBase viewportBackup = mc.field_71451_h;
        float fovmult = playerBackup.func_71151_f();
        ItemStack currentClientItem = playerBackup.field_71071_by.func_70448_g();
        for (WorldClient proxyworld : worlds) {
            if (proxyworld == null) continue;
            mc.field_71441_e = proxyworld;
            RenderManager.field_78727_a.func_78717_a((World)mc.field_71441_e);
            for (WorldView activeview : ProxyWorldManager.getWorldViews(proxyworld.field_73011_w.field_76574_g)) {
                if (!activeview.hasChunks() || !activeview.markClean()) continue;
                activeview.startRender(renderT);
                mc.field_71438_f = activeview.getRenderGlobal();
                mc.field_71452_i = activeview.getEffectRenderer();
                mc.field_71451_h = activeview.camera;
                mc.field_71439_g = activeview.camera;
                activeview.camera.setFOVMult(fovmult);
                activeview.camera.field_71071_by.field_70461_c = playerBackup.field_71071_by.field_70461_c;
                activeview.camera.field_71071_by.field_70462_a[playerBackup.field_71071_by.field_70461_c] = currentClientItem;
                try {
                    mc.field_71438_f.func_72734_e();
                    mc.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)activeview.camera.field_70165_t), MathHelper.func_76128_c((double)activeview.camera.field_70163_u), MathHelper.func_76128_c((double)activeview.camera.field_70161_v));
                    mc.field_71452_i.func_78868_a();
                }
                catch (Exception e) {
                    LoggerUtils.error("Client Proxy Dim had error while updating render elements: %s", e.getLocalizedMessage());
                    e.printStackTrace(printstream);
                }
                try {
                    RenderUtils.renderWorldToTexture(0.1f, activeview.getFramebuffer(), activeview.width, activeview.height);
                }
                catch (Exception e) {
                    LoggerUtils.error("Client Proxy Dim had error while rendering: %s", e.getLocalizedMessage());
                    e.printStackTrace(printstream);
                }
            }
        }
        mc.field_71451_h = viewportBackup;
        mc.field_71439_g = playerBackup;
        mc.field_71452_i = effectBackup;
        mc.field_71438_f = renderBackup;
        mc.field_71441_e = worldBackup;
        RenderManager.field_78727_a.func_78717_a((World)mc.field_71441_e);
    }
}

