/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.client.render;

import com.google.common.collect.MapMaker;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

public class FrameBufferContainer {
    private static ConcurrentMap<WorldView, FrameBufferContainer> weakfbomap = new MapMaker().weakKeys().makeMap();
    private static Collection<FrameBufferContainer> framebuffers = new HashSet<FrameBufferContainer>();
    public final int width;
    public final int height;
    private int framebuffer;
    private int depthBuffer;
    private int texture;

    public static FrameBufferContainer createNewFramebuffer(WorldView view, int width, int height) {
        FrameBufferContainer fbo = new FrameBufferContainer(width, height);
        weakfbomap.put(view, fbo);
        framebuffers.add(fbo);
        return fbo;
    }

    public static void removeWorldView(WorldView view) {
        weakfbomap.remove(view);
    }

    public static void clearAll() {
        for (FrameBufferContainer fbo : framebuffers) {
            fbo.release();
        }
        framebuffers.clear();
    }

    public static synchronized void detectFreedWorldViews() {
        HashSet<FrameBufferContainer> unpairedFBOs = new HashSet<FrameBufferContainer>(framebuffers);
        unpairedFBOs.removeAll(weakfbomap.values());
        if (unpairedFBOs.isEmpty()) {
            return;
        }
        LoggerUtils.info("Freeing %d loose framebuffers from expired world views", unpairedFBOs.size());
        for (FrameBufferContainer fbo : unpairedFBOs) {
            fbo.release();
        }
        framebuffers.removeAll(unpairedFBOs);
    }

    private FrameBufferContainer(int width, int height) {
        this.width = width;
        this.height = height;
        this.allocateFrameBuffer();
    }

    private void release() {
        this.freeFrameBuffer();
    }

    public int getFramebuffer() {
        return this.framebuffer;
    }

    public int getTexture() {
        return this.texture;
    }

    private synchronized void freeFrameBuffer() {
        try {
            if (this.texture != 0) {
                GL11.glDeleteTextures((int)this.texture);
            }
            this.texture = 0;
            if (this.depthBuffer != 0) {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)this.depthBuffer);
            }
            this.depthBuffer = 0;
            if (this.framebuffer != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.framebuffer);
            }
            this.framebuffer = 0;
        }
        catch (Exception e) {
            LoggerUtils.error("Error while cleaning up a world view frame buffer.", new Object[0]);
        }
    }

    private void allocateFrameBuffer() {
        if (this.framebuffer != 0) {
            return;
        }
        this.framebuffer = EXTFramebufferObject.glGenFramebuffersEXT();
        this.depthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.framebuffer);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depthBuffer);
        if (MinecraftForgeClient.getStencilBits() == 0) {
            EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)this.width, (int)this.height);
        } else {
            EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)35056, (int)this.width, (int)this.height);
        }
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.depthBuffer);
        if (MinecraftForgeClient.getStencilBits() != 0) {
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36128, (int)36161, (int)this.depthBuffer);
        }
        this.texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5124, (ByteBuffer)null);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }
}

