/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.client.proxyworld;

import com.xcompwiz.lookingglass.client.proxyworld.ProxyWorld;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.client.render.FrameBufferContainer;
import com.xcompwiz.lookingglass.entity.EntityCamera;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.network.LookingGlassPacketManager;
import com.xcompwiz.lookingglass.network.packet.PacketCreateView;
import com.xcompwiz.lookingglass.proxyworld.ModConfigs;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class ProxyWorldManager {
    private static Map<Integer, WorldClient> proxyworlds = new HashMap<Integer, WorldClient>();
    private static Collection<WorldClient> proxyworldset = Collections.unmodifiableCollection(proxyworlds.values());
    private static Map<Integer, Collection<WorldView>> worldviewsets = new HashMap<Integer, Collection<WorldView>>();

    public static void handleWorldChange(WorldClient world) {
        if (ModConfigs.disabled) {
            return;
        }
        if (world == null) {
            return;
        }
        int dimid = world.field_73011_w.field_76574_g;
        if (!proxyworlds.containsKey(dimid)) {
            return;
        }
        proxyworlds.put(dimid, world);
        Collection<WorldView> worldviews = worldviewsets.get(dimid);
        for (WorldView view : worldviews) {
            view.replaceWorldObject(world);
        }
    }

    public static synchronized void detectFreedWorldViews() {
        FrameBufferContainer.detectFreedWorldViews();
        HashSet<Integer> emptyLists = new HashSet<Integer>();
        for (Map.Entry<Integer, Collection<WorldView>> entry : worldviewsets.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            emptyLists.add(entry.getKey());
        }
        for (Integer dimId : emptyLists) {
            ProxyWorldManager.unloadProxyWorld(dimId);
        }
    }

    public static synchronized WorldClient getProxyworld(int dimid) {
        if (ModConfigs.disabled) {
            return null;
        }
        WorldClient proxyworld = proxyworlds.get(dimid);
        if (proxyworld == null) {
            if (!DimensionManager.isDimensionRegistered((int)dimid)) {
                return null;
            }
            if (Minecraft.func_71410_x().field_71439_g instanceof EntityCamera) {
                return null;
            }
            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
            if (theWorld != null && theWorld.field_73011_w.field_76574_g == dimid) {
                proxyworld = theWorld;
            }
            if (proxyworld == null) {
                proxyworld = new ProxyWorld(dimid);
            }
            proxyworlds.put(dimid, proxyworld);
            worldviewsets.put(dimid, Collections.newSetFromMap(new WeakHashMap()));
        }
        return proxyworld;
    }

    private static void unloadProxyWorld(int dimId) {
        Collection<WorldView> set = worldviewsets.remove(dimId);
        if (set != null && set.size() > 0) {
            LoggerUtils.warn("Unloading ProxyWorld with live views", new Object[0]);
        }
        WorldClient proxyworld = proxyworlds.remove(dimId);
        WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
        if (theWorld != null && theWorld == proxyworld) {
            return;
        }
        if (proxyworld != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((World)proxyworld));
        }
    }

    public static void clearProxyworlds() {
        while (!proxyworlds.isEmpty()) {
            ProxyWorldManager.unloadProxyWorld(proxyworlds.keySet().iterator().next());
        }
    }

    public static Collection<WorldClient> getProxyworlds() {
        return proxyworldset;
    }

    public static Collection<WorldView> getWorldViews(int dimid) {
        Collection<WorldView> set = worldviewsets.get(dimid);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(set);
    }

    public static WorldView createWorldView(int dimid, ChunkCoordinates spawn, int width, int height) {
        if (ModConfigs.disabled) {
            return null;
        }
        if (!DimensionManager.isDimensionRegistered((int)dimid)) {
            return null;
        }
        WorldClient proxyworld = ProxyWorldManager.getProxyworld(dimid);
        if (proxyworld == null) {
            return null;
        }
        Collection<WorldView> worldviews = worldviewsets.get(dimid);
        if (worldviews == null) {
            return null;
        }
        WorldView view = new WorldView(proxyworld, spawn, width, height);
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase backup = mc.field_71451_h;
        mc.field_71451_h = view.camera;
        view.getRenderGlobal().func_72732_a(proxyworld);
        mc.field_71451_h = backup;
        LookingGlassPacketManager.bus.sendToServer(PacketCreateView.createPacket(view));
        worldviews.add(view);
        return view;
    }

    public static void destroyWorldView(WorldView view) {
        Collection<WorldView> set = worldviewsets.get(view.getWorldObj().field_73011_w.field_76574_g);
        if (set != null) {
            set.remove(view);
        }
        view.cleanup();
    }
}

