/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.api.animator;

import com.xcompwiz.lookingglass.api.animator.ICameraAnimator;
import com.xcompwiz.lookingglass.api.view.IViewCamera;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class CameraAnimatorPivot
implements ICameraAnimator {
    private static final int[][] presets = new int[][]{{2, 5}, {5, 9}, {9, 15}, {1, 3}, {2, 1}, {0, 2}};
    private static final int[] defaults = new int[]{1, 3};
    private final IViewCamera camera;
    private ChunkCoordinates target;
    private boolean positionSet = false;
    private int xCenter;
    private int yCenter;
    private int zCenter;
    private int yUp = 0;
    private int radius = 0;
    private float pitch = 0.0f;

    public CameraAnimatorPivot(IViewCamera camera) {
        this.camera = camera;
    }

    @Override
    public void setTarget(ChunkCoordinates target) {
        this.target = target;
        this.positionSet = false;
    }

    @Override
    public void update(long dt) {
        if (this.camera == null) {
            return;
        }
        this.camera.addRotations((float)dt * 0.1f, 0);
        this.camera.setPitch(-this.pitch);
        double x = Math.cos(Math.toRadians(this.camera.getYaw() + 90.0f)) * (double)this.radius;
        double z = Math.sin(Math.toRadians(this.camera.getYaw() + 90.0f)) * (double)this.radius;
        this.camera.setLocation((double)this.xCenter + 0.5 - x, (double)this.yCenter - 0.5 + (double)this.yUp, (double)this.zCenter + 0.5 - z);
    }

    @Override
    public void refresh() {
        if (this.camera == null) {
            return;
        }
        if (this.target == null) {
            return;
        }
        if (!this.positionSet) {
            this.checkCameraY();
        }
        int chunkX = this.xCenter >> 4;
        int chunkY = this.yCenter >> 4;
        int chunkZ = this.zCenter >> 4;
        int[][] presets = this.getPresets();
        for (int i = 0; i < presets.length; ++i) {
            if (!this.checkPath(presets[i][0], presets[i][1], chunkX, chunkY, chunkZ)) continue;
            this.yUp = presets[i][0];
            this.radius = presets[i][1];
            this.pitch = (float)Math.toDegrees(Math.atan((double)(-this.yUp) / (double)this.radius));
            return;
        }
        int[] defaults = this.getDefaults();
        this.yUp = defaults[0];
        this.radius = defaults[1];
        this.pitch = (float)Math.toDegrees(Math.atan((double)(-this.yUp) / (double)this.radius));
    }

    public int[] getDefaults() {
        return defaults;
    }

    public int[][] getPresets() {
        return presets;
    }

    private boolean checkPath(int up, int distance, int chunkX, int chunkY, int chunkZ) {
        if ((this.yCenter & 0xF) > 15 - up) {
            if (this.isAboveNullLayer(chunkX, chunkY, chunkZ)) {
                return false;
            }
            if ((this.xCenter & 0xF) < distance) {
                if (this.isAboveNullLayer(chunkX - 1, chunkY, chunkZ)) {
                    return false;
                }
                if ((this.zCenter & 0xF) < distance) {
                    if (this.isAboveNullLayer(chunkX - 1, chunkY, chunkZ - 1)) {
                        return false;
                    }
                    if (this.isAboveNullLayer(chunkX, chunkY, chunkZ - 1)) {
                        return false;
                    }
                } else if ((this.zCenter & 0xF) > 15 - distance) {
                    if (this.isAboveNullLayer(chunkX - 1, chunkY, chunkZ + 1)) {
                        return false;
                    }
                    if (this.isAboveNullLayer(chunkX, chunkY, chunkZ + 1)) {
                        return false;
                    }
                }
            } else if ((this.xCenter & 0xF) > 15 - distance) {
                if (this.isAboveNullLayer(chunkX + 1, chunkY, chunkZ)) {
                    return false;
                }
                if ((this.zCenter & 0xF) < distance) {
                    if (this.isAboveNullLayer(chunkX + 1, chunkY, chunkZ - 1)) {
                        return false;
                    }
                    if (this.isAboveNullLayer(chunkX, chunkY, chunkZ - 1)) {
                        return false;
                    }
                } else if ((this.zCenter & 0xF) > 15 - distance) {
                    if (this.isAboveNullLayer(chunkX + 1, chunkY, chunkZ + 1)) {
                        return false;
                    }
                    if (this.isAboveNullLayer(chunkX, chunkY, chunkZ + 1)) {
                        return false;
                    }
                }
            } else if ((this.zCenter & 0xF) < distance ? this.isAboveNullLayer(chunkX, chunkY, chunkZ - 1) : (this.zCenter & 0xF) > 15 - distance && this.isAboveNullLayer(chunkX, chunkY, chunkZ + 1)) {
                return false;
            }
        }
        for (int j = -distance; j <= distance; ++j) {
            for (int k = -distance; k <= distance; ++k) {
                if (this.camera.getBlockData().func_147437_c(this.xCenter + j, this.yCenter + up, this.zCenter + k)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAboveNullLayer(int x, int y, int z) {
        if (y + 1 > 15) {
            return true;
        }
        int x2 = x << 4;
        int z2 = z << 4;
        int y2 = (y << 4) + 15;
        int yl = y + 1 << 4;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                if (this.isBlockNormalCube(this.camera.getBlockData(), x2 + i, y2, z2 + i)) continue;
                return false;
            }
        }
        return this.camera.chunkLevelsExist(x, z, yl, yl + 15);
    }

    private boolean isBlockNormalCube(IBlockAccess blockData, int x, int y, int z) {
        Block block = blockData.func_147439_a(x, y, z);
        return block.isNormalCube(blockData, x, y, z);
    }

    private void checkCameraY() {
        int x = this.target.field_71574_a;
        int y = this.target.field_71572_b;
        int z = this.target.field_71573_c;
        int yBackup = y;
        if (this.camera.chunkExists(x, z)) {
            if (this.camera.getBlockData().func_147439_a(x, y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                while (y > 0 && this.camera.getBlockData().func_147439_a(x, --y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                }
                y = y == 0 ? yBackup : (y += 2);
            } else {
                while (y < 256 && !this.camera.getBlockData().func_147439_a(x, ++y, z).func_149655_b(this.camera.getBlockData(), x, y, z)) {
                }
                y = y == 256 ? yBackup : ++y;
            }
            this.setCenterPoint(x, y, z);
        }
    }

    private void setCenterPoint(int x, int y, int z) {
        this.xCenter = x;
        this.yCenter = y - 1;
        this.zCenter = z;
        this.positionSet = true;
    }
}

