/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.imaginarytime;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.ConfigMan;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityImaginaryTime
extends TileEntity
implements IEnergyReceiver {
    protected EnergyStorage localEnergyStorage = new EnergyStorage(1000, ConfigMan.imaginaryTime_chargeRate);

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.localEnergyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.localEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.localEnergyStorage.getMaxEnergyStored();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.localEnergyStorage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.localEnergyStorage.readFromNBT(energyTag);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getEnergyStored(ForgeDirection.UNKNOWN) >= ConfigMan.imaginaryTime_energyRequirement) {
            int x = this.field_145851_c;
            int y = this.field_145848_d;
            int z = this.field_145849_e;
            int range = ConfigMan.imaginaryTime_range + 1;
            int passes = ConfigMan.imaginaryTime_tickIncrease;
            for (int x2 = x - range; x2 <= x + range; ++x2) {
                for (int z2 = z - range; z2 <= z + range; ++z2) {
                    for (int y2 = y - 2; y2 < y + 2; ++y2) {
                        Block block;
                        if (this.field_145850_b.field_73012_v.nextDouble() < 0.5 || (block = this.field_145850_b.func_147439_a(x2, y2, z2)) == null) continue;
                        if (block.func_149653_t()) {
                            for (int pass = 0; pass < passes; ++pass) {
                                block.func_149674_a(this.field_145850_b, x2, y2, z2, this.field_145850_b.field_73012_v);
                            }
                        }
                        block = null;
                    }
                }
            }
            this.localEnergyStorage.extractEnergy(ConfigMan.imaginaryTime_energyRequirement, false);
        }
    }
}

