/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.exciter;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.UUID;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFExciter
extends TileEntity
implements IEnergyProvider {
    public UUID owner;
    public int lastEnergyUsed;
    public ForgeDirection targetDirection;
    public int maxOut = ConfigMan.rfExciter1_output;
    public int upgradeCount;
    public float wirelessEfficiency = ConfigMan.rfExciter_Efficiency;

    public String getOwner() {
        return this.owner == null ? null : this.owner.toString();
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return RedfluxField.requestEnergy(maxExtract, simulate, this.getOwner());
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("upgradeCount", this.upgradeCount);
        if (this.targetDirection != null) {
            tag.func_74768_a("direction", this.targetDirection.ordinal());
        }
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        try {
            this.owner = UUID.fromString(tag.func_74779_i("owner"));
            this.targetDirection = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
            this.upgradeCount = tag.func_74762_e("upgradeCount");
        }
        catch (Exception ex) {
            Logger.error("HEY YOU! An RF Exciter has corrupt data at %d, %d, %d. The owner will need to replace it.", this.field_145851_c, this.field_145848_d, this.field_145849_e, ex);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetDirection == null || this.owner == null) {
            return;
        }
        int targetX = this.field_145851_c + this.targetDirection.offsetX;
        int targetY = this.field_145848_d + this.targetDirection.offsetY;
        int targetZ = this.field_145849_e + this.targetDirection.offsetZ;
        TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
        if (tile instanceof IEnergyReceiver) {
            int netPower = this.getNetPower();
            int tosend = this.extractEnergy(null, netPower, true);
            int needed = ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.getOpposite(), tosend, true);
            int willSend = Math.round((float)needed * this.wirelessEfficiency);
            ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.getOpposite(), willSend, false);
            if (needed > 0) {
                this.func_70296_d();
            }
            this.lastEnergyUsed = needed;
            this.extractEnergy(null, needed, false);
        }
    }

    public int getNetPower() {
        int power = this.maxOut + this.upgradeCount * 100;
        return power;
    }
}

