/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.QuantumFlux;
import jotato.quantumflux.util.NbtUtils;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class ItemEviscerator
extends ItemPickaxe
implements IEnergyContainerItem {
    public static Item.ToolMaterial material = EnumHelper.addToolMaterial((String)"eviscerator", (int)10000, (int)1000, (float)32.0f, (float)24.0f, (int)25);
    private static final String energy_tag = "Energy";
    private int energyUsedPerHit = 100;

    protected ItemEviscerator(String name) {
        super(material);
        this.func_77655_b(name);
        this.func_111206_d("quantumflux:" + name);
        this.func_77637_a(QuantumFlux.tab);
        GameRegistry.registerItem((Item)this, (String)name);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.canRepair = false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(NbtUtils.setInt(new ItemStack(item), energy_tag, ConfigMan.eviscerator_maxEnergy));
        list.add(NbtUtils.setInt(new ItemStack(item), energy_tag, 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean p_77624_4_) {
        info.add(EnumChatFormatting.RED + String.format(StatCollector.func_74838_a((String)"tooltip.charge"), this.getEnergyStored(stack)));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)NbtUtils.getInt(stack, energy_tag) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase p_77644_2_, EntityLivingBase entity) {
        this.damageTool(stack, entity);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase entity) {
        this.damageTool(stack, entity);
        return true;
    }

    public void damageTool(ItemStack item, EntityLivingBase entity) {
        this.setDamage(item, 0);
        if (this.getEnergyStored(item) >= this.energyUsedPerHit) {
            this.extractEnergy(item, this.energyUsedPerHit, false);
        } else {
            entity.func_70097_a(DamageSource.field_76377_j, 2.0f);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return this.field_77864_a;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int maxICanReceive = Math.min(ConfigMan.eviscerator_maxEnergy - stored, ConfigMan.eviscerator_chargeRate);
        int toGet = Math.min(maxReceive, maxICanReceive);
        if (simulate) {
            return toGet;
        }
        NbtUtils.setInt(container, energy_tag, stored += toGet);
        return toGet;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int maxICanSend = Math.min(stored, ConfigMan.eviscerator_chargeRate);
        int toSend = Math.min(maxExtract, maxICanSend);
        if (simulate) {
            return toSend;
        }
        NbtUtils.setInt(container, energy_tag, stored -= toSend);
        return toSend;
    }

    public int getEnergyStored(ItemStack container) {
        return NbtUtils.getInt(container, energy_tag);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return ConfigMan.eviscerator_maxEnergy;
    }
}

