/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import micdoodle8.mods.miccore.ConfigManagerMicCore;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
public class MicdoodleTransformer
implements IClassTransformer {
    HashMap<String, ObfuscationEntry> nodemap = new HashMap();
    private boolean deobfuscated = true;
    private boolean optifinePresent;
    private boolean isServer;
    private boolean playerApiActive;
    private DefaultArtifactVersion mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
    private String nameForgeHooksClient;
    private String nameConfManager;
    private String namePlayerController;
    private String nameEntityLiving;
    private String nameEntityItem;
    private String nameEntityRenderer;
    private String nameItemRenderer;
    private String nameGuiSleep;
    private String nameEffectRenderer;
    private String nameNetHandlerPlay;
    private String nameWorldRenderer;
    private String nameRenderGlobal;
    private String nameRenderManager;
    private String nameTileEntityRenderer;
    private String nameEntity;
    private String nameChunkProviderServer;
    private String nameEntityArrow;
    private String nameRendererLivingEntity;
    private String nameEntityGolem;
    private String nameWorld;
    private static final String KEY_CLASS_PLAYER_MP = "PlayerMP";
    private static final String KEY_CLASS_WORLD = "worldClass";
    private static final String KEY_CLASS_CONF_MANAGER = "confManagerClass";
    private static final String KEY_CLASS_GAME_PROFILE = "gameProfileClass";
    private static final String KEY_CLASS_ITEM_IN_WORLD_MANAGER = "itemInWorldManagerClass";
    private static final String KEY_CLASS_PLAYER_CONTROLLER = "playerControllerClass";
    private static final String KEY_CLASS_PLAYER_SP = "playerClient";
    private static final String KEY_CLASS_STAT_FILE_WRITER = "statFileWriterClass";
    private static final String KEY_CLASS_NET_HANDLER_PLAY = "netHandlerPlayClientClass";
    private static final String KEY_CLASS_ENTITY_LIVING = "entityLivingClass";
    private static final String KEY_CLASS_ENTITY_ITEM = "entityItemClass";
    private static final String KEY_CLASS_ENTITY_RENDERER = "entityRendererClass";
    private static final String KEY_CLASS_WORLD_RENDERER = "worldRendererClass";
    private static final String KEY_CLASS_RENDER_GLOBAL = "renderGlobalClass";
    private static final String KEY_CLASS_RENDER_MANAGER = "renderManagerClass";
    private static final String KEY_CLASS_TESSELLATOR = "tessellatorClass";
    private static final String KEY_CLASS_TILEENTITY_RENDERER = "tileEntityRendererClass";
    private static final String KEY_CLASS_CONTAINER_PLAYER = "containerPlayer";
    private static final String KEY_CLASS_MINECRAFT = "minecraft";
    private static final String KEY_CLASS_SESSION = "session";
    private static final String KEY_CLASS_GUI_SCREEN = "guiScreen";
    private static final String KEY_CLASS_ITEM_RENDERER = "itemRendererClass";
    private static final String KEY_CLASS_VEC3 = "vecClass";
    private static final String KEY_CLASS_ENTITY = "entityClass";
    private static final String KEY_CLASS_TILEENTITY = "tileEntityClass";
    private static final String KEY_CLASS_GUI_SLEEP = "guiSleepClass";
    private static final String KEY_CLASS_EFFECT_RENDERER = "effectRendererClass";
    private static final String KEY_CLASS_FORGE_HOOKS_CLIENT = "forgeHooks";
    private static final String KEY_CLASS_CUSTOM_PLAYER_MP = "customPlayerMP";
    private static final String KEY_CLASS_CUSTOM_PLAYER_SP = "customPlayerSP";
    private static final String KEY_CLASS_CUSTOM_OTHER_PLAYER = "customEntityOtherPlayer";
    private static final String KEY_CLASS_PACKET_SPAWN_PLAYER = "packetSpawnPlayer";
    private static final String KEY_CLASS_ENTITY_OTHER_PLAYER = "entityOtherPlayer";
    private static final String KEY_CLASS_SERVER = "minecraftServer";
    private static final String KEY_CLASS_WORLD_SERVER = "worldServer";
    private static final String KEY_CLASS_WORLD_CLIENT = "worldClient";
    private static final String KEY_CLASS_CHUNK_PROVIDER_SERVER = "chunkProviderServer";
    private static final String KEY_CLASS_ICHUNKPROVIDER = "IChunkProvider";
    private static final String KEY_NET_HANDLER_LOGIN_SERVER = "netHandlerLoginServer";
    private static final String KEY_CLASS_ENTITY_ARROW = "entityArrow";
    private static final String KEY_CLASS_RENDERER_LIVING_ENTITY = "rendererLivingEntity";
    private static final String KEY_CLASS_ENTITYGOLEM = "entityGolem";
    private static final String KEY_FIELD_THE_PLAYER = "thePlayer";
    private static final String KEY_FIELD_WORLDRENDERER_GLRENDERLIST = "glRenderList";
    private static final String KEY_FIELD_CPS_WORLDOBJ = "cps_worldObj";
    private static final String KEY_FIELD_CPS_CURRENT_CHUNKPROV = "CurrentChunkProvider";
    private static final String KEY_METHOD_CREATE_PLAYER = "createPlayerMethod";
    private static final String KEY_METHOD_RESPAWN_PLAYER = "respawnPlayerMethod";
    private static final String KEY_METHOD_CREATE_CLIENT_PLAYER = "createClientPlayerMethod";
    private static final String KEY_METHOD_MOVE_ENTITY = "moveEntityMethod";
    private static final String KEY_METHOD_ON_UPDATE = "onUpdateMethod";
    private static final String KEY_METHOD_UPDATE_LIGHTMAP = "updateLightmapMethod";
    private static final String KEY_METHOD_RENDER_OVERLAYS = "renderOverlaysMethod";
    private static final String KEY_METHOD_UPDATE_FOG_COLOR = "updateFogColorMethod";
    private static final String KEY_METHOD_GET_FOG_COLOR = "getFogColorMethod";
    private static final String KEY_METHOD_GET_SKY_COLOR = "getSkyColorMethod";
    private static final String KEY_METHOD_WAKE_ENTITY = "wakeEntityMethod";
    private static final String KEY_METHOD_BED_ORIENT_CAMERA = "orientBedCamera";
    private static final String KEY_METHOD_RENDER_PARTICLES = "renderParticlesMethod";
    private static final String KEY_METHOD_CUSTOM_PLAYER_MP = "customPlayerMPConstructor";
    private static final String KEY_METHOD_CUSTOM_PLAYER_SP = "customPlayerSPConstructor";
    private static final String KEY_METHOD_ATTEMPT_LOGIN_BUKKIT = "attemptLoginMethodBukkit";
    private static final String KEY_METHOD_HANDLE_SPAWN_PLAYER = "handleSpawnPlayerMethod";
    private static final String KEY_METHOD_ORIENT_CAMERA = "orientCamera";
    private static final String KEY_METHOD_RENDERMANAGER = "renderManagerMethod";
    private static final String KEY_METHOD_PRERENDER_BLOCKS = "preRenderBlocksMethod";
    private static final String KEY_METHOD_SETUP_GL = "setupGLTranslationMethod";
    private static final String KEY_METHOD_SET_POSITION = "setPositionMethod";
    private static final String KEY_METHOD_WORLDRENDERER_UPDATERENDERER = "updateRendererMethod";
    private static final String KEY_METHOD_LOAD_RENDERERS = "loadRenderersMethod";
    private static final String KEY_METHOD_RENDERGLOBAL_INIT = "renderGlobalInitMethod";
    private static final String KEY_METHOD_RENDERGLOBAL_SORTANDRENDER = "sortAndRenderMethod";
    private static final String KEY_METHOD_TESSELLATOR_ADDVERTEX = "addVertexMethod";
    private static final String KEY_METHOD_TILERENDERER_RENDERTILEAT = "renderTileAtMethod";
    private static final String KEY_METHOD_START_GAME = "startGame";
    private static final String KEY_METHOD_CAN_RENDER_FIRE = "canRenderOnFire";
    private static final String KEY_METHOD_CGS_POPULATE = "CGSpopulate";
    private static final String KEY_METHOD_RENDER_MODEL = "renderModel";
    private static final String KEY_METHOD_RAIN_STRENGTH = "getRainStrength";
    private static final String KEY_METHOD_REGISTEROF = "registerOF";
    private static final String CLASS_RUNTIME_INTERFACE = "micdoodle8/mods/miccore/Annotations$RuntimeInterface";
    private static final String CLASS_ALT_FORVERSION = "micdoodle8/mods/miccore/Annotations$AltForVersion";
    private static final String CLASS_VERSION_SPECIFIC = "micdoodle8/mods/miccore/Annotations$VersionSpecific";
    private static final String CLASS_MICDOODLE_PLUGIN = "micdoodle8/mods/miccore/MicdoodlePlugin";
    private static final String CLASS_CLIENT_PROXY_MAIN = "micdoodle8/mods/galacticraft/core/proxy/ClientProxyCore";
    private static final String CLASS_WORLD_UTIL = "micdoodle8/mods/galacticraft/core/util/WorldUtil";
    private static final String CLASS_GL11 = "org/lwjgl/opengl/GL11";
    private static final String CLASS_RENDER_PLAYER_GC = "micdoodle8/mods/galacticraft/core/client/render/entities/RenderPlayerGC";
    private static final String CLASS_IENTITYBREATHABLE = "micdoodle8/mods/galacticraft/api/entity/IEntityBreathable";
    private static final String CLASS_SYNCMOD_CLONEPLAYER = "sync/common/tileentity/TileEntityDualVertical";
    private static final String CLASS_RENDERPLAYEROF = "RenderPlayerOF";
    private static int operationCount = 0;
    private static int injectionCount = 0;

    public MicdoodleTransformer() {
        try {
            this.deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
            this.optifinePresent = Launch.classLoader.getClassBytes("CustomColorizer") != null;
            this.playerApiActive = Launch.classLoader.getClassBytes("api.player.forge.PlayerAPITransformer") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Launch.classLoader.addTransformerExclusion(CLASS_IENTITYBREATHABLE.replace('/', '.'));
        if (this.mcVersionMatches("[1.7.2]")) {
            this.nodemap.put(KEY_CLASS_PLAYER_MP, new ObfuscationEntry("net/minecraft/entity/player/EntityPlayerMP", "mm"));
            this.nodemap.put(KEY_CLASS_WORLD, new ObfuscationEntry("net/minecraft/world/World", "afn"));
            this.nodemap.put(KEY_CLASS_CONF_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ServerConfigurationManager", "ld"));
            this.nodemap.put(KEY_CLASS_GAME_PROFILE, new ObfuscationEntry("com/mojang/authlib/GameProfile"));
            this.nodemap.put(KEY_CLASS_ITEM_IN_WORLD_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ItemInWorldManager", "mn"));
            this.nodemap.put(KEY_CLASS_PLAYER_CONTROLLER, new ObfuscationEntry("net/minecraft/client/multiplayer/PlayerControllerMP", "biy"));
            this.nodemap.put(KEY_CLASS_PLAYER_SP, new ObfuscationEntry("net/minecraft/client/entity/EntityClientPlayerMP", "bje"));
            this.nodemap.put(KEY_CLASS_STAT_FILE_WRITER, new ObfuscationEntry("net/minecraft/stats/StatFileWriter", "oe"));
            this.nodemap.put(KEY_CLASS_NET_HANDLER_PLAY, new ObfuscationEntry("net/minecraft/client/network/NetHandlerPlayClient", "biv"));
            this.nodemap.put(KEY_CLASS_ENTITY_LIVING, new ObfuscationEntry("net/minecraft/entity/EntityLivingBase", "rh"));
            this.nodemap.put(KEY_CLASS_ENTITY_ITEM, new ObfuscationEntry("net/minecraft/entity/item/EntityItem", "vw"));
            this.nodemap.put(KEY_CLASS_ENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/EntityRenderer", "bll"));
            this.nodemap.put(KEY_CLASS_WORLD_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/WorldRenderer", "blg"));
            this.nodemap.put(KEY_CLASS_RENDER_GLOBAL, new ObfuscationEntry("net/minecraft/client/renderer/RenderGlobal", "bls"));
            this.nodemap.put(KEY_CLASS_TESSELLATOR, new ObfuscationEntry("net/minecraft/client/renderer/Tessellator", "blz"));
            this.nodemap.put(KEY_CLASS_RENDER_MANAGER, new ObfuscationEntry("net/minecraft/client/renderer/entity/RenderManager", "bnf"));
            this.nodemap.put(KEY_CLASS_TILEENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "bmc"));
            this.nodemap.put(KEY_CLASS_CONTAINER_PLAYER, new ObfuscationEntry("net/minecraft/inventory/ContainerPlayer", "zb"));
            this.nodemap.put(KEY_CLASS_MINECRAFT, new ObfuscationEntry("net/minecraft/client/Minecraft", "azd"));
            this.nodemap.put(KEY_CLASS_SESSION, new ObfuscationEntry("net/minecraft/util/Session", "baf"));
            this.nodemap.put(KEY_CLASS_GUI_SCREEN, new ObfuscationEntry("net/minecraft/client/gui/GuiScreen", "bcd"));
            this.nodemap.put(KEY_CLASS_ITEM_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/ItemRenderer", "blq"));
            this.nodemap.put(KEY_CLASS_VEC3, new ObfuscationEntry("net/minecraft/util/Vec3", "ayk"));
            this.nodemap.put(KEY_CLASS_ENTITY, new ObfuscationEntry("net/minecraft/entity/Entity", "qn"));
            this.nodemap.put(KEY_CLASS_GUI_SLEEP, new ObfuscationEntry("net/minecraft/client/gui/GuiSleepMP", "bbp"));
            this.nodemap.put(KEY_CLASS_EFFECT_RENDERER, new ObfuscationEntry("net/minecraft/client/particle/EffectRenderer", "bkg"));
            this.nodemap.put(KEY_CLASS_FORGE_HOOKS_CLIENT, new ObfuscationEntry("net/minecraftforge/client/ForgeHooksClient"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_MP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_SP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityClientPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_OTHER_PLAYER, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_PACKET_SPAWN_PLAYER, new ObfuscationEntry("net/minecraft/network/play/server/S0CPacketSpawnPlayer", "fs"));
            this.nodemap.put(KEY_CLASS_ENTITY_OTHER_PLAYER, new ObfuscationEntry("net/minecraft/client/entity/EntityOtherPlayerMP", "bld"));
            this.nodemap.put(KEY_CLASS_SERVER, new ObfuscationEntry("net/minecraft/server/MinecraftServer"));
            this.nodemap.put(KEY_CLASS_WORLD_SERVER, new ObfuscationEntry("net/minecraft/world/WorldServer", "mj"));
            this.nodemap.put(KEY_CLASS_WORLD_CLIENT, new ObfuscationEntry("net/minecraft/client/multiplayer/WorldClient", "biz"));
            this.nodemap.put(KEY_CLASS_TILEENTITY, new ObfuscationEntry("net/minecraft/tileentity/TileEntity", "and"));
            this.nodemap.put(KEY_CLASS_CHUNK_PROVIDER_SERVER, new ObfuscationEntry("net/minecraft/world/gen/ChunkProviderServer", "mi"));
            this.nodemap.put(KEY_CLASS_ICHUNKPROVIDER, new ObfuscationEntry(KEY_CLASS_ICHUNKPROVIDER, "aog"));
            this.nodemap.put(KEY_NET_HANDLER_LOGIN_SERVER, new ObfuscationEntry("net/minecraft/server/network/NetHandlerLoginServer", "nd"));
            this.nodemap.put(KEY_CLASS_ENTITY_ARROW, new ObfuscationEntry("net/minecraft/entity/projectile/EntityArrow", "xo"));
            this.nodemap.put(KEY_CLASS_RENDERER_LIVING_ENTITY, new ObfuscationEntry("net/minecraft/client/renderer/entity/RendererLivingEntity", "bnz"));
            this.nodemap.put(KEY_CLASS_ENTITYGOLEM, new ObfuscationEntry("net/minecraft/entity/monster/EntityGolem", "ux"));
            this.nodemap.put(KEY_FIELD_THE_PLAYER, new FieldObfuscationEntry(KEY_FIELD_THE_PLAYER, "h"));
            this.nodemap.put(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, new FieldObfuscationEntry(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, "z"));
            this.nodemap.put(KEY_FIELD_CPS_WORLDOBJ, new FieldObfuscationEntry("worldObj", "i"));
            this.nodemap.put(KEY_FIELD_CPS_CURRENT_CHUNKPROV, new FieldObfuscationEntry("currentChunkProvider", "e"));
            this.nodemap.put(KEY_METHOD_CREATE_PLAYER, new MethodObfuscationEntry("createPlayerForUser", "a", "(L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RESPAWN_PLAYER, new MethodObfuscationEntry("respawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";IZ)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_CREATE_CLIENT_PLAYER, new MethodObfuscationEntry("func_147493_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_SP) + ";"));
            this.nodemap.put(KEY_METHOD_MOVE_ENTITY, new MethodObfuscationEntry("moveEntityWithHeading", "e", "(FF)V"));
            this.nodemap.put(KEY_METHOD_ON_UPDATE, new MethodObfuscationEntry("onUpdate", "h", "()V"));
            this.nodemap.put(KEY_METHOD_UPDATE_LIGHTMAP, new MethodObfuscationEntry("updateLightmap", "h", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDER_OVERLAYS, new MethodObfuscationEntry("renderOverlays", "b", "(F)V"));
            this.nodemap.put(KEY_METHOD_UPDATE_FOG_COLOR, new MethodObfuscationEntry("updateFogColor", "i", "(F)V"));
            this.nodemap.put(KEY_METHOD_GET_FOG_COLOR, new MethodObfuscationEntry("getFogColor", "f", "(F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_GET_SKY_COLOR, new MethodObfuscationEntry("getSkyColor", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_WAKE_ENTITY, new MethodObfuscationEntry("func_146418_g", "g", "()V"));
            this.nodemap.put(KEY_METHOD_BED_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_BED_ORIENT_CAMERA, "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_PARTICLES, new MethodObfuscationEntry("renderParticles", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_MP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_SP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_SESSION) + ";L" + this.getNameDynamic(KEY_CLASS_NET_HANDLER_PLAY) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)V"));
            this.nodemap.put(KEY_METHOD_HANDLE_SPAWN_PLAYER, new MethodObfuscationEntry("handleSpawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PACKET_SPAWN_PLAYER) + ";)V"));
            this.nodemap.put(KEY_METHOD_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_ORIENT_CAMERA, "g", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDERMANAGER, new MethodObfuscationEntry("func_147939_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDDFFZ)Z"));
            this.nodemap.put(KEY_METHOD_SETUP_GL, new MethodObfuscationEntry("setupGLTranslation", "f", "()V"));
            this.nodemap.put(KEY_METHOD_PRERENDER_BLOCKS, new MethodObfuscationEntry("preRenderBlocks", "b", "(I)V"));
            this.nodemap.put(KEY_METHOD_SET_POSITION, new MethodObfuscationEntry("setPosition", "a", "(III)V"));
            this.nodemap.put(KEY_METHOD_WORLDRENDERER_UPDATERENDERER, new MethodObfuscationEntry("updateRenderer", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_LOAD_RENDERERS, new MethodObfuscationEntry("loadRenderers", "a", "()V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_INIT, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_SORTANDRENDER, new MethodObfuscationEntry("sortAndRender", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";ID)I"));
            this.nodemap.put(KEY_METHOD_TESSELLATOR_ADDVERTEX, new MethodObfuscationEntry("addVertex", "a", "(DDD)V"));
            this.nodemap.put(KEY_METHOD_TILERENDERER_RENDERTILEAT, new MethodObfuscationEntry("renderTileEntityAt", "a", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDDF)V"));
            this.nodemap.put(KEY_METHOD_START_GAME, new MethodObfuscationEntry(KEY_METHOD_START_GAME, "Z", "()V"));
            this.nodemap.put(KEY_METHOD_CAN_RENDER_FIRE, new MethodObfuscationEntry(KEY_METHOD_CAN_RENDER_FIRE, "aA", "()Z"));
            this.nodemap.put(KEY_METHOD_CGS_POPULATE, new MethodObfuscationEntry("populate", "a", "(Laog;II)V"));
            this.nodemap.put(KEY_METHOD_ATTEMPT_LOGIN_BUKKIT, new MethodObfuscationEntry("attemptLogin", "attemptLogin", "(L" + this.getNameDynamic(KEY_NET_HANDLER_LOGIN_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";Ljava/lang/String;)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RENDER_MODEL, new MethodObfuscationEntry(KEY_METHOD_RENDER_MODEL, "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";FFFFFF)V"));
            this.nodemap.put(KEY_METHOD_RAIN_STRENGTH, new MethodObfuscationEntry(KEY_METHOD_RAIN_STRENGTH, "j", "(F)F"));
        } else if (this.mcVersionMatches("[1.7.10]")) {
            this.nodemap.put(KEY_CLASS_PLAYER_MP, new ObfuscationEntry("net/minecraft/entity/player/EntityPlayerMP", "mw"));
            this.nodemap.put(KEY_CLASS_WORLD, new ObfuscationEntry("net/minecraft/world/World", "ahb"));
            this.nodemap.put(KEY_CLASS_CONF_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ServerConfigurationManager", "oi"));
            this.nodemap.put(KEY_CLASS_GAME_PROFILE, new ObfuscationEntry("com/mojang/authlib/GameProfile"));
            this.nodemap.put(KEY_CLASS_ITEM_IN_WORLD_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ItemInWorldManager", "mx"));
            this.nodemap.put(KEY_CLASS_PLAYER_CONTROLLER, new ObfuscationEntry("net/minecraft/client/multiplayer/PlayerControllerMP", "bje"));
            this.nodemap.put(KEY_CLASS_PLAYER_SP, new ObfuscationEntry("net/minecraft/client/entity/EntityClientPlayerMP", "bjk"));
            this.nodemap.put(KEY_CLASS_STAT_FILE_WRITER, new ObfuscationEntry("net/minecraft/stats/StatFileWriter", "pq"));
            this.nodemap.put(KEY_CLASS_NET_HANDLER_PLAY, new ObfuscationEntry("net/minecraft/client/network/NetHandlerPlayClient", "bjb"));
            this.nodemap.put(KEY_CLASS_ENTITY_LIVING, new ObfuscationEntry("net/minecraft/entity/EntityLivingBase", "sv"));
            this.nodemap.put(KEY_CLASS_ENTITY_ITEM, new ObfuscationEntry("net/minecraft/entity/item/EntityItem", "xk"));
            this.nodemap.put(KEY_CLASS_ENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/EntityRenderer", "blt"));
            this.nodemap.put(KEY_CLASS_WORLD_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/WorldRenderer", "blo"));
            this.nodemap.put(KEY_CLASS_RENDER_GLOBAL, new ObfuscationEntry("net/minecraft/client/renderer/RenderGlobal", "bma"));
            this.nodemap.put(KEY_CLASS_TESSELLATOR, new ObfuscationEntry("net/minecraft/client/renderer/Tessellator", "bmh"));
            this.nodemap.put(KEY_CLASS_RENDER_MANAGER, new ObfuscationEntry("net/minecraft/client/renderer/entity/RenderManager", "bnn"));
            this.nodemap.put(KEY_CLASS_TILEENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "bmk"));
            this.nodemap.put(KEY_CLASS_CONTAINER_PLAYER, new ObfuscationEntry("net/minecraft/inventory/ContainerPlayer", "aap"));
            this.nodemap.put(KEY_CLASS_MINECRAFT, new ObfuscationEntry("net/minecraft/client/Minecraft", "bao"));
            this.nodemap.put(KEY_CLASS_SESSION, new ObfuscationEntry("net/minecraft/util/Session", "bbs"));
            this.nodemap.put(KEY_CLASS_GUI_SCREEN, new ObfuscationEntry("net/minecraft/client/gui/GuiScreen", "bdw"));
            this.nodemap.put(KEY_CLASS_ITEM_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/ItemRenderer", "bly"));
            this.nodemap.put(KEY_CLASS_VEC3, new ObfuscationEntry("net/minecraft/util/Vec3", "azw"));
            this.nodemap.put(KEY_CLASS_ENTITY, new ObfuscationEntry("net/minecraft/entity/Entity", "sa"));
            this.nodemap.put(KEY_CLASS_GUI_SLEEP, new ObfuscationEntry("net/minecraft/client/gui/GuiSleepMP", "bdi"));
            this.nodemap.put(KEY_CLASS_EFFECT_RENDERER, new ObfuscationEntry("net/minecraft/client/particle/EffectRenderer", "bkn"));
            this.nodemap.put(KEY_CLASS_FORGE_HOOKS_CLIENT, new ObfuscationEntry("net/minecraftforge/client/ForgeHooksClient"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_MP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_SP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityClientPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_OTHER_PLAYER, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_PACKET_SPAWN_PLAYER, new ObfuscationEntry("net/minecraft/network/play/server/S0CPacketSpawnPlayer", "gb"));
            this.nodemap.put(KEY_CLASS_ENTITY_OTHER_PLAYER, new ObfuscationEntry("net/minecraft/client/entity/EntityOtherPlayerMP", "bll"));
            this.nodemap.put(KEY_CLASS_SERVER, new ObfuscationEntry("net/minecraft/server/MinecraftServer"));
            this.nodemap.put(KEY_CLASS_WORLD_SERVER, new ObfuscationEntry("net/minecraft/world/WorldServer", "mt"));
            this.nodemap.put(KEY_CLASS_WORLD_CLIENT, new ObfuscationEntry("net/minecraft/client/multiplayer/WorldClient", "bjf"));
            this.nodemap.put(KEY_CLASS_TILEENTITY, new ObfuscationEntry("net/minecraft/tileentity/TileEntity", "aor"));
            this.nodemap.put(KEY_CLASS_CHUNK_PROVIDER_SERVER, new ObfuscationEntry("net/minecraft/world/gen/ChunkProviderServer", "ms"));
            this.nodemap.put(KEY_CLASS_ICHUNKPROVIDER, new ObfuscationEntry(KEY_CLASS_ICHUNKPROVIDER, "apu"));
            this.nodemap.put(KEY_NET_HANDLER_LOGIN_SERVER, new ObfuscationEntry("net/minecraft/server/network/NetHandlerLoginServer", "nn"));
            this.nodemap.put(KEY_CLASS_ENTITY_ARROW, new ObfuscationEntry("net/minecraft/entity/projectile/EntityArrow", "zc"));
            this.nodemap.put(KEY_CLASS_RENDERER_LIVING_ENTITY, new ObfuscationEntry("net/minecraft/client/renderer/entity/RendererLivingEntity", "boh"));
            this.nodemap.put(KEY_CLASS_ENTITYGOLEM, new ObfuscationEntry("net/minecraft/entity/monster/EntityGolem", "wl"));
            this.nodemap.put(KEY_FIELD_THE_PLAYER, new FieldObfuscationEntry(KEY_FIELD_THE_PLAYER, "h"));
            this.nodemap.put(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, new FieldObfuscationEntry(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, "z"));
            this.nodemap.put(KEY_FIELD_CPS_WORLDOBJ, new FieldObfuscationEntry("worldObj", "i"));
            this.nodemap.put(KEY_FIELD_CPS_CURRENT_CHUNKPROV, new FieldObfuscationEntry("currentChunkProvider", "e"));
            this.nodemap.put(KEY_METHOD_CREATE_PLAYER, new MethodObfuscationEntry("createPlayerForUser", "f", "(L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RESPAWN_PLAYER, new MethodObfuscationEntry("respawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";IZ)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_CREATE_CLIENT_PLAYER, new MethodObfuscationEntry("func_147493_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_SP) + ";"));
            this.nodemap.put(KEY_METHOD_MOVE_ENTITY, new MethodObfuscationEntry("moveEntityWithHeading", "e", "(FF)V"));
            this.nodemap.put(KEY_METHOD_ON_UPDATE, new MethodObfuscationEntry("onUpdate", "h", "()V"));
            this.nodemap.put(KEY_METHOD_UPDATE_LIGHTMAP, new MethodObfuscationEntry("updateLightmap", "i", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDER_OVERLAYS, new MethodObfuscationEntry("renderOverlays", "b", "(F)V"));
            this.nodemap.put(KEY_METHOD_UPDATE_FOG_COLOR, new MethodObfuscationEntry("updateFogColor", "j", "(F)V"));
            this.nodemap.put(KEY_METHOD_GET_FOG_COLOR, new MethodObfuscationEntry("getFogColor", "f", "(F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_GET_SKY_COLOR, new MethodObfuscationEntry("getSkyColor", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_WAKE_ENTITY, new MethodObfuscationEntry("func_146418_g", "f", "()V"));
            this.nodemap.put(KEY_METHOD_BED_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_BED_ORIENT_CAMERA, "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_PARTICLES, new MethodObfuscationEntry("renderParticles", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_MP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_SP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_SESSION) + ";L" + this.getNameDynamic(KEY_CLASS_NET_HANDLER_PLAY) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)V"));
            this.nodemap.put(KEY_METHOD_HANDLE_SPAWN_PLAYER, new MethodObfuscationEntry("handleSpawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PACKET_SPAWN_PLAYER) + ";)V"));
            this.nodemap.put(KEY_METHOD_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_ORIENT_CAMERA, "h", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDERMANAGER, new MethodObfuscationEntry("func_147939_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDDFFZ)Z"));
            this.nodemap.put(KEY_METHOD_SETUP_GL, new MethodObfuscationEntry("setupGLTranslation", "f", "()V"));
            this.nodemap.put(KEY_METHOD_PRERENDER_BLOCKS, new MethodObfuscationEntry("preRenderBlocks", "b", "(I)V"));
            this.nodemap.put(KEY_METHOD_SET_POSITION, new MethodObfuscationEntry("setPosition", "a", "(III)V"));
            this.nodemap.put(KEY_METHOD_WORLDRENDERER_UPDATERENDERER, new MethodObfuscationEntry("updateRenderer", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_LOAD_RENDERERS, new MethodObfuscationEntry("loadRenderers", "a", "()V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_INIT, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_SORTANDRENDER, new MethodObfuscationEntry("sortAndRender", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";ID)I"));
            this.nodemap.put(KEY_METHOD_TESSELLATOR_ADDVERTEX, new MethodObfuscationEntry("addVertex", "a", "(DDD)V"));
            this.nodemap.put(KEY_METHOD_TILERENDERER_RENDERTILEAT, new MethodObfuscationEntry("renderTileEntityAt", "a", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDDF)V"));
            this.nodemap.put(KEY_METHOD_START_GAME, new MethodObfuscationEntry(KEY_METHOD_START_GAME, "ag", "()V"));
            this.nodemap.put(KEY_METHOD_CAN_RENDER_FIRE, new MethodObfuscationEntry(KEY_METHOD_CAN_RENDER_FIRE, "aA", "()Z"));
            this.nodemap.put(KEY_METHOD_CGS_POPULATE, new MethodObfuscationEntry("populate", "a", "(Lapu;II)V"));
            this.nodemap.put(KEY_METHOD_ATTEMPT_LOGIN_BUKKIT, new MethodObfuscationEntry("attemptLogin", "attemptLogin", "(L" + this.getNameDynamic(KEY_NET_HANDLER_LOGIN_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";Ljava/lang/String;)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RENDER_MODEL, new MethodObfuscationEntry(KEY_METHOD_RENDER_MODEL, "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";FFFFFF)V"));
            this.nodemap.put(KEY_METHOD_RAIN_STRENGTH, new MethodObfuscationEntry(KEY_METHOD_RAIN_STRENGTH, "j", "(F)F"));
            this.nodemap.put(KEY_METHOD_REGISTEROF, new MethodObfuscationEntry("register", "register", "()V"));
        }
        try {
            this.isServer = Launch.classLoader.getClassBytes(this.getNameDynamic(KEY_CLASS_RENDER_GLOBAL)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        String testName;
        if (name.contains("galacticraft")) {
            return this.transformCustomAnnotations(bytes);
        }
        if (this.nameForgeHooksClient == null) {
            this.nameForgeHooksClient = this.getName(KEY_CLASS_FORGE_HOOKS_CLIENT);
            if (this.deobfuscated) {
                this.populateNamesDeObf();
            } else {
                this.populateNamesObf();
            }
        }
        if ((testName = name.replace('.', '/')).equals(this.nameForgeHooksClient)) {
            return this.transformForgeHooks(bytes);
        }
        if (testName.equals(CLASS_SYNCMOD_CLONEPLAYER)) {
            return this.transformSyncMod(bytes);
        }
        if (testName.equals(CLASS_RENDERPLAYEROF)) {
            return this.transformOptifine(bytes);
        }
        if (testName.length() <= 3 || this.deobfuscated) {
            return this.transformVanilla(testName, bytes);
        }
        return bytes;
    }

    private void populateNamesDeObf() {
        this.nameConfManager = this.getName(KEY_CLASS_CONF_MANAGER);
        this.namePlayerController = this.getName(KEY_CLASS_PLAYER_CONTROLLER);
        this.nameEntityLiving = this.getName(KEY_CLASS_ENTITY_LIVING);
        this.nameEntityItem = this.getName(KEY_CLASS_ENTITY_ITEM);
        this.nameEntityRenderer = this.getName(KEY_CLASS_ENTITY_RENDERER);
        this.nameItemRenderer = this.getName(KEY_CLASS_ITEM_RENDERER);
        this.nameGuiSleep = this.getName(KEY_CLASS_GUI_SLEEP);
        this.nameEffectRenderer = this.getName(KEY_CLASS_EFFECT_RENDERER);
        this.nameNetHandlerPlay = this.getName(KEY_CLASS_NET_HANDLER_PLAY);
        this.nameWorldRenderer = this.getName(KEY_CLASS_WORLD_RENDERER);
        this.nameRenderGlobal = this.getName(KEY_CLASS_RENDER_GLOBAL);
        this.nameRenderManager = this.getName(KEY_CLASS_RENDER_MANAGER);
        this.nameTileEntityRenderer = this.getName(KEY_CLASS_TILEENTITY_RENDERER);
        this.nameEntity = this.getName(KEY_CLASS_ENTITY);
        this.nameChunkProviderServer = this.getName(KEY_CLASS_CHUNK_PROVIDER_SERVER);
        this.nameEntityArrow = this.getName(KEY_CLASS_ENTITY_ARROW);
        this.nameRendererLivingEntity = this.getName(KEY_CLASS_RENDERER_LIVING_ENTITY);
        this.nameEntityGolem = this.getName(KEY_CLASS_ENTITYGOLEM);
        this.nameWorld = this.getName(KEY_CLASS_WORLD);
    }

    private void populateNamesObf() {
        this.nameConfManager = this.nodemap.get((Object)KEY_CLASS_CONF_MANAGER).obfuscatedName;
        this.namePlayerController = this.nodemap.get((Object)KEY_CLASS_PLAYER_CONTROLLER).obfuscatedName;
        this.nameEntityLiving = this.nodemap.get((Object)KEY_CLASS_ENTITY_LIVING).obfuscatedName;
        this.nameEntityItem = this.nodemap.get((Object)KEY_CLASS_ENTITY_ITEM).obfuscatedName;
        this.nameEntityRenderer = this.nodemap.get((Object)KEY_CLASS_ENTITY_RENDERER).obfuscatedName;
        this.nameItemRenderer = this.nodemap.get((Object)KEY_CLASS_ITEM_RENDERER).obfuscatedName;
        this.nameGuiSleep = this.nodemap.get((Object)KEY_CLASS_GUI_SLEEP).obfuscatedName;
        this.nameEffectRenderer = this.nodemap.get((Object)KEY_CLASS_EFFECT_RENDERER).obfuscatedName;
        this.nameNetHandlerPlay = this.nodemap.get((Object)KEY_CLASS_NET_HANDLER_PLAY).obfuscatedName;
        this.nameWorldRenderer = this.nodemap.get((Object)KEY_CLASS_WORLD_RENDERER).obfuscatedName;
        this.nameRenderGlobal = this.nodemap.get((Object)KEY_CLASS_RENDER_GLOBAL).obfuscatedName;
        this.nameRenderManager = this.nodemap.get((Object)KEY_CLASS_RENDER_MANAGER).obfuscatedName;
        this.nameTileEntityRenderer = this.nodemap.get((Object)KEY_CLASS_TILEENTITY_RENDERER).obfuscatedName;
        this.nameEntity = this.nodemap.get((Object)KEY_CLASS_ENTITY).obfuscatedName;
        this.nameChunkProviderServer = this.nodemap.get((Object)KEY_CLASS_CHUNK_PROVIDER_SERVER).obfuscatedName;
        this.nameEntityArrow = this.nodemap.get((Object)KEY_CLASS_ENTITY_ARROW).obfuscatedName;
        this.nameRendererLivingEntity = this.nodemap.get((Object)KEY_CLASS_RENDERER_LIVING_ENTITY).obfuscatedName;
        this.nameEntityGolem = this.nodemap.get((Object)KEY_CLASS_ENTITYGOLEM).obfuscatedName;
        this.nameWorld = this.nodemap.get((Object)KEY_CLASS_WORLD).obfuscatedName;
    }

    private byte[] transformVanilla(String testName, byte[] bytes) {
        if (testName.equals(this.nameConfManager)) {
            return this.transformConfigManager(bytes);
        }
        if (testName.equals(this.namePlayerController)) {
            return this.transformPlayerController(bytes);
        }
        if (testName.equals(this.nameEntityLiving)) {
            return this.transformEntityLiving(bytes);
        }
        if (testName.equals(this.nameEntityItem)) {
            return this.transformEntityItem(bytes);
        }
        if (testName.equals(this.nameEntityRenderer)) {
            return this.transformEntityRenderer(bytes);
        }
        if (testName.equals(this.nameItemRenderer)) {
            return this.transformItemRenderer(bytes);
        }
        if (testName.equals(this.nameGuiSleep)) {
            return this.transformGuiSleep(bytes);
        }
        if (testName.equals(this.nameEffectRenderer)) {
            return this.transformEffectRenderer(bytes);
        }
        if (testName.equals(this.nameNetHandlerPlay)) {
            return this.transformNetHandlerPlay(bytes);
        }
        if (testName.equals(this.nameWorldRenderer)) {
            return this.transformWorldRenderer(bytes);
        }
        if (testName.equals(this.nameRenderGlobal)) {
            return this.transformRenderGlobal(bytes);
        }
        if (testName.equals(this.nameRenderManager)) {
            return this.transformRenderManager(bytes);
        }
        if (testName.equals(this.nameTileEntityRenderer)) {
            return this.transformTileEntityRenderer(bytes);
        }
        if (testName.equals(this.nameEntity)) {
            return this.transformEntityClass(bytes);
        }
        if (testName.equals(this.nameChunkProviderServer)) {
            return this.transformChunkProviderServerClass(bytes);
        }
        if (testName.equals(this.nameEntityArrow)) {
            return this.transformEntityArrow(bytes);
        }
        if (testName.equals(this.nameRendererLivingEntity)) {
            return this.transformRendererLivingEntity(bytes);
        }
        if (testName.equals(this.nameEntityGolem)) {
            return this.transformEntityGolem(bytes);
        }
        if (testName.equals(this.nameWorld)) {
            return this.transformWorld(bytes);
        }
        return bytes;
    }

    public byte[] transformChunkProviderServerClass(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode populateMethod = this.getMethod(node, KEY_METHOD_CGS_POPULATE);
        if (populateMethod != null) {
            LabelNode skipLabel = new LabelNode();
            for (int count = 0; count < populateMethod.instructions.size(); ++count) {
                AbstractInsnNode list = populateMethod.instructions.get(count);
                if (!(list instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)list;
                if (nodeAt.getOpcode() == 185 && nodeAt.desc.equals(populateMethod.desc)) {
                    InsnList nodesToAdd = new InsnList();
                    nodesToAdd.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    nodesToAdd.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesToAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_CHUNK_PROVIDER_SERVER), this.getNameDynamic(KEY_FIELD_CPS_WORLDOBJ), "L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";"));
                    nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesToAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_CHUNK_PROVIDER_SERVER), this.getNameDynamic(KEY_FIELD_CPS_CURRENT_CHUNKPROV), "L" + this.getNameDynamic(KEY_CLASS_ICHUNKPROVIDER) + ";"));
                    nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "otherModPreventGenerate", "(IIL" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_ICHUNKPROVIDER) + ";L" + this.getNameDynamic(KEY_CLASS_ICHUNKPROVIDER) + ";)Z"));
                    nodesToAdd.add((AbstractInsnNode)new JumpInsnNode(154, skipLabel));
                    populateMethod.instructions.insert((AbstractInsnNode)nodeAt, nodesToAdd);
                    ++injectionCount;
                    continue;
                }
                if (nodeAt.getOpcode() != 184 || !nodeAt.owner.contains("GameRegistry")) continue;
                populateMethod.instructions.insert((AbstractInsnNode)nodeAt, (AbstractInsnNode)skipLabel);
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformConfigManager(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        MethodNode attemptLoginMethod = this.getMethod(node, KEY_METHOD_ATTEMPT_LOGIN_BUKKIT);
        int n = playerAPI ? 0 : (operationCount = attemptLoginMethod == null ? 4 : 6);
        if (!playerAPI) {
            TypeInsnNode overwriteNode;
            TypeInsnNode nodeAt;
            AbstractInsnNode list;
            int count;
            MethodNode createPlayerMethod = this.getMethod(node, KEY_METHOD_CREATE_PLAYER);
            MethodNode respawnPlayerMethod = this.getMethod(node, KEY_METHOD_RESPAWN_PLAYER);
            if (createPlayerMethod != null) {
                for (count = 0; count < createPlayerMethod.instructions.size(); ++count) {
                    list = createPlayerMethod.instructions.get(count);
                    if (list instanceof TypeInsnNode) {
                        nodeAt = (TypeInsnNode)list;
                        if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                        overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                        createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        continue;
                    }
                    if (!(list instanceof MethodInsnNode)) continue;
                    nodeAt = (MethodInsnNode)list;
                    if (!nodeAt.owner.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP)) || nodeAt.getOpcode() != 183) continue;
                    createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                    ++injectionCount;
                }
            }
            if (respawnPlayerMethod != null) {
                for (count = 0; count < respawnPlayerMethod.instructions.size(); ++count) {
                    list = respawnPlayerMethod.instructions.get(count);
                    if (list instanceof TypeInsnNode) {
                        nodeAt = (TypeInsnNode)list;
                        if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                        overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                        respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        continue;
                    }
                    if (!(list instanceof MethodInsnNode)) continue;
                    nodeAt = (MethodInsnNode)list;
                    if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                    ++injectionCount;
                }
            }
            if (attemptLoginMethod != null) {
                for (count = 0; count < attemptLoginMethod.instructions.size(); ++count) {
                    list = attemptLoginMethod.instructions.get(count);
                    if (list instanceof TypeInsnNode) {
                        nodeAt = (TypeInsnNode)list;
                        if (nodeAt.getOpcode() != 187 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                        overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                        attemptLoginMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        continue;
                    }
                    if (!(list instanceof MethodInsnNode) || (nodeAt = (MethodInsnNode)list).getOpcode() != 183 || !nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    String initDesc = "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V";
                    attemptLoginMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), initDesc));
                    ++injectionCount;
                }
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformSyncMod(byte[] bytes) {
        MethodNode respawnPlayerMethod;
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        int n = operationCount = playerAPI ? 0 : 2;
        if (!playerAPI && (respawnPlayerMethod = this.getMethodNoDesc(node, "func_145845_h")) != null) {
            for (int count = 0; count < respawnPlayerMethod.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = respawnPlayerMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (nodeAt.getOpcode() != 187 || !nodeAt.desc.contains(this.getName(KEY_CLASS_PLAYER_MP))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                    respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getName(KEY_CLASS_PLAYER_MP))) continue;
                respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformPlayerController(byte[] bytes) {
        MethodNode method;
        ClassNode node = this.startInjection(bytes);
        boolean playerAPI = this.isPlayerApiActive();
        int n = operationCount = playerAPI ? 0 : 2;
        if (!playerAPI && (method = this.getMethod(node, KEY_METHOD_CREATE_CLIENT_PLAYER)) != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = method.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP));
                    method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP), this.getName(KEY_METHOD_CUSTOM_PLAYER_SP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_SP)));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityLiving(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_MOVE_ENTITY);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "getGravityForEntity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityItem(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_ON_UPDATE);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.04f)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "getItemGravity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_ITEM) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 5;
        MethodNode updateLightMapMethod = this.getMethod(node, KEY_METHOD_UPDATE_LIGHTMAP);
        MethodNode updateFogColorMethod = this.getMethod(node, KEY_METHOD_UPDATE_FOG_COLOR);
        MethodNode orientCameraMethod = this.getMethod(node, KEY_METHOD_ORIENT_CAMERA);
        if (orientCameraMethod != null) {
            InsnList nodesToAdd = new InsnList();
            nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
            nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, KEY_METHOD_ORIENT_CAMERA, "(F)V"));
            orientCameraMethod.instructions.insertBefore(orientCameraMethod.instructions.get(orientCameraMethod.instructions.size() - 3), nodesToAdd);
            ++injectionCount;
            if (ConfigManagerMicCore.enableDebug) {
                System.out.println("bll.OrientCamera done");
            }
        }
        if (updateLightMapMethod != null) {
            boolean worldBrightnessInjection = false;
            for (int count = 0; count < updateLightMapMethod.instructions.size(); ++count) {
                MethodInsnNode nodeAt;
                AbstractInsnNode list = updateLightMapMethod.instructions.get(count);
                if (list instanceof MethodInsnNode) {
                    nodeAt = (MethodInsnNode)list;
                    if (!worldBrightnessInjection && nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_WORLD_CLIENT))) {
                        updateLightMapMethod.instructions.remove(updateLightMapMethod.instructions.get(count - 1));
                        updateLightMapMethod.instructions.remove(updateLightMapMethod.instructions.get(count - 1));
                        updateLightMapMethod.instructions.insertBefore(updateLightMapMethod.instructions.get(count - 1), (AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getWorldBrightness", "(L" + this.getNameDynamic(KEY_CLASS_WORLD_CLIENT) + ";)F"));
                        ++injectionCount;
                        worldBrightnessInjection = true;
                        if (!ConfigManagerMicCore.enableDebug) continue;
                        System.out.println("bll.updateLightMap - worldBrightness done");
                        continue;
                    }
                }
                if (!(list instanceof IntInsnNode)) continue;
                nodeAt = (IntInsnNode)list;
                if (nodeAt.operand != 255) continue;
                InsnList nodesToAdd = new InsnList();
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 11));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorRed", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 11));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorGreen", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 13));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorBlue", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 13));
                updateLightMapMethod.instructions.insertBefore((AbstractInsnNode)nodeAt, nodesToAdd);
                ++injectionCount;
                if (!ConfigManagerMicCore.enableDebug) break;
                System.out.println("bll.updateLightMap - getColors done");
                break;
            }
        }
        if (updateFogColorMethod != null) {
            for (int count = 0; count < updateFogColorMethod.instructions.size(); ++count) {
                InsnList toAdd;
                AbstractInsnNode list = updateFogColorMethod.instructions.get(count);
                if (!(list instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)list;
                if (!this.optifinePresent && this.methodMatches(KEY_METHOD_GET_FOG_COLOR, nodeAt)) {
                    toAdd = new InsnList();
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getFogColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(58, 9));
                    updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count + 2), toAdd);
                    ++injectionCount;
                    if (!ConfigManagerMicCore.enableDebug) continue;
                    System.out.println("bll.updateFogColor - getFogColor (no Optifine) done");
                    continue;
                }
                if (!this.methodMatches(KEY_METHOD_GET_SKY_COLOR, nodeAt)) continue;
                toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getSkyColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                toAdd.add((AbstractInsnNode)new VarInsnNode(58, 5));
                updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count + 2), toAdd);
                ++injectionCount;
                if (!ConfigManagerMicCore.enableDebug) continue;
                System.out.println("bll.updateFogColor - getSkyColor done");
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformGuiSleep(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_WAKE_ENTITY);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(method.instructions.size() - 3), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, "onSleepCancelled", "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformForgeHooks(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_BED_ORIENT_CAMERA);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(0), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, KEY_METHOD_ORIENT_CAMERA, "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityGolem(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 0;
        injectionCount = 0;
        String inter = CLASS_IENTITYBREATHABLE;
        try {
            Class.forName(inter.replace("/", "."));
            if (!node.interfaces.contains(inter)) {
                node.interfaces.add(inter);
                ++injectionCount;
            }
            MethodNode canBreathe = new MethodNode(1, "canBreath", "()Z", null, null);
            canBreathe.instructions.add((AbstractInsnNode)new InsnNode(4));
            canBreathe.instructions.add((AbstractInsnNode)new InsnNode(172));
            node.methods.add(canBreathe);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.finishInjection(node);
    }

    public byte[] transformCustomAnnotations(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 0;
        injectionCount = 0;
        Iterator methods = node.methods.iterator();
        ArrayList<String> ignoredMods = new ArrayList<String>();
        block2: while (methods.hasNext()) {
            MethodNode methodnode = (MethodNode)methods.next();
            if (methodnode.visibleAnnotations == null || methodnode.visibleAnnotations.size() <= 0) continue;
            for (AnnotationNode annotation : methodnode.visibleAnnotations) {
                boolean modFound;
                int i;
                String toMatch;
                if (annotation.desc.equals("Lmicdoodle8/mods/miccore/Annotations$VersionSpecific;")) {
                    toMatch = null;
                    for (i = 0; i < annotation.values.size(); i += 2) {
                        if (!"version".equals(annotation.values.get(i))) continue;
                        toMatch = String.valueOf(annotation.values.get(i + 1));
                    }
                    if (toMatch != null) {
                        boolean doRemove = true;
                        if (this.mcVersionMatches(toMatch)) {
                            doRemove = false;
                        }
                        if (doRemove) {
                            methods.remove();
                            continue block2;
                        }
                    }
                }
                if (annotation.desc.equals("Lmicdoodle8/mods/miccore/Annotations$AltForVersion;")) {
                    toMatch = null;
                    for (i = 0; i < annotation.values.size(); i += 2) {
                        if (!"version".equals(annotation.values.get(i))) continue;
                        toMatch = String.valueOf(annotation.values.get(i + 1));
                    }
                    if (toMatch != null && this.mcVersionMatches(toMatch)) {
                        String existing = new String(methodnode.name);
                        existing = existing.substring(0, existing.length() - 1);
                        if (ConfigManagerMicCore.enableDebug) {
                            this.printLog("Renaming method " + existing + " for version " + toMatch);
                        }
                        methodnode.name = new String(existing);
                        continue block2;
                    }
                }
                if (!annotation.desc.equals("Lmicdoodle8/mods/miccore/Annotations$RuntimeInterface;")) continue;
                ArrayList<String> desiredInterfaces = new ArrayList<String>();
                String modID = "";
                for (int i2 = 0; i2 < annotation.values.size(); i2 += 2) {
                    Object value = annotation.values.get(i2);
                    if (value.equals("clazz")) {
                        desiredInterfaces.add(String.valueOf(annotation.values.get(i2 + 1)));
                        continue;
                    }
                    if (value.equals("modID")) {
                        modID = String.valueOf(annotation.values.get(i2 + 1));
                        continue;
                    }
                    if (!value.equals("altClasses")) continue;
                    desiredInterfaces.addAll((ArrayList)annotation.values.get(i2 + 1));
                }
                if (!modID.isEmpty() && ignoredMods.contains(modID)) continue block2;
                boolean bl = modFound = modID.isEmpty() || Loader.isModLoaded((String)modID);
                if (modFound) {
                    for (String inter : desiredInterfaces) {
                        try {
                            Class.forName(inter);
                        }
                        catch (ClassNotFoundException e) {
                            if (!ConfigManagerMicCore.enableDebug) continue;
                            this.printLog("Galacticraft ignored missing interface \"" + inter + "\" from mod \"" + modID + "\".");
                            continue;
                        }
                        if (node.interfaces.contains(inter = inter.replace(".", "/"))) continue block2;
                        if (ConfigManagerMicCore.enableDebug) {
                            this.printLog("Galacticraft added interface \"" + inter + "\" dynamically from \"" + modID + "\" to class \"" + node.name + "\".");
                        }
                        node.interfaces.add(inter);
                        ++injectionCount;
                        continue block2;
                    }
                    continue block2;
                }
                ignoredMods.add(modID);
                if (!ConfigManagerMicCore.enableDebug) continue block2;
                this.printLog("Galacticraft ignored dynamic interface insertion since \"" + modID + "\" was not found.");
                continue block2;
            }
        }
        if (injectionCount > 0 && ConfigManagerMicCore.enableDebug) {
            this.printLog("Galacticraft successfully injected bytecode into: " + node.name + " (" + injectionCount + ")");
        }
        return this.finishInjection(node, false);
    }

    public byte[] transformEffectRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderParticlesMethod = this.getMethod(node, KEY_METHOD_RENDER_PARTICLES);
        if (renderParticlesMethod != null) {
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(23, 2));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "renderFootprints", "(F)V"));
            renderParticlesMethod.instructions.insert(renderParticlesMethod.instructions.get(0), toAdd);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformItemRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderOverlaysMethod = this.getMethod(node, KEY_METHOD_RENDER_OVERLAYS);
        if (renderOverlaysMethod != null) {
            for (int count = 0; count < renderOverlaysMethod.instructions.size(); ++count) {
                AbstractInsnNode glEnable = renderOverlaysMethod.instructions.get(count);
                if (!(glEnable instanceof MethodInsnNode) || !((MethodInsnNode)glEnable).name.equals("glEnable")) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "renderLiquidOverlays", "(F)V"));
                renderOverlaysMethod.instructions.insertBefore(glEnable, toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformNetHandlerPlay(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 2;
        MethodNode handleNamedSpawnMethod = this.getMethod(node, KEY_METHOD_HANDLE_SPAWN_PLAYER);
        if (handleNamedSpawnMethod != null) {
            for (int count = 0; count < handleNamedSpawnMethod.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = handleNamedSpawnMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER));
                    handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER), "<init>", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)V"));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformWorldRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue()) {
            MethodNode setupGLMethod;
            MethodNode setPositionMethod = this.getMethod(node, KEY_METHOD_SET_POSITION);
            if (setPositionMethod != null) {
                for (int count = 0; count < setPositionMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = setPositionMethod.instructions.get(count);
                    if (!(nodeTest instanceof InsnNode) || nodeTest.getOpcode() != 177) continue;
                    InsnList toAdd = new InsnList();
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_WORLD_RENDERER), this.getNameDynamic(KEY_FIELD_WORLDRENDERER_GLRENDERLIST), "I"));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "setPositionList", "(L" + this.getNameDynamic(KEY_CLASS_WORLD_RENDERER) + ";I)V"));
                    setPositionMethod.instructions.insertBefore(nodeTest, toAdd);
                    ++injectionCount;
                    if (!ConfigManagerMicCore.enableDebug) break;
                    System.out.println("blg.setPosition - done");
                    break;
                }
            }
            if ((setupGLMethod = this.getMethod(node, KEY_METHOD_SETUP_GL)) != null) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_WORLD_RENDERER), this.getNameDynamic(KEY_FIELD_WORLDRENDERER_GLRENDERLIST), "I"));
                toAdd.add((AbstractInsnNode)new InsnNode(6));
                toAdd.add((AbstractInsnNode)new InsnNode(96));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_GL11, "glCallList", "(I)V"));
                setupGLMethod.instructions.insertBefore(setupGLMethod.instructions.get(0), toAdd);
                ++injectionCount;
                if (ConfigManagerMicCore.enableDebug) {
                    System.out.println("blg.setupGLMethod - done");
                }
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRenderGlobal(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 5 : 0;
        if (smallMoonsEnabled.booleanValue()) {
            MethodNode renderMethod;
            MethodNode loadMethod;
            MethodNode initMethod = this.getMethod(node, KEY_METHOD_RENDERGLOBAL_INIT);
            if (initMethod != null) {
                for (int count = 0; count < initMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = initMethod.instructions.get(count);
                    AbstractInsnNode nodeTestb = initMethod.instructions.get(count + 1);
                    if (!(nodeTest instanceof InsnNode) || !(nodeTestb instanceof InsnNode) || nodeTest.getOpcode() != 6 || nodeTestb.getOpcode() != 104) continue;
                    InsnNode overwriteNode = new InsnNode(7);
                    initMethod.instructions.set(nodeTest, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    if (!ConfigManagerMicCore.enableDebug) break;
                    System.out.println("bls.init - done");
                    break;
                }
            }
            if ((loadMethod = this.getMethod(node, KEY_METHOD_LOAD_RENDERERS)) != null) {
                for (int count = 0; count < loadMethod.instructions.size(); ++count) {
                    IincInsnNode overwriteNode;
                    AbstractInsnNode nodeTest = loadMethod.instructions.get(count);
                    if (!(nodeTest instanceof IincInsnNode)) continue;
                    IincInsnNode nodeAt = (IincInsnNode)nodeTest;
                    if (nodeAt.var == 2 && nodeAt.incr == 3 && !this.optifinePresent) {
                        overwriteNode = new IincInsnNode(2, 4);
                        loadMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        if (!ConfigManagerMicCore.enableDebug) break;
                        System.out.println("bls.loadRenderers (no Optifine) done");
                        break;
                    }
                    if (nodeAt.var != 6 || nodeAt.incr != 3 || !this.optifinePresent) continue;
                    overwriteNode = new IincInsnNode(6, 4);
                    loadMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    if (!ConfigManagerMicCore.enableDebug) break;
                    System.out.println("bls.loadRenderers (Optifine present) done");
                    break;
                }
            }
            if ((renderMethod = this.getMethod(node, KEY_METHOD_RENDERGLOBAL_SORTANDRENDER)) != null) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustRenderCamera", "()V"));
                renderMethod.instructions.insertBefore(renderMethod.instructions.get(0), toAdd);
                ++injectionCount;
                MethodInsnNode toAdd2 = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
                renderMethod.instructions.insertBefore(renderMethod.instructions.get(renderMethod.instructions.size() - 3), (AbstractInsnNode)toAdd2);
                ++injectionCount;
                if (ConfigManagerMicCore.enableDebug) {
                    System.out.println("bls.sortAndRender - both done");
                }
                int pos1 = 0;
                int pos2 = 0;
                int pos3 = 0;
                String fieldRenderersSkippingRenderPass = this.deobfuscated ? "renderersSkippingRenderPass" : "ac";
                String fieldPrevChunkSortZ = this.deobfuscated ? "prevChunkSortZ" : "k";
                String methodMarkRenderersForNewPosition = this.deobfuscated ? "markRenderersForNewPosition" : "c";
                for (int count = 0; count < renderMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = renderMethod.instructions.get(count);
                    if (nodeTest instanceof FieldInsnNode && nodeTest.getOpcode() == 181 && ((FieldInsnNode)nodeTest).name.equals(fieldRenderersSkippingRenderPass) && ((FieldInsnNode)nodeTest).desc.equals("I")) {
                        pos1 = count;
                        continue;
                    }
                    if (nodeTest instanceof FieldInsnNode && nodeTest.getOpcode() == 181 && ((FieldInsnNode)nodeTest).name.equals(fieldPrevChunkSortZ) && ((FieldInsnNode)nodeTest).desc.equals("I")) {
                        pos2 = count;
                        continue;
                    }
                    if (!(nodeTest instanceof MethodInsnNode) || nodeTest.getOpcode() != 183 || !((MethodInsnNode)nodeTest).name.equals(methodMarkRenderersForNewPosition) || !((MethodInsnNode)nodeTest).desc.equals("(III)V")) continue;
                    pos3 = count;
                }
                if (pos1 > 0 && pos2 > 0 && pos3 > 0) {
                    AbstractInsnNode[] instructionArray = renderMethod.instructions.toArray();
                    renderMethod.instructions.clear();
                    int count = 0;
                    while (count <= pos1) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos2 + 1;
                    while (count <= pos3) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos1 + 1;
                    while (count <= pos2) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos3 + 1;
                    while (count < instructionArray.length) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    ++injectionCount;
                } else {
                    System.out.println("[GC] Warning: Unable to modify bytecode for bls.markRenderersForNewPosition");
                }
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRenderManager(byte[] bytes) {
        MethodNode method;
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue() && (method = this.getMethod(node, KEY_METHOD_RENDERMANAGER)) != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode nodeTest = method.instructions.get(count);
                AbstractInsnNode nodeTestb = method.instructions.get(count + 1);
                if (!(nodeTest instanceof VarInsnNode) || !(nodeTestb instanceof VarInsnNode) || nodeTest.getOpcode() != 25 || nodeTestb.getOpcode() != 25 || ((VarInsnNode)nodeTest).var != 11 || ((VarInsnNode)nodeTestb).var != 1) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 2));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 4));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 6));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustRenderPos", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDD)V"));
                method.instructions.insertBefore(nodeTest, toAdd);
                ++injectionCount;
                break;
            }
            for (int i = count; i < method.instructions.size(); ++i) {
                AbstractInsnNode nodeTest = method.instructions.get(i);
                if (!(nodeTest instanceof FieldInsnNode) || nodeTest.getOpcode() != 178) continue;
                FieldInsnNode f = (FieldInsnNode)nodeTest;
                if (!f.owner.equals(this.getNameDynamic(KEY_CLASS_RENDER_MANAGER)) || !f.desc.equals("Z")) continue;
                MethodInsnNode toAdd = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
                method.instructions.insertBefore(nodeTest, (AbstractInsnNode)toAdd);
                ++injectionCount;
                if (!ConfigManagerMicCore.enableDebug) break;
                System.out.println("bnf - done2/2");
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformTileEntityRenderer(byte[] bytes) {
        MethodNode renderMethod;
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue() && (renderMethod = this.getMethod(node, KEY_METHOD_TILERENDERER_RENDERTILEAT)) != null) {
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 2));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 4));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 6));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustTileRenderPos", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDD)V"));
            renderMethod.instructions.insert(toAdd);
            ++injectionCount;
            AbstractInsnNode returnNode = renderMethod.instructions.get(renderMethod.instructions.size() - 1);
            for (int i = 0; i < renderMethod.instructions.size(); ++i) {
                AbstractInsnNode insnAt = renderMethod.instructions.get(i);
                if (insnAt.getOpcode() != 177) continue;
                returnNode = insnAt;
                break;
            }
            MethodInsnNode toAdd2 = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
            renderMethod.instructions.insertBefore(returnNode, (AbstractInsnNode)toAdd2);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityClass(byte[] bytes) {
        if (this.isServer) {
            return bytes;
        }
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_CAN_RENDER_FIRE);
        if (method != null) {
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode nodeAt = method.instructions.get(i);
                if (!(nodeAt instanceof MethodInsnNode) || nodeAt.getOpcode() != 182) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "shouldRenderFire", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)Z");
                method.instructions.set(nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityArrow(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_ON_UPDATE);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(Float.valueOf(0.05f))) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "getArrowGravity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_ARROW) + ";)F");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRendererLivingEntity(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_RENDER_MODEL);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (list.getOpcode() != 177) continue;
                AbstractInsnNode nodeAbove = method.instructions.get(count - 2);
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 2));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 3));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 4));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 5));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 6));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 7));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_RENDER_PLAYER_GC, "renderModelS", "(L" + this.getNameDynamic(KEY_CLASS_RENDERER_LIVING_ENTITY) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";FFFFFF)V"));
                method.instructions.insertBefore(nodeAbove, toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformWorld(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_RAIN_STRENGTH);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (list.getOpcode() != 25) continue;
                for (int i = 0; i < 6; ++i) {
                    method.instructions.remove(method.instructions.get(count + i));
                }
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, KEY_METHOD_RAIN_STRENGTH, "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";F)F"));
                toAdd.add((AbstractInsnNode)new InsnNode(174));
                method.instructions.insertBefore(method.instructions.get(count), toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformOptifine(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_REGISTEROF);
        if (method != null) {
            InsnNode toAdd = new InsnNode(177);
            method.instructions.insertBefore(method.instructions.get(0), (AbstractInsnNode)toAdd);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    private void printResultsAndReset(String nodeName) {
        if (operationCount > 0) {
            if (injectionCount >= operationCount) {
                this.printLog("Galacticraft successfully injected bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
            } else {
                System.err.println("Potential problem: Galacticraft did not complete injection of bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
            }
        }
    }

    private MethodNode getMethod(ClassNode node, String keyName) {
        for (MethodNode methodNode : node.methods) {
            if (!this.methodMatches(keyName, methodNode)) continue;
            return methodNode;
        }
        return null;
    }

    private MethodNode getMethodNoDesc(ClassNode node, String methodName) {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals(methodName)) continue;
            return methodNode;
        }
        return null;
    }

    private boolean methodMatches(String keyName, MethodInsnNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    private boolean methodMatches(String keyName, MethodNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    public String getName(String keyName) {
        return this.nodemap.get((Object)keyName).name;
    }

    public String getObfName(String keyName) {
        return this.nodemap.get((Object)keyName).obfuscatedName;
    }

    public String getNameDynamic(String keyName) {
        try {
            if (this.deobfuscated) {
                return this.getName(keyName);
            }
            return this.getObfName(keyName);
        }
        catch (NullPointerException e) {
            System.err.println("Could not find key: " + keyName);
            throw e;
        }
    }

    public String getDescDynamic(String keyName) {
        return ((MethodObfuscationEntry)this.nodemap.get((Object)keyName)).methodDesc;
    }

    private boolean classPathMatches(String keyName, String className) {
        return className.replace('.', '/').equals(this.getNameDynamic(keyName));
    }

    private void printLog(String message) {
        System.out.println(message);
    }

    private ClassNode startInjection(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        injectionCount = 0;
        operationCount = 0;
        return node;
    }

    private byte[] finishInjection(ClassNode node) {
        return this.finishInjection(node, true);
    }

    private byte[] finishInjection(ClassNode node, boolean printToLog) {
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        if (printToLog) {
            this.printResultsAndReset(node.name);
        }
        return writer.toByteArray();
    }

    private boolean getSmallMoonsEnabled() {
        return false;
    }

    private boolean isPlayerApiActive() {
        return this.playerApiActive;
    }

    private boolean mcVersionMatches(String testVersion) {
        return VersionParser.parseRange((String)testVersion).containsVersion((ArtifactVersion)this.mcVersion);
    }

    public static class FieldObfuscationEntry
    extends ObfuscationEntry {
        public FieldObfuscationEntry(String name, String obfuscatedName) {
            super(name, obfuscatedName);
        }
    }

    public static class MethodObfuscationEntry
    extends ObfuscationEntry {
        public String methodDesc;

        public MethodObfuscationEntry(String name, String obfuscatedName, String methodDesc) {
            super(name, obfuscatedName);
            this.methodDesc = methodDesc;
        }

        public MethodObfuscationEntry(String commonName, String methodDesc) {
            this(commonName, commonName, methodDesc);
        }
    }

    public static class ObfuscationEntry {
        public String name;
        public String obfuscatedName;

        public ObfuscationEntry(String name, String obfuscatedName) {
            this.name = name;
            this.obfuscatedName = obfuscatedName;
        }

        public ObfuscationEntry(String commonName) {
            this(commonName, commonName);
        }
    }
}

