/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.ISyncPart;

public abstract class SyncPart
implements ISyncPart {
    private byte id = (byte)-1;
    private String name;
    private List<NBTHelper.SyncType> types = Lists.newArrayList((Object[])new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.SYNC});

    public SyncPart(int id) {
        this.id = (byte)id;
    }

    public SyncPart(String name) {
        this.name = name;
    }

    public String getTagName() {
        if (this.name == null) {
            return String.valueOf(this.id);
        }
        return this.name;
    }

    @Override
    public final void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            this.writeObject(buf);
            this.updateSync();
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public final void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.readObject(buf);
        }
    }

    @Override
    public final void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (!this.equal()) {
                this.writeObject(nbt, type);
                this.updateSync();
            }
        } else if (type == NBTHelper.SyncType.SAVE) {
            this.writeObject(nbt, type);
            this.updateSync();
        }
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC) {
            if (nbt.func_74764_b(this.getTagName())) {
                this.readObject(nbt, type);
            }
        } else if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(this.getTagName())) {
            this.readObject(nbt, type);
        }
    }

    @Override
    public boolean canSync(NBTHelper.SyncType syncType) {
        return this.types.contains((Object)syncType);
    }

    public SyncPart addSyncType(NBTHelper.SyncType syncType) {
        if (!this.types.contains((Object)syncType)) {
            this.types.add(syncType);
        }
        return this;
    }

    public SyncPart removeSyncType(NBTHelper.SyncType syncType) {
        if (this.types.contains((Object)syncType)) {
            this.types.remove((Object)syncType);
        }
        return this;
    }

    public abstract void updateSync();

    public abstract void writeObject(ByteBuf var1);

    public abstract void readObject(ByteBuf var1);

    public abstract void writeObject(NBTTagCompound var1, NBTHelper.SyncType var2);

    public abstract void readObject(NBTTagCompound var1, NBTHelper.SyncType var2);
}

