/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.core.utils.IBufManager;
import sonar.core.utils.IBufObject;

public class SyncGeneric<T extends IBufObject>
extends SyncPart {
    private T c;
    private T last;
    private IBufManager<T> manager;

    public SyncGeneric(IBufManager<T> manager, int id) {
        super(id);
        this.manager = manager;
    }

    public SyncGeneric(IBufManager<T> manager, String name) {
        super(name);
        this.manager = manager;
    }

    public void setDefault(T def) {
        this.c = def;
        this.last = def;
    }

    @Override
    public boolean equal() {
        return this.manager.areTypesEqual(this.c, this.last);
    }

    public void setObject(T value) {
        this.c = value;
    }

    public T getObject() {
        return this.c;
    }

    @Override
    public void updateSync() {
        this.last = this.c;
    }

    @Override
    public void writeObject(ByteBuf buf) {
        this.manager.writeToBuf(buf, this.c);
    }

    @Override
    public void readObject(ByteBuf buf) {
        this.c = this.manager.readFromBuf(buf);
    }

    @Override
    public void writeObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag = new NBTTagCompound();
        this.manager.writeToNBT(infoTag, this.c);
        nbt.func_74782_a(this.getTagName(), (NBTBase)infoTag);
    }

    @Override
    public void readObject(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.c = (IBufObject)this.manager.readFromNBT(nbt.func_74775_l(this.getTagName()));
    }

    public String toString() {
        return this.c.toString();
    }
}

