/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import sonar.core.helpers.RecipeHelper;

public abstract class AbstractProcessorHandler
extends TemplateRecipeHandler {
    public abstract RecipeHelper recipeHelper();

    public abstract Class<? extends GuiContainer> getGuiClass();

    public abstract String getRecipeName();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(66, 19, 24, 10), this.getOverlayIdentifier(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(44, 52, 78, 10), "calculatordischarge", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && AbstractProcessorHandler.class.isAssignableFrom(((Object)((Object)this)).getClass())) {
            Map<Object[], Object[]> recipes = this.recipeHelper().getRecipes();
            for (Map.Entry<Object[], Object[]> recipe : recipes.entrySet()) {
                this.arecipes.add(new ProcessingRecipe(recipe.getKey()[0], recipe.getValue()[0]));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<Object[], Object[]> recipes = this.recipeHelper().getRecipes();
        for (Map.Entry<Object[], Object[]> recipe : recipes.entrySet()) {
            int pos = this.recipeHelper().containsStack(result, recipe.getValue(), false);
            if (pos == -1) continue;
            this.arecipes.add(new ProcessingRecipe(recipe.getKey()[0], recipe.getValue()[0]));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getOverlayIdentifier()) && AbstractProcessorHandler.class.isAssignableFrom(((Object)((Object)this)).getClass())) {
            this.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<Object[], Object[]> recipes = this.recipeHelper().getRecipes();
        for (Map.Entry<Object[], Object[]> recipe : recipes.entrySet()) {
            int pos = this.recipeHelper().containsStack(ingredient, recipe.getKey(), false);
            if (pos == -1) continue;
            this.arecipes.add(new ProcessingRecipe(recipe.getKey()[0], recipe.getValue()[0]));
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(71, 13, 176, 10, 24, 16, 48, 0);
    }

    public class ProcessingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack result;

        public ProcessingRecipe(Object input, Object result) {
            super((TemplateRecipeHandler)AbstractProcessorHandler.this);
            if (input instanceof RecipeHelper.OreStack) {
                input = ((RecipeHelper.OreStack)((Object)input)).getStacks();
            }
            this.input = new PositionedStack(input, 48, 13);
            this.result = new PositionedStack(result, 102, 13);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AbstractProcessorHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

