/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.SonarLoader;

public class SonarHelper {
    public static boolean isAdjacentEnergyHandlerFromSide(TileEntity tile, int side) {
        TileEntity handler = SonarHelper.getAdjacentTileEntity(tile, ForgeDirection.getOrientation((int)side));
        return SonarHelper.isEnergyHandlerFromSide(handler, ForgeDirection.VALID_DIRECTIONS[side ^ 1]);
    }

    public static boolean isAdjacentEnergyHandlerFromSide(TileEntity tile, ForgeDirection side) {
        TileEntity handler = SonarHelper.getAdjacentTileEntity(tile, side);
        return SonarHelper.isEnergyHandlerFromSide(handler, side.getOpposite());
    }

    public static boolean isEnergyHandlerFromSide(TileEntity tile, ForgeDirection from) {
        if (tile instanceof IEnergyProvider || tile instanceof IEnergyReceiver) {
            IEnergyConnection handler = (IEnergyConnection)tile;
            return handler.canConnectEnergy(from);
        }
        if (tile instanceof IEnergySink) {
            IEnergySink handler = (IEnergySink)tile;
            return handler.acceptsEnergyFrom(tile, from);
        }
        return false;
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tile, ForgeDirection side) {
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + side.offsetX, tile.field_145848_d + side.offsetY, tile.field_145849_e + side.offsetZ);
    }

    public static Block getAdjacentBlock(World world, BlockCoords coords, ForgeDirection side) {
        return world.func_147439_a(coords.getX() + side.offsetX, coords.getY() + side.offsetY, coords.getZ() + side.offsetZ);
    }

    public static boolean isEnergyHandler(TileEntity tile) {
        if (tile instanceof IEnergyHandler) {
            return true;
        }
        return SonarLoader.ic2Loaded() && tile instanceof IEnergyTile;
    }

    public static int pushEnergy(TileEntity tile, ForgeDirection dir, int amount, boolean simulate) {
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            return handler.receiveEnergy(dir, amount, simulate);
        }
        return 0;
    }

    public static int pullEnergy(TileEntity tile, ForgeDirection dir, int amount, boolean simulate) {
        if (tile instanceof IEnergyProvider) {
            IEnergyProvider handler = (IEnergyProvider)tile;
            return handler.extractEnergy(dir, amount, simulate);
        }
        return 0;
    }

    public static void dropTile(EntityPlayer player, Block block, World world, int x, int y, int z) {
        if (SonarLoader.calculatorLoaded() && block == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMastBlock")) {
            if (world.func_147439_a(x, y - 1, z) == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_149636_a(world, player, x, y - 1, z, world.func_72805_g(x, y - 1, z));
            } else if (world.func_147439_a(x, y - 2, z) == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_149636_a(world, player, x, y - 2, z, world.func_72805_g(x, y - 2, z));
            } else if (world.func_147439_a(x, y - 3, z) == GameRegistry.findBlock((String)"Calculator", (String)"ConductorMast")) {
                block.func_149636_a(world, player, x, y - 3, z, world.func_72805_g(x, y - 3, z));
            }
        } else {
            block.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    public static Entity getNearestEntity(Class entityClass, TileEntity tile, int range) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(tile.field_145851_c - range), (double)(tile.field_145848_d - range), (double)(tile.field_145849_e - range), (double)(tile.field_145851_c + range), (double)(tile.field_145848_d + range), (double)(tile.field_145849_e + range));
        List entities = tile.func_145831_w().func_72872_a(entityClass, aabb);
        Entity entity = null;
        double closest = Double.MAX_VALUE;
        for (int i = 0; i < entities.size(); ++i) {
            Entity target = (Entity)entities.get(i);
            double d0 = (double)tile.field_145851_c - target.field_70165_t;
            double d1 = (double)tile.field_145848_d - target.field_70163_u;
            double d2 = (double)tile.field_145849_e - target.field_70161_v;
            double distance = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(distance < closest)) continue;
            entity = target;
            closest = distance;
        }
        return entity;
    }

    public static ForgeDirection getForward(int meta) {
        return ForgeDirection.getOrientation((int)meta).getOpposite();
    }

    public static int getAngleFromMeta(int meta) {
        switch (meta) {
            case 2: {
                return 180;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 270;
            }
        }
        return 0;
    }

    public static int invertMetadata(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public static ItemStack createStackedBlock(Block block, int meta) {
        if (block == null) {
            return null;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return null;
        }
        int j = 0;
        if (item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }
}

