/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.calculator.mod.api.CalculatorAPI;
import sonar.core.SonarCore;
import sonar.core.helpers.ItemStackHelper;
import sonar.core.integration.SonarLoader;

public abstract class RecipeHelper {
    public int outputSize;
    public int inputSize;
    public boolean shapeless;
    protected Map<Object[], Object[]> recipeList = new ConcurrentHashMap<Object[], Object[]>();

    public abstract void addRecipes();

    public abstract String getRecipeID();

    public RecipeHelper(int inputSize, int outputSize, boolean shapeless) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.shapeless = shapeless;
        this.addRecipes();
        this.addRegisteredRecipes();
    }

    public void addRegisteredRecipes() {
        List recipes;
        if (SonarLoader.calculatorLoaded() && (recipes = CalculatorAPI.getRecipes((String)this.getRecipeID())) != null && recipes.size() != 0) {
            for (Object[] object : recipes) {
                this.addRecipe(object);
            }
        }
    }

    public Map<Object[], Object[]> getRecipes() {
        return this.recipeList;
    }

    public void addRecipe(Object ... objects) {
        Object[] stack = new Object[objects.length];
        if (objects.length != this.inputSize + this.outputSize) {
            SonarCore.logger.error("RecipeHelper - A recipeOutput wasn't added because the size didn't match!");
            return;
        }
        try {
            for (int i = 0; i < objects.length; ++i) {
                ArrayList ores;
                if (objects[i] == null) {
                    return;
                }
                if (objects[i] instanceof String) {
                    if (i < this.inputSize) {
                        stack[i] = new OreStack((String)objects[i], 1);
                        continue;
                    }
                    if (i - this.inputSize > this.outputSize) continue;
                    ores = OreDictionary.getOres((String)((String)objects[i]));
                    if (ores.size() > 0) {
                        stack[i] = ores.get(0);
                        continue;
                    }
                    return;
                }
                if (objects[i] instanceof OreStack) {
                    if (i - this.inputSize >= this.outputSize) continue;
                    ores = OreDictionary.getOres((String)((OreStack)objects[i]).oreString);
                    if (ores.size() > 0) {
                        stack[i] = new ItemStack(((ItemStack)ores.get(0)).func_77973_b(), ((OreStack)objects[i]).stackSize, ((ItemStack)ores.get(0)).func_77960_j());
                        continue;
                    }
                    return;
                }
                if (objects[i] instanceof ItemStack[]) {
                    for (ItemStack checkStack : (ItemStack[])objects[i]) {
                        if (checkStack != null) continue;
                        return;
                    }
                    stack[i] = objects[i];
                    continue;
                }
                stack[i] = objects[i] instanceof Integer ? objects[i] : ItemStackHelper.createStack(objects[i]);
            }
            this.addFinal(stack);
        }
        catch (Exception exception) {
            SonarCore.logger.error("RecipeHelper : Exception Loading Recipe", (Throwable)exception);
        }
    }

    private void addFinal(Object[] stacks) {
        Object[] input = new Object[this.inputSize];
        Object[] output = new Object[this.outputSize];
        for (int i = 0; i < stacks.length; ++i) {
            if (i < this.inputSize) {
                input[i] = stacks[i];
                continue;
            }
            if (i - this.inputSize <= this.outputSize) {
                output[i - this.inputSize] = stacks[i];
                continue;
            }
            throw new RuntimeException("Something went wrong! A recipeOutput was too big");
        }
        this.addRecipe(input, output);
    }

    public void addRecipe(Object[] input, Object[] output) {
        this.recipeList.put(input, output);
    }

    public ItemStack getOutput(int output, ItemStack ... input) {
        ItemStack[] objs = this.getOutput(input);
        if (objs == null) {
            return null;
        }
        return objs[output];
    }

    public ItemStack[] getOutput(ItemStack ... input) {
        return this.convertOutput(this.getOutputRaw(input));
    }

    public Object[] getOutputRaw(ItemStack ... input) {
        if (input == null || input.length < this.inputSize) {
            return null;
        }
        for (int i = 0; i < this.inputSize; ++i) {
            if (input[i] != null) continue;
            return null;
        }
        for (Map.Entry<Object[], Object[]> entry : this.recipeList.entrySet()) {
            if (!this.checkInput(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public int getInputSize(int input, ItemStack ... output) {
        Object[] inputs = this.getInput(output);
        if (inputs == null) {
            return 1;
        }
        return Math.max(1, this.getInputSize(inputs)[input]);
    }

    private Object[] getInput(ItemStack ... output) {
        Map.Entry<Object[], Object[]> entry;
        if (output.length != this.outputSize) {
            return new Object[this.inputSize];
        }
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != null) continue;
            return new Object[this.inputSize];
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return new Object[this.inputSize];
        } while (!this.checkOutput(output, (entry = iterator.next()).getValue()));
        return entry.getKey();
    }

    public boolean validInput(ItemStack input) {
        Map.Entry<Object[], Object[]> entry;
        if (input == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(input, (entry = iterator.next()).getKey(), false) == -1);
        return true;
    }

    public boolean validOutput(ItemStack output) {
        Map.Entry<Object[], Object[]> entry;
        if (output == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(output, (entry = iterator.next()).getKey(), false) == -1);
        return true;
    }

    private ItemStack[] convertOutput(Object[] output) {
        if (output == null) {
            return new ItemStack[0];
        }
        ItemStack[] stack = new ItemStack[output.length];
        for (int i = 0; i < output.length; ++i) {
            if (output[i] instanceof ItemStack) {
                stack[i] = (ItemStack)output[i];
                continue;
            }
            if (!(output[i] instanceof OreStack)) continue;
            ArrayList ore = OreDictionary.getOres((String)((OreStack)output[i]).oreString);
            stack[i] = new ItemStack(((ItemStack)ore.get(0)).func_77973_b(), ((OreStack)output[i]).stackSize, ((ItemStack)ore.get(0)).func_77960_j());
        }
        return stack;
    }

    private int[] getInputSize(Object[] input) {
        int[] sizes = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] instanceof ItemStack) {
                sizes[i] = ((ItemStack)input[i]).field_77994_a;
                continue;
            }
            if (input[i] instanceof ItemStack[]) {
                sizes[i] = ((ItemStack[])input[i])[0].field_77994_a;
                continue;
            }
            if (!(input[i] instanceof OreStack)) continue;
            sizes[i] = ((OreStack)input[i]).stackSize;
        }
        return sizes;
    }

    private boolean checkInput(ItemStack[] input, Object[] key) {
        if (input.length != key.length && input.length == this.inputSize) {
            return false;
        }
        if (!this.shapeless) {
            for (int i = 0; i < this.inputSize; ++i) {
                if (key[i] instanceof ItemStack) {
                    if (this.equalStack(input[i], (ItemStack)key[i], true)) continue;
                    return false;
                }
                if (key[i] instanceof ItemStack[]) {
                    if (this.containsStack(input[i], (ItemStack[])key[i], true) != -1) continue;
                    return false;
                }
                if (!(key[i] instanceof OreStack)) continue;
                int oreID = OreDictionary.getOreID((String)((OreStack)key[i]).oreString);
                boolean found = false;
                for (int id : OreDictionary.getOreIDs((ItemStack)input[i])) {
                    if (id != oreID) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else {
            ArrayList<Object> recipe = new ArrayList<Object>(Arrays.asList(key));
            boolean[] used = new boolean[this.inputSize];
            for (int i = 0; i < this.inputSize; ++i) {
                ItemStack target = input[i];
                if (target == null) continue;
                boolean flag = false;
                block3: for (Object obj : recipe) {
                    if (obj instanceof ItemStack) {
                        if (!this.equalStack(target, (ItemStack)obj, true)) continue;
                        flag = true;
                        recipe.remove(obj);
                        break;
                    }
                    if (obj instanceof ItemStack[]) {
                        if (this.containsStack(input[i], (ItemStack[])obj, true) == -1) continue;
                        flag = true;
                        recipe.remove(obj);
                        break;
                    }
                    if (!(obj instanceof OreStack)) continue;
                    int oreID = OreDictionary.getOreID((String)((OreStack)obj).oreString);
                    for (int id : OreDictionary.getOreIDs((ItemStack)target)) {
                        if (id != oreID) continue;
                        flag = true;
                        continue block3;
                    }
                }
                if (flag) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkOutput(ItemStack[] output, Object[] key) {
        if (output.length != key.length && output.length == this.inputSize) {
            return false;
        }
        for (int i = 0; i < output.length; ++i) {
            if (!(key[i] instanceof ItemStack ? !this.equalStack(output[i], (ItemStack)key[i], true) : key[i] instanceof ItemStack[] && this.containsStack(output[i], (ItemStack[])key[i], true) == -1)) continue;
            return false;
        }
        return true;
    }

    public int containsStack(ItemStack stack, Object[] key, boolean checkSize) {
        for (int i = 0; i < key.length; ++i) {
            if (key[i] == null) continue;
            if (key[i] instanceof ItemStack) {
                if (!this.equalStack(stack, (ItemStack)key[i], checkSize)) continue;
                return i;
            }
            if (key[i] instanceof ItemStack[]) {
                for (int s = 0; s < ((ItemStack[])key[i]).length; ++s) {
                    ItemStack target = ((ItemStack[])key[i])[s];
                    if (target == null || !this.equalStack(stack, target, checkSize)) continue;
                    return i;
                }
                continue;
            }
            if (!(key[i] instanceof OreStack)) continue;
            int oreID = OreDictionary.getOreID((String)((OreStack)key[i]).oreString);
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (id != oreID) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean equalStack(ItemStack stack, ItemStack key, boolean checkSize) {
        return !(stack.func_77973_b() != key.func_77973_b() || key.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != key.func_77960_j() || checkSize && key.field_77994_a > stack.field_77994_a);
    }

    private int findStackSize(ItemStack stack, Object[] key, int pos) {
        if (key[pos] != null) {
            if (key[pos] instanceof ItemStack) {
                if (this.equalStack(stack, (ItemStack)key[pos], false)) {
                    return ((ItemStack)key[pos]).field_77994_a;
                }
            } else {
                if (key[pos] instanceof ItemStack[]) {
                    return this.findStackSize(stack, (ItemStack[])key[pos], pos);
                }
                if (key[pos] instanceof OreStack) {
                    return ((OreStack)key[pos]).stackSize;
                }
            }
        }
        return -1;
    }

    public ItemStack getCraftingResult(ItemStack ... inputs) {
        ItemStack[] output = this.getOutput(inputs);
        if (output == null || output.length == 0 || output[0] == null) {
            return null;
        }
        ItemStack result = output[0].func_77946_l();
        if (result.field_77994_a <= 0) {
            result.field_77994_a = 1;
        }
        return result;
    }

    public boolean removeRecipe(Object ... inputs) {
        if (inputs.length != this.inputSize) {
            FMLLog.severe((String)"Attempted to remove a recipeOutput but input amount doesn't match recipeOutput input", (Object[])new Object[0]);
            return false;
        }
        for (Map.Entry<Object[], Object[]> entry : this.recipeList.entrySet()) {
            boolean[] found = new boolean[this.inputSize];
            for (int i = 0; i < this.inputSize; ++i) {
                found[i] = false;
                Object input = inputs[i];
                for (int ii = 0; ii < this.inputSize; ++ii) {
                    Object recipeInput = entry.getKey()[ii];
                    if (input instanceof ItemStack && recipeInput instanceof ItemStack && ItemStackHelper.equalStacksRegular((ItemStack)input, (ItemStack)recipeInput)) {
                        found[i] = true;
                    }
                    if (input instanceof OreStack && recipeInput instanceof OreStack && ((OreStack)input).oreString.equals(((OreStack)recipeInput).oreString)) {
                        found[i] = true;
                    }
                    if (input != recipeInput) continue;
                    found[i] = true;
                }
            }
            boolean remove = true;
            for (boolean result : found) {
                if (result) continue;
                remove = false;
            }
            if (!remove) continue;
            this.recipeList.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public static class OreStack {
        public String oreString;
        public int stackSize;
        private List<ItemStack> stacks;

        public OreStack(String oreString, int stackSize) {
            this.oreString = oreString;
            this.stackSize = stackSize;
        }

        public String toString() {
            return String.format("%dx%s", this.stackSize, this.oreString);
        }

        public List<ItemStack> getStacks() {
            if (this.stacks == null) {
                this.stacks = OreDictionary.getOres((String)this.oreString);
            }
            return this.stacks;
        }
    }
}

