/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.integration.SonarLoader;

public class ItemStackHelper {
    public static boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return ItemStackHelper.equalStacksRegular(stack1, stack2) && !ItemStackHelper.isCircuit(stack1.func_77973_b()) && stack1.field_77994_a < stack1.func_77976_d();
    }

    public static boolean equalStacksRegular(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack restoreItemStack(ItemStack stack, int size) {
        ItemStack result = stack.func_77946_l();
        if (result.field_77994_a <= 0) {
            result.field_77994_a = 1;
        }
        return result;
    }

    public static boolean isCircuit(Item item) {
        if (SonarLoader.calculatorLoaded()) {
            if (item == GameRegistry.findItem((String)"Calculator", (String)"CircuitBoard")) {
                return true;
            }
            if (item == GameRegistry.findItem((String)"Calculator", (String)"CircuitDamaged")) {
                return true;
            }
            if (item == GameRegistry.findItem((String)"Calculator", (String)"CircuitDirty")) {
                return true;
            }
        }
        return false;
    }

    public static ItemStack createStack(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException("Invalid ItemStack!");
        }
        return new ItemStack((Block)obj, 1);
    }

    public static boolean matchingModid(ItemStack target, ItemStack stack) {
        GameRegistry.UniqueIdentifier targetID = GameRegistry.findUniqueIdentifierFor((Item)target.func_77973_b());
        GameRegistry.UniqueIdentifier stackID = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        if (targetID != null && stackID != null && targetID.modId != null && stackID.modId != null) {
            return targetID.modId.equals(stackID.modId);
        }
        return false;
    }

    public static boolean matchingOreDictID(ItemStack target, ItemStack stack) {
        int[] stackIDs = OreDictionary.getOreIDs((ItemStack)stack);
        int[] filterIDs = OreDictionary.getOreIDs((ItemStack)target);
        for (int sID : stackIDs) {
            for (int fID : filterIDs) {
                if (sID != fID) continue;
                return true;
            }
        }
        return false;
    }
}

