/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;
import sonar.core.api.ActionType;
import sonar.core.api.InventoryHandler;
import sonar.core.api.StoredItemStack;

public class StorageChamberInventoryProvider
extends InventoryHandler {
    public static String name = "Storage Chamber";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canHandleItems(TileEntity tile, ForgeDirection dir) {
        return tile instanceof TileEntityStorageChamber;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, ForgeDirection dir) {
        ItemStack stack;
        TileEntityStorageChamber chamber;
        if (slot >= 14) {
            return null;
        }
        if (tile instanceof TileEntityStorageChamber && (chamber = (TileEntityStorageChamber)tile) != null && chamber.getSavedStack() != null && (stack = chamber.getFullStack(slot)) != null) {
            return new StoredItemStack(stack);
        }
        return null;
    }

    @Override
    public InventoryHandler.StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        TileEntityStorageChamber chamber;
        if (tile instanceof TileEntityStorageChamber && (chamber = (TileEntityStorageChamber)tile) != null && chamber.getSavedStack() != null) {
            long stored = 0L;
            long maxStorage = 0L;
            for (int i = 0; i < 14; ++i) {
                ItemStack stack = chamber.getFullStack(i);
                if (stack != null) {
                    stored += (long)stack.field_77994_a;
                    storedStacks.add(new StoredItemStack(stack));
                }
                maxStorage += (long)TileEntityStorageChamber.maxSize;
            }
            return new InventoryHandler.StorageSize(stored, maxStorage);
        }
        return InventoryHandler.StorageSize.EMPTY;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"Calculator");
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        TileEntityStorageChamber chamber = (TileEntityStorageChamber)tile;
        if (chamber.getSavedStack() != null) {
            if (TileEntityStorageChamber.getCircuitType((ItemStack)add.getItemStack()) == TileEntityStorageChamber.getCircuitType((ItemStack)chamber.getSavedStack())) {
                int stored = chamber.getStored()[add.getItemDamage()];
                if (stored == TileEntityStorageChamber.maxSize) {
                    return add;
                }
                if ((long)stored + add.getStackSize() <= (long)TileEntityStorageChamber.maxSize) {
                    if (!action.shouldSimulate()) {
                        chamber.increaseStored(add.getItemDamage(), (int)add.getStackSize());
                    }
                    return null;
                }
                if (!action.shouldSimulate()) {
                    chamber.setStored(add.getItemDamage(), TileEntityStorageChamber.maxSize);
                }
                add.stored -= (long)(TileEntityStorageChamber.maxSize - stored);
                return add;
            }
        } else if (TileEntityStorageChamber.getCircuitType((ItemStack)add.getItemStack()) != null) {
            if (!action.shouldSimulate()) {
                chamber.setSavedStack(add.getItemStack().func_77946_l());
            }
            if (add.getStackSize() <= (long)TileEntityStorageChamber.maxSize) {
                if (!action.shouldSimulate()) {
                    int n = add.getItemDamage();
                    chamber.stored[n] = (int)((long)chamber.stored[n] + add.getStackSize());
                }
                return null;
            }
            if (!action.shouldSimulate()) {
                chamber.stored[add.getItemDamage()] = TileEntityStorageChamber.maxSize;
            }
            add.stored -= (long)TileEntityStorageChamber.maxSize;
            return add;
        }
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        TileEntityStorageChamber chamber = (TileEntityStorageChamber)tile;
        if (chamber.getSavedStack() != null) {
            int stored;
            if (TileEntityStorageChamber.getCircuitType((ItemStack)remove.getItemStack()) == TileEntityStorageChamber.getCircuitType((ItemStack)chamber.getSavedStack()) && (stored = chamber.stored[remove.getItemDamage()]) != 0) {
                if ((long)stored <= remove.getStackSize()) {
                    ItemStack stack = chamber.getFullStack(remove.getItemDamage());
                    if (!action.shouldSimulate()) {
                        chamber.stored[remove.getItemDamage()] = 0;
                        chamber.resetSavedStack(remove.getItemDamage());
                    }
                    remove.stored -= (long)stack.field_77994_a;
                } else {
                    ItemStack stack = chamber.getSlotStack(remove.getItemDamage(), (int)remove.getStackSize());
                    if (!action.shouldSimulate()) {
                        int n = remove.getItemDamage();
                        chamber.stored[n] = (int)((long)chamber.stored[n] - remove.getStackSize());
                    }
                    return null;
                }
            }
        }
        return remove;
    }
}

