/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.ILPPipe;
import logisticspipes.api.ILPPipeTile;
import logisticspipes.api.IRequestAPI;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;

public class LPInventoryProvider
extends InventoryHandler {
    public static String name = "LP-Inventory";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canHandleItems(TileEntity tile, ForgeDirection dir) {
        return tile instanceof ILPPipeTile;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, ForgeDirection dir) {
        List<ItemStack> items = this.getStackList(tile);
        if (slot < items.size()) {
            return new StoredItemStack(items.get(slot));
        }
        return null;
    }

    @Override
    public InventoryHandler.StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        List<ItemStack> items = this.getStackList(tile);
        if (items == null || items.isEmpty()) {
            return InventoryHandler.StorageSize.EMPTY;
        }
        long maxStorage = 0L;
        for (ItemStack stack : items) {
            SonarAPI.getItemHelper().addStackToList(storedStacks, new StoredItemStack(stack));
            maxStorage += (long)stack.field_77994_a;
        }
        return new InventoryHandler.StorageSize(maxStorage, maxStorage);
    }

    public List<ItemStack> getStackList(TileEntity tile) {
        ILPPipe pipe;
        if (tile instanceof ILPPipeTile && (pipe = ((ILPPipeTile)tile).getLPPipe()) instanceof IRequestAPI) {
            IRequestAPI request = (IRequestAPI)pipe;
            List items = request.getProvidedItems();
            return items;
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"LogisticsPipes");
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        ILPPipe pipe;
        if (tile instanceof ILPPipeTile && (pipe = ((ILPPipeTile)tile).getLPPipe()) instanceof IRequestAPI) {
            IRequestAPI request = (IRequestAPI)pipe;
            if (!action.shouldSimulate()) {
                List missing = request.performRequest(remove.getFullStack());
                if (missing == null) {
                    return null;
                }
                long removed = remove.stored;
                for (ItemStack stack : missing) {
                    removed -= (long)stack.field_77994_a;
                }
                remove.setStackSize(removed);
            } else {
                IRequestAPI.SimulationResult result = request.simulateRequest(remove.getFullStack());
                if (result.missing == null) {
                    return null;
                }
                long removed = remove.stored;
                for (ItemStack stack : result.missing) {
                    removed -= (long)stack.field_77994_a;
                }
                remove.setStackSize(removed);
            }
        }
        return remove;
    }
}

