/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;

public class IInventoryProvider
extends InventoryHandler {
    public static String name = "Standard Inventory";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canHandleItems(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IInventory;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, ForgeDirection dir) {
        ItemStack stack;
        IInventory inv = (IInventory)tile;
        if (slot < inv.func_70302_i_() && (stack = inv.func_70301_a(slot)) != null) {
            return new StoredItemStack(stack);
        }
        return null;
    }

    @Override
    public InventoryHandler.StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            return SonarAPI.getItemHelper().addInventoryToList(storedStacks, inv);
        }
        return InventoryHandler.StorageSize.EMPTY;
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        IInventory inv = (IInventory)tile;
        int invSize = inv.func_70302_i_();
        int limit = inv.func_70297_j_();
        int[] slots = null;
        if (tile instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)tile;
            slots = sidedInv.func_94128_d(dir.ordinal());
            invSize = slots.length;
        }
        for (int i = 0; i < invSize; ++i) {
            long used;
            int slot;
            int n = slot = slots != null ? slots[i] : i;
            if (!inv.func_94041_b(slot, add.item) || tile instanceof ISidedInventory && !((ISidedInventory)tile).func_102007_a(slot, add.item, dir.ordinal())) continue;
            ItemStack stored = inv.func_70301_a(slot);
            if (stored != null) {
                long used2;
                ItemStack stack = stored.func_77946_l();
                if (add.equalStack(stack) && stack.field_77994_a < limit && stack.field_77994_a < stack.func_77976_d() && (used2 = Math.min((long)(add.item.func_77976_d() - stack.field_77994_a), Math.min(add.stored, (long)(limit - stack.field_77994_a)))) > 0L) {
                    stack.field_77994_a = (int)((long)stack.field_77994_a + used2);
                    add.stored -= used2;
                    if (!action.shouldSimulate()) {
                        inv.func_70299_a(slot, stack.func_77946_l());
                        inv.func_70296_d();
                    }
                }
            } else if (add.item != null && add.item.func_77973_b() != null && (used = Math.min((long)add.item.func_77976_d(), Math.min(add.stored, (long)limit))) > 0L) {
                add.stored -= used;
                if (!action.shouldSimulate()) {
                    inv.func_70299_a(slot, new StoredItemStack(add.getFullStack()).setStackSize(used).getFullStack());
                    inv.func_70296_d();
                }
            }
            if (add.stored != 0L) continue;
            return null;
        }
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        IInventory inv;
        IInventory adjust = inv = (IInventory)tile;
        int invSize = inv.func_70302_i_();
        int[] slots = null;
        if (tile instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)tile;
            slots = sidedInv.func_94128_d(dir.ordinal());
            invSize = slots.length;
        }
        for (int i = 0; i < invSize; ++i) {
            int slot = slots != null ? slots[i] : i;
            ItemStack stored = inv.func_70301_a(slot);
            if (stored == null) continue;
            ItemStack stack = stored.func_77946_l();
            if (tile instanceof ISidedInventory && !((ISidedInventory)tile).func_102008_b(slot, stack, dir.ordinal()) || !remove.equalStack(stack)) continue;
            long used = Math.min(remove.stored, (long)Math.min(inv.func_70297_j_(), stack.field_77994_a));
            stack.field_77994_a = (int)((long)stack.field_77994_a - used);
            remove.stored -= used;
            if (stack.field_77994_a == 0) {
                stack = null;
            }
            if (!action.shouldSimulate()) {
                inv.func_70299_a(slot, stack);
                inv.func_70296_d();
            }
            if (remove.stored != 0L) continue;
            return null;
        }
        return new StoredItemStack(remove.item, remove.stored);
    }
}

