/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.tileentity.IEnergyInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.EnergyHandler;
import sonar.core.api.EnergyType;
import sonar.core.api.StoredEnergyStack;

public class RFHandler
extends EnergyHandler {
    public static String name = "RF-Provider";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideEnergy(TileEntity tile, ForgeDirection dir) {
        return tile != null && (tile instanceof IEnergyInfo || tile instanceof IEnergyReceiver || tile instanceof IEnergyProvider);
    }

    @Override
    public void getEnergy(StoredEnergyStack energyStack, TileEntity tile, ForgeDirection dir) {
        if (tile == null) {
            return;
        }
        if (tile instanceof IEnergyInfo) {
            IEnergyInfo info = (IEnergyInfo)tile;
            energyStack.setStorageValues(info.getInfoEnergyStored(), info.getInfoMaxEnergyStored());
            energyStack.setUsage(info.getInfoEnergyPerTick());
        }
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver receiver = (IEnergyReceiver)tile;
            energyStack.setStorageValues(receiver.getEnergyStored(dir), receiver.getMaxEnergyStored(dir));
            int simulateAdd = receiver.receiveEnergy(dir, Integer.MAX_VALUE, true);
            energyStack.setMaxInput(simulateAdd);
        }
        if (tile instanceof IEnergyProvider) {
            IEnergyProvider provider = (IEnergyProvider)tile;
            energyStack.setStorageValues(provider.getEnergyStored(dir), provider.getMaxEnergyStored(dir));
            int simulateRemove = provider.extractEnergy(dir, Integer.MAX_VALUE, true);
            energyStack.setMaxOutput(simulateRemove);
        }
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        IEnergyReceiver receiver;
        if (tile instanceof IEnergyReceiver && (receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.getOpposite())) {
            int transferRF = transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE;
            transfer.stored -= (long)receiver.receiveEnergy(dir.getOpposite(), transferRF, false);
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        IEnergyProvider receiver;
        if (tile instanceof IEnergyProvider && (receiver = (IEnergyProvider)tile).canConnectEnergy(dir.getOpposite())) {
            transfer.stored = transfer.stored - (long)receiver.extractEnergy(dir.getOpposite(), transfer.stored < Integer.MAX_VALUE ? (int)transfer.stored : Integer.MAX_VALUE, false);
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.RF;
    }
}

