/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.energy;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="ic2.api.item.IElectricItemManager", modid="IC2", striprefs=true)
public class SonarElectricManager
implements IElectricItemManager {
    @Override
    @Optional.Method(modid="IC2")
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            if (stack.func_77978_p() == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            int energyEU = stack.func_77978_p().func_74762_e("Energy") / 4;
            int energyRF = stack.func_77978_p().func_74762_e("Energy");
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            int newamount = (int)Math.min(item.getTransferLimit(stack), amount);
            int energyReceived = Math.min(container.getMaxEnergyStored(stack) / 4 - energyEU, Math.min(container.receiveEnergy(stack, newamount * 4, true) / 4, newamount));
            if (!simulate) {
                stack.func_77978_p().func_74768_a("Energy", energyRF += energyReceived * 4);
            }
            return energyReceived;
        }
        return 0.0;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Energy")) {
                return 0.0;
            }
            int energyEU = stack.func_77978_p().func_74762_e("Energy") / 4;
            int energyRF = stack.func_77978_p().func_74762_e("Energy");
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            int newamount = (int)Math.min(item.getTransferLimit(stack), amount);
            int energyExtracted = Math.min(energyEU, Math.min(container.extractEnergy(stack, newamount * 4, true) / 4, newamount));
            if (!simulate) {
                stack.func_77978_p().func_74768_a("Energy", energyRF -= energyExtracted * 4);
            }
            return energyExtracted;
        }
        return 0.0;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem container = (IEnergyContainerItem)stack.func_77973_b();
            int stored = container.getEnergyStored(stack) / 4;
            return stored;
        }
        return 0.0;
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean canUse(ItemStack stack, double amount) {
        return true;
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return true;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
    }

    @Override
    @Optional.Method(modid="IC2")
    public String getToolTip(ItemStack stack) {
        return null;
    }
}

