/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.energy.ChargingUtils;
import sonar.core.energy.EnergyCharge;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.network.utils.ISyncTile;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyAcceptor", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2", striprefs=true)})
public class TileEntityInventoryReceiver
extends TileEntityInventory
implements IEnergyHandler,
IEnergySink,
ISyncTile {
    public int maxTransfer = 5000;
    public SyncEnergyStorage storage;

    @Override
    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
    }

    @Override
    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.add(this.storage);
    }

    public void discharge(int id) {
        EnergyCharge discharge;
        if (ChargingUtils.canDischarge(this.slots[id], this.storage) && (discharge = ChargingUtils.discharge(this.slots[id], this.storage)).getEnergyStack() != null && discharge.getEnergyUsage() != 0) {
            this.slots[id] = discharge.getEnergyStack();
            this.storage.modifyEnergyStored(discharge.getEnergyUsage());
            if (discharge.stackUsed()) {
                --this.slots[id].field_77994_a;
                if (this.slots[id].field_77994_a <= 0) {
                    this.slots[id] = null;
                }
            }
        }
    }

    public void charge(int id) {
        EnergyCharge charge;
        if (ChargingUtils.canCharge(this.slots[id], this.storage) && (charge = ChargingUtils.charge(this.slots[id], this.storage, this.maxTransfer)).getEnergyStack() != null && charge.getEnergyUsage() != 0) {
            this.slots[id] = charge.getEnergyStack();
            this.storage.modifyEnergyStored(charge.getEnergyUsage());
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return this.storage.receiveEnergy(this.storage.getMaxReceive(), true) / 4;
    }

    @Override
    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amountEU, double voltage) {
        int addRF = this.storage.receiveEnergy((int)amountEU * 4, true);
        this.storage.receiveEnergy(addRF, false);
        return amountEU - (double)(addRF / 4);
    }
}

