/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import cofh.api.block.IDismantleable;
import cofh.api.item.IToolHammer;
import cofh.api.tileentity.IReconfigurableSides;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.inventory.IAdditionalInventory;
import sonar.core.inventory.IDropInventory;
import sonar.core.network.PacketBlockInteraction;
import sonar.core.network.utils.ISyncTile;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.core.utils.IInteractBlock;

public abstract class SonarBlock
extends Block
implements IDismantleable,
IInteractBlock {
    protected Random rand = new Random();
    public boolean orientation = true;
    public boolean wrenchable = true;

    protected SonarBlock(Material material) {
        super(material);
    }

    public void disableOrientation() {
        this.orientation = false;
    }

    public void disableWrenchable() {
        this.wrenchable = false;
    }

    public final boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitx, float hity, float hitz) {
        if (player != null) {
            ItemStack heldItem = player.func_70694_bm();
            if (this.wrenchable && heldItem != null && heldItem.func_77973_b() instanceof IToolHammer) {
                TileEntity target;
                if (!player.func_70093_af() && (target = world.func_147438_o(x, y, z)) instanceof IReconfigurableSides) {
                    ((IReconfigurableSides)target).incrSide(side);
                }
                return false;
            }
            if (this.wrenchable && SonarLoader.calculatorLoaded() && heldItem != null && (heldItem.func_77973_b() instanceof IToolHammer || heldItem.func_77973_b() == GameRegistry.findItem((String)"Calculator", (String)"Wrench"))) {
                return false;
            }
            return this.operateBlock(world, x, y, z, player, new BlockInteraction(side, hitx, hity, hitz, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT));
        }
        return super.func_149727_a(world, x, y, z, player, side, hitx, hity, hitz);
    }

    @Override
    public boolean isClickableSide(World world, int x, int y, int z, int side) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K && this.allowLeftClick()) {
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            if (this.isClickableSide(world, x, y, z, posn.field_72310_e)) {
                this.func_149699_a(world, x, y, z, player);
                return false;
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public final boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public abstract boolean dropStandard(World var1, int var2, int var3, int var4);

    @Override
    public abstract boolean operateBlock(World var1, int var2, int var3, int var4, EntityPlayer var5, BlockInteraction var6);

    @Override
    public boolean allowLeftClick() {
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K && this.allowLeftClick()) {
            MovingObjectPosition pos = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(pos.field_72307_f.field_72450_a - (double)pos.field_72311_b);
            float hitY = (float)(pos.field_72307_f.field_72448_b - (double)pos.field_72312_c);
            float hitZ = (float)(pos.field_72307_f.field_72449_c - (double)pos.field_72309_d);
            SonarCore.network.sendToServer((IMessage)new PacketBlockInteraction(x, y, z, new BlockInteraction(pos.field_72310_e, hitX, hitY, hitZ, player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT)));
        }
    }

    public final void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.dropStandard(world, x, y, z)) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getSpecialDrop(world, x, y, z)});
    }

    public final ItemStack getSpecialDrop(World world, int x, int y, int z) {
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null && target instanceof ISyncTile) {
            ItemStack itemStack = new ItemStack((Block)this, 1);
            this.processDrop(world, x, y, z, (ISyncTile)target, itemStack);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack((Block)this, 1);
        this.processDrop(world, x, y, z, null, itemStack);
        return itemStack;
    }

    public void processDrop(World world, int x, int y, int z, ISyncTile te, ItemStack drop) {
        if (te != null) {
            ISyncTile handler = te;
            NBTTagCompound tag = new NBTTagCompound();
            handler.writeData(tag, NBTHelper.SyncType.DROP);
            if (!tag.func_82582_d()) {
                tag.func_74757_a("dropped", true);
                drop.func_77982_d(tag);
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (this.orientation) {
            this.setDefaultDirection(world, x, y, z);
        }
    }

    public void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block b1 = world.func_147439_a(x, y, z - 1);
            Block b2 = world.func_147439_a(x, y, z + 1);
            Block b3 = world.func_147439_a(x - 1, y, z);
            Block b4 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (b1.func_149730_j() && !b2.func_149730_j()) {
                b0 = 3;
            }
            if (b2.func_149730_j() && !b1.func_149730_j()) {
                b0 = 2;
            }
            if (b3.func_149730_j() && !b4.func_149730_j()) {
                b0 = 5;
            }
            if (b4.func_149730_j() && !b3.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, x, b0, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
        TileEntity entity;
        if (this.orientation) {
            int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (l == 0) {
                world.func_72921_c(x, y, z, 2, 2);
            }
            if (l == 1) {
                world.func_72921_c(x, y, z, 5, 2);
            }
            if (l == 2) {
                world.func_72921_c(x, y, z, 3, 2);
            }
            if (l == 3) {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
        if (itemstack.func_77942_o() && (entity = world.func_147438_o(x, y, z)) != null && entity instanceof ISyncTile) {
            ISyncTile handler = (ISyncTile)entity;
            handler.readData(itemstack.func_77978_p(), NBTHelper.SyncType.DROP);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldblock, int oldMetadata) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null) {
            IAdditionalInventory additionalInv;
            ItemStack[] additionalStacks;
            IDropInventory inv;
            if (entity instanceof IDropInventory) {
                inv = (IDropInventory)entity;
                if (inv.canDrop() && inv.dropSlots() != null) {
                    int[] slots = inv.dropSlots();
                    for (int i = 0; i < slots.length; ++i) {
                        ItemStack itemstack = inv.func_70301_a(slots[i]);
                        if (itemstack == null) continue;
                        drops.add(itemstack);
                    }
                }
            } else if (entity instanceof IInventory) {
                inv = (IInventory)entity;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack itemstack = inv.func_70301_a(i);
                    if (itemstack == null) continue;
                    drops.add(itemstack);
                }
            }
            if (entity instanceof IAdditionalInventory && (additionalStacks = (additionalInv = (IAdditionalInventory)entity).getAdditionalStacks()) != null) {
                for (ItemStack stack : additionalStacks) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            }
        }
        for (ItemStack stack : drops) {
            if (stack == null) continue;
            float f = this.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem dropStack = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), stack);
            world.func_72838_d((Entity)dropStack);
        }
        super.func_149749_a(world, x, y, z, oldblock, oldMetadata);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        SonarHelper.dropTile(player, world.func_147439_a(x, y, z), world, x, y, z);
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public boolean hasSpecialRenderer() {
        return false;
    }

    public int func_149645_b() {
        return this.hasSpecialRenderer() ? -1 : 0;
    }

    public boolean func_149662_c() {
        return !this.hasSpecialRenderer();
    }

    public boolean func_149686_d() {
        return !this.hasSpecialRenderer();
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        list.add(AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G)));
        return list;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        if (this.hasSpecialCollisionBox()) {
            List<AxisAlignedBB> collisionList = this.getCollisionBoxes(world, x, y, z, new ArrayList<AxisAlignedBB>());
            for (AxisAlignedBB collision : collisionList) {
                collision.func_72317_d((double)x, (double)y, (double)z);
                if (collision == null || !collision.func_72326_a(axis)) continue;
                list.add(collision);
            }
        } else {
            super.func_149743_a(world, x, y, z, axis, list, entity);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public boolean hasSpecialCollisionBox() {
        return false;
    }
}

