/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StoredItemStack {
    public ItemStack item;
    public long stored;

    public StoredItemStack(ItemStack stack) {
        this.item = stack.func_77946_l();
        this.stored = stack.field_77994_a;
    }

    public StoredItemStack(ItemStack stack, long stored) {
        this.item = stack.func_77946_l();
        this.stored = stored;
    }

    public void add(ItemStack stack) {
        if (this.equalStack(stack)) {
            this.stored += (long)stack.field_77994_a;
        }
    }

    public void remove(ItemStack stack) {
        if (this.equalStack(stack)) {
            this.stored -= (long)stack.field_77994_a;
        }
    }

    public void add(StoredItemStack stack) {
        if (this.equalStack(stack.item)) {
            this.stored += stack.stored;
        }
    }

    public void remove(StoredItemStack stack) {
        if (this.equalStack(stack.item)) {
            this.stored -= stack.stored;
        }
    }

    public StoredItemStack copy() {
        return new StoredItemStack(this.item, this.stored);
    }

    public StoredItemStack setStackSize(long size) {
        this.stored = size;
        return this;
    }

    public boolean equalStack(ItemStack stack) {
        if (this.item == null || stack == null || stack.field_77994_a == 0) {
            return false;
        }
        if (!this.item.func_77969_a(stack)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.item);
    }

    public static StoredItemStack readFromNBT(NBTTagCompound tag) {
        return new StoredItemStack(ItemStack.func_77949_a((NBTTagCompound)tag), tag.func_74763_f("stored"));
    }

    public static void writeToNBT(NBTTagCompound tag, StoredItemStack storedStack) {
        storedStack.item.func_77955_b(tag);
        tag.func_74772_a("stored", storedStack.stored);
    }

    public static StoredItemStack readFromBuf(ByteBuf buf) {
        return new StoredItemStack(ByteBufUtils.readItemStack((ByteBuf)buf), buf.readLong());
    }

    public static void writeToBuf(ByteBuf buf, StoredItemStack storedStack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)storedStack.item);
        buf.writeLong(storedStack.stored);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredItemStack) {
            StoredItemStack target = (StoredItemStack)obj;
            if (this.equalStack(target.item) && this.stored == target.stored) {
                return true;
            }
        }
        return false;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public long getStackSize() {
        return this.stored;
    }

    public int getItemDamage() {
        return this.item.func_77960_j();
    }

    public NBTTagCompound getTagCompound() {
        return this.item.func_77978_p();
    }

    public ItemStack getFullStack() {
        int min = (int)Math.min(this.stored, (long)this.item.func_77976_d());
        ItemStack stack = this.item.func_77946_l();
        stack.field_77994_a = min;
        return stack;
    }
}

