/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarEvents;
import sonar.core.api.SonarAPI;
import sonar.core.energy.DischargeValues;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.SonarWailaModule;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketBlockInteraction;
import sonar.core.network.PacketByteBufClient;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.PacketInvUpdate;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketSonarSides;
import sonar.core.network.PacketStackUpdate;
import sonar.core.network.PacketTextField;
import sonar.core.network.PacketTileSync;
import sonar.core.network.SonarCommon;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ISyncTile;
import sonar.core.registries.EnergyProviderRegistry;
import sonar.core.registries.EnergyTypeRegistry;
import sonar.core.registries.FluidProviderRegistry;
import sonar.core.registries.InventoryProviderRegistry;

@Mod(modid="SonarCore", name="SonarCore", version="1.1.3")
public class SonarCore {
    public static final String modid = "SonarCore";
    public static final String version = "1.1.3";
    @SidedProxy(clientSide="sonar.core.network.SonarClient", serverSide="sonar.core.network.SonarCommon")
    public static SonarCommon proxy;
    @Mod.Instance(value="SonarCore")
    public static SonarCore instance;
    public static InventoryProviderRegistry inventoryProviders;
    public static FluidProviderRegistry fluidProviders;
    public static EnergyProviderRegistry energyProviders;
    public static EnergyTypeRegistry energyTypes;
    public static SimpleNetworkWrapper network;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        SonarAPI.init();
        logger.info("Initilised API");
        logger.info("Registering Packets");
        SonarCore.registerPackets();
        logger.info("Register Packets");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (SonarLoader.wailaLoaded()) {
            SonarWailaModule.register();
            logger.info("Integrated with WAILA");
        } else {
            logger.warn("'WAILA' - unavailable or disabled in config");
        }
        MinecraftForge.EVENT_BUS.register((Object)new SonarEvents());
        logger.info("Registered Events");
        energyTypes.register();
        inventoryProviders.register();
        fluidProviders.register();
        energyProviders.register();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Adding Discharge Values");
        DischargeValues.addValues();
        logger.info("Added" + DischargeValues.getPowerList().size() + "Discharge Values");
        for (Map.Entry<ItemStack, Integer> entry : DischargeValues.getPowerList().entrySet()) {
            logger.info("Discharge Values: " + entry.toString() + " = " + entry.getValue());
        }
        logger.info("Registered " + energyTypes.getObjects().size() + " Energy Types");
        logger.info("Registered " + inventoryProviders.getObjects().size() + " Inventory Providers");
        logger.info("Registered " + fluidProviders.getObjects().size() + " Fluid Providers");
        logger.info("Registered " + energyProviders.getObjects().size() + " Energy Providers");
    }

    public static void registerPackets() {
        if (network == null) {
            network = NetworkRegistry.INSTANCE.newSimpleChannel("Sonar-Packets");
            network.registerMessage(PacketTileSync.Handler.class, PacketTileSync.class, 0, Side.CLIENT);
            network.registerMessage(PacketSonarSides.Handler.class, PacketSonarSides.class, 1, Side.CLIENT);
            network.registerMessage(PacketRequestSync.Handler.class, PacketRequestSync.class, 2, Side.SERVER);
            network.registerMessage(PacketTextField.Handler.class, PacketTextField.class, 3, Side.SERVER);
            network.registerMessage(PacketByteBufClient.Handler.class, PacketByteBufClient.class, 4, Side.CLIENT);
            network.registerMessage(PacketByteBufServer.Handler.class, PacketByteBufServer.class, 5, Side.SERVER);
            network.registerMessage(PacketBlockInteraction.Handler.class, PacketBlockInteraction.class, 6, Side.SERVER);
            network.registerMessage(PacketStackUpdate.Handler.class, PacketStackUpdate.class, 7, Side.CLIENT);
            network.registerMessage(PacketInvUpdate.Handler.class, PacketInvUpdate.class, 8, Side.CLIENT);
        }
    }

    public static void sendPacketAround(TileEntity tile, int spread, int id) {
        Object object = FMPHelper.checkObject(tile);
        if (object != null && object instanceof IByteBufTile) {
            if (!tile.func_145831_w().field_72995_K) {
                network.sendToAllAround((IMessage)new PacketByteBufClient((IByteBufTile)object, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
            } else {
                network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)object, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id));
            }
        } else {
            TileHandler handler = FMPHelper.getHandler(object);
            if (handler != null && handler instanceof IByteBufTile) {
                if (!tile.func_145831_w().field_72995_K) {
                    network.sendToAllAround((IMessage)new PacketByteBufClient((IByteBufTile)((Object)handler), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
                } else {
                    network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)((Object)handler), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, id));
                }
            }
        }
    }

    public static void sendFullSyncAround(TileEntity tile, int spread) {
        Object object = FMPHelper.checkObject(tile);
        if (object != null && object instanceof ISyncTile) {
            NBTTagCompound tag = new NBTTagCompound();
            ((ISyncTile)object).writeData(tag, NBTHelper.SyncType.SYNC);
            if (!tag.func_82582_d()) {
                network.sendToAllAround((IMessage)new PacketTileSync(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, (double)spread));
            }
        }
    }

    static {
        inventoryProviders = new InventoryProviderRegistry();
        fluidProviders = new FluidProviderRegistry();
        energyProviders = new EnergyProviderRegistry();
        energyTypes = new EnergyTypeRegistry();
        logger = LogManager.getLogger((String)modid);
    }
}

