/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.bigdoors.block.tile;

import com.jaquadro.minecraft.bigdoors.block.Door3x3;
import com.jaquadro.minecraft.bigdoors.block.movement.Door3x3Movement;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.MultiBlock;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.sound.VanillaDoorSound;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class Door3x3Tile
extends DoorTileEntity {
    private boolean delete = false;
    private boolean processed = true;
    private ForgeDirection direction = ForgeDirection.NORTH;
    private int woodType;

    public Door3x3Tile() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(Door3x3Movement.class));
        descriptor.setSound(DoorRegistry.getSound(VanillaDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(15);
        this.setDescriptor(descriptor);
    }

    public void setDoorType(int meta) {
        this.woodType = meta;
    }

    public int getDoorType() {
        return this.woodType;
    }

    public boolean isTopBlock(int x, int y, int z) {
        return false;
    }

    public boolean isReversed() {
        return false;
    }

    public boolean isPowered() {
        return this.func_145831_w().func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setDoorState(DoorState newState) {
        boolean moving = this.moving;
        BlockState state = null;
        if (this.func_145831_w() != null) {
            state = new BlockState(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            ChunkCollision.get().updateBlocks(this.func_145831_w(), state);
        }
        super.setDoorState(newState);
        if (this.func_145831_w() != null && moving && !this.moving) {
            ChunkCollision.get().replaceBlocks(this.func_145831_w(), state);
        }
    }

    public void func_145845_h() {
        if (!this.processed && this.func_145831_w() != null) {
            if (this.delete) {
                this.func_145831_w().func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                ChunkBlockHandler.get().updateCoordinates(this.func_145831_w().func_72938_d(this.field_145851_c, this.field_145849_e), this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a, this.func_145838_q());
                this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, Door.dirToInt((ForgeDirection)this.direction), 2);
                this.processed = true;
            }
            return;
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("multiblock")) {
            MultiBlock mb = new MultiBlock(tag);
            this.delete = !mb.isOrigin(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.direction = mb.getDirection();
            this.processed = true;
        }
        if (tag.func_74764_b("wood")) {
            this.woodType = tag.func_74771_c("wood");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.woodType != 0) {
            tag.func_74774_a("wood", (byte)this.woodType);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ((Door3x3)this.func_145838_q()).getBoundingBox((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, BoundingBoxType.RENDER)[0].func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }
}

