/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.bigdoors.block.render;

import com.jaquadro.minecraft.bigdoors.block.tile.Door3x3Tile;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class Door3x3Renderer
extends MalisisRenderer {
    private MalisisModel model;
    private Shape doorLeft;
    private Shape doorRight;
    private AnimationRenderer ar = new AnimationRenderer();
    private Door3x3Tile tile;
    private boolean overrideAlpha;
    private int overrideAlphaValue;
    private ForgeDirection direction;

    public Door3x3Renderer() {
        this.getBlockDamage = true;
    }

    protected void initialize() {
        this.doorLeft = new Cube();
        this.doorLeft.setSize(0.5f, 3.0f, 0.06229236f);
        this.doorLeft.interpolateUV();
        this.doorLeft.setSize(1.5f, 3.0f, 0.1875f);
        this.doorLeft.scale(1.0f, 1.0f, 0.995f);
        this.doorLeft.translate(-1.0f, 0.0f, 0.8125f);
        this.doorRight = new Cube();
        this.doorRight.setSize(1.0f, 3.0f, 0.06229236f);
        this.doorRight.limit(0.5, 0.0, 0.0, 1.0, 3.0, 0.1875);
        this.doorRight.interpolateUV();
        this.doorRight.setSize(1.5f, 3.0f, 0.1875f);
        this.doorRight.scale(1.0f, 1.0f, 0.995f);
        this.doorRight.translate(0.0f, 0.0f, 0.8125f);
        this.model = new MalisisModel();
        this.model.addShape("left", this.doorLeft);
        this.model.addShape("right", this.doorRight);
        this.model.storeState();
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (this.tileEntity == null) {
            return;
        }
        if (this.renderType == RenderType.ISBRH_WORLD) {
            return;
        }
        this.tile = (Door3x3Tile)this.tileEntity;
        this.direction = Door.intToDir((int)this.tile.getDirection());
        this.setup();
        if (this.renderType == RenderType.TESR_WORLD) {
            this.renderTileEntity();
        }
    }

    private void renderTileEntity() {
        this.ar.setStartTime(this.tile.getTimer().getStart());
        if (this.tile.getMovement() != null) {
            Animation[] anims = this.tile.getMovement().getAnimations((DoorTileEntity)this.tile, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.next(9);
        this.rp.icon.reset();
        this.drawShape(this.doorLeft, this.rp);
        this.drawShape(this.doorRight, this.rp);
    }

    private void setup() {
        this.model.resetState();
        if (this.direction == ForgeDirection.SOUTH) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == ForgeDirection.EAST) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == ForgeDirection.WEST) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
    }

    public void renderDestroyProgress() {
        if (this.destroyBlockProgress != null) {
            this.overrideTexture = damagedIcons[this.destroyBlockProgress.func_73106_e()];
        }
        if (this.renderType == RenderType.TESR_WORLD) {
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2903);
            GL11.glShadeModel((int)7425);
            OpenGlHelper.func_148821_a((int)774, (int)768, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
        this.overrideAlpha = true;
        this.overrideAlphaValue = 128;
        this.render();
        this.overrideAlpha = false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    protected void drawVertex(Vertex vertex, int number) {
        if (vertex == null) {
            vertex = new Vertex(0.0, 0.0, 0.0);
        }
        int brightness = this.calcVertexBrightness(vertex, (int[][])this.params.aoMatrix.get(number));
        vertex.setBrightness(brightness);
        int color = this.calcVertexColor(vertex, (int[][])this.params.aoMatrix.get(number));
        vertex.setColor(color);
        if (!((Boolean)this.params.usePerVertexAlpha.get()).booleanValue()) {
            vertex.setAlpha(((Integer)this.params.alpha.get()).intValue());
        }
        int alpha = this.overrideAlpha ? this.overrideAlphaValue : vertex.getAlpha();
        this.t.func_78384_a(vertex.getColor(), alpha);
        this.t.func_78380_c(vertex.getBrightness());
        if (((Boolean)this.params.useTexture.get()).booleanValue()) {
            this.t.func_78374_a(vertex.getX(), vertex.getY(), vertex.getZ(), vertex.getU(), vertex.getV());
        } else {
            this.t.func_78377_a(vertex.getX(), vertex.getY(), vertex.getZ());
        }
        this.vertexDrawn = true;
    }
}

