/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.bigdoors.block;

import com.jaquadro.minecraft.bigdoors.block.tile.Door3x3Tile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.core.util.chunklistener.IBlockListener;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWood;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Door3x3
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable,
IBlockListener {
    public static int renderId;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;
    private AxisAlignedBB defaultBoundingBox = AxisAlignedBB.func_72330_a((double)-1.0, (double)0.0, (double)0.8125, (double)2.0, (double)3.0, (double)1.0);

    public Door3x3() {
        this(Material.field_151575_d);
    }

    protected Door3x3(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c("door3x3");
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[BlockWood.field_150096_a.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("BigDoors:doors_" + BlockWood.field_150096_a[i] + "_3x3");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % this.icons.length];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess worldIn, int x, int y, int z, int side) {
        Door3x3Tile tile = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)worldIn, (int)x, (int)y, (int)z));
        if (tile == null) {
            return this.func_149691_a(side, 0);
        }
        return this.func_149691_a(side, tile.getDoorType());
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "BigDoors:doors_oak";
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        for (int i = 0; i < this.icons.length; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        int metadata = Door.dirToInt((ForgeDirection)dir);
        world.func_72921_c(x, y, z, metadata, 2);
        ChunkCollision.get().replaceBlocks(world, new BlockState((IBlockAccess)world, x, y, z));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB[] getPlacedBoundingBox(IBlockAccess world, int x, int y, int z, int side, EntityPlayer player, ItemStack itemStack) {
        ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player);
        return AABBUtils.rotate((AxisAlignedBB[])new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()}, (ForgeDirection)dir);
    }

    public AxisAlignedBB[] getBoundingBox(IBlockAccess world, int x, int y, int z, BoundingBoxType type) {
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox.func_72329_c()};
        if (type == BoundingBoxType.RENDER) {
            aabbs[0].field_72339_c = -0.5;
        } else if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.CHUNKCOLLISION || type == BoundingBoxType.RAYTRACE) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{AxisAlignedBB.func_72330_a((double)-1.0, (double)0.0, (double)-0.5, (double)-0.8125, (double)3.0, (double)1.0), AxisAlignedBB.func_72330_a((double)1.8125, (double)0.0, (double)-0.5, (double)2.0, (double)3.0, (double)1.0)};
        }
        return AABBUtils.rotate((AxisAlignedBB[])aabbs, (ForgeDirection)Door.intToDir((int)te.getDirection()));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te != null && !te.isMoving() && te.getMovement() != null) {
            AxisAlignedBB aabb = te.getMovement().getBoundingBox((DoorTileEntity)te, te.isTopBlock(x, y, z), BoundingBoxType.COLLISION);
            return aabb == null ? null : this.setBlockBounds(aabb.func_72317_d((double)x, (double)y, (double)z));
        }
        return null;
    }

    public MovingObjectPosition func_149731_a(World worldIn, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        this.func_149719_a((IBlockAccess)worldIn, x, y, z);
        return super.func_149731_a(worldIn, x, y, z, startVec, endVec);
    }

    protected AxisAlignedBB setBlockBounds(AxisAlignedBB aabb) {
        if (aabb == null) {
            aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
        return aabb;
    }

    public int blockRange() {
        return 3;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new Door3x3Tile();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean onBlockSet(World world, BlockPos pos, BlockState state) {
        if (!state.getBlock().isReplaceable((IBlockAccess)world, state.getX(), state.getY(), state.getZ())) {
            return true;
        }
        for (AxisAlignedBB aabb : AABBUtils.getCollisionBoundingBoxes((World)world, (BlockState)new BlockState(pos, (Block)this), (boolean)true)) {
            if (!state.getPos().isInside(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean onBlockRemoved(World world, BlockPos pos, BlockPos blockRemoved) {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        Door3x3Tile tile = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (tile == null) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            items.add(new ItemStack(item, 1, tile.getDoorType()));
        }
        return items;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(worldIn, player, x, y, z, meta);
        worldIn.func_147468_f(x, y, z);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        boolean powered;
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)worldIn, (int)x, (int)y, (int)z));
        if (te != null && ((powered = te.isPowered()) || neighbor.func_149744_f()) && neighbor != this) {
            te.setPowered(powered);
        }
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random random) {
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)worldIn, (int)x, (int)y, (int)z));
        if (te != null && te.getDescriptor().getAutoCloseTime() > 0 && te.getState() != DoorState.CLOSED && te.getState() != DoorState.CLOSING) {
            te.openOrCloseDoor();
        }
    }
}

