/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class DyeUtils {
    private static final Map<String, Integer> dyes = new HashMap<String, Integer>();

    private DyeUtils() {
    }

    public static int getDyeColor(ItemStack stack) {
        int[] oreIds;
        if (stack == null) {
            return -1;
        }
        for (int ore : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)ore);
            Integer color = dyes.get(name);
            if (color == null) continue;
            return color;
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        return DyeUtils.getDyeColor(stack) >= 0;
    }

    public static int getColorFromDyes(int color, Collection<ItemStack> dyes) {
        int number = dyes.size();
        if (number < 1) {
            return -1;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        if (color >= 0) {
            r = color >> 16;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
            ++number;
        }
        for (ItemStack dye : dyes) {
            color = DyeUtils.getDyeColor(dye);
            if (color < 0) continue;
            r += color >> 16;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
        }
        return (r /= number) << 16 | (g /= number) << 8 | (b /= number);
    }

    public static int getColorFromDyes(Collection<ItemStack> dyes) {
        return DyeUtils.getColorFromDyes(-1, dyes);
    }

    private static void addColorFromTable(String name) {
        int dye = BlockColored.func_150031_c((int)dyes.size());
        float[] values = EntitySheep.field_70898_d[dye];
        int r = (int)(values[0] * 255.0f);
        int g = (int)(values[1] * 255.0f);
        int b = (int)(values[2] * 255.0f);
        int color = r << 16 | g << 8 | b;
        dyes.put(name, color);
    }

    static {
        DyeUtils.addColorFromTable("dyeBlack");
        DyeUtils.addColorFromTable("dyeRed");
        DyeUtils.addColorFromTable("dyeGreen");
        DyeUtils.addColorFromTable("dyeBrown");
        DyeUtils.addColorFromTable("dyeBlue");
        DyeUtils.addColorFromTable("dyePurple");
        DyeUtils.addColorFromTable("dyeCyan");
        DyeUtils.addColorFromTable("dyeLightGray");
        DyeUtils.addColorFromTable("dyeGray");
        DyeUtils.addColorFromTable("dyePink");
        DyeUtils.addColorFromTable("dyeLime");
        DyeUtils.addColorFromTable("dyeYellow");
        DyeUtils.addColorFromTable("dyeLightBlue");
        DyeUtils.addColorFromTable("dyeMagenta");
        DyeUtils.addColorFromTable("dyeOrange");
        DyeUtils.addColorFromTable("dyeWhite");
    }
}

