/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.network.packet.PacketPresentOpen;
import net.mcft.copy.betterstorage.tile.entity.TileEntityCardboardBox;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class TileEntityPresent
extends TileEntityCardboardBox {
    public static final String TAG_COLOR_INNER = "presentColorInner";
    public static final String TAG_COLOR_OUTER = "presentColorOuter";
    public static final String TAG_SKOJANZA_MODE = "skojanzaMode";
    public static final String TAG_NAMETAG = "nameTag";
    public int colorInner = 14;
    public int colorOuter = 0;
    public boolean skojanzaMode = false;
    public String nameTag = null;
    public int breakProgress = 0;
    public int breakPause = 0;

    @Override
    protected boolean canPickUp() {
        return true;
    }

    @Override
    protected ItemStack getItemDropped() {
        return !this.destroyed ? new ItemStack((Block)BetterStorageTiles.present) : null;
    }

    @Override
    protected void onItemDropped(ItemStack stack) {
        super.onItemDropped(stack);
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74774_a(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.func_74774_a(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.func_74757_a(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.func_74778_a(TAG_NAMETAG, this.nameTag);
        }
        StackUtils.remove(stack, "display", "color");
        compound.func_74768_a("color", this.color);
    }

    @Override
    public void func_145845_h() {
        this.breakPause = Math.max(0, this.breakPause - 1);
        if (this.breakPause <= 0) {
            this.breakProgress = Math.max(0, this.breakProgress - 1);
        }
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.colorInner = StackUtils.get(stack, (byte)14, TAG_COLOR_INNER).byteValue();
        this.colorOuter = StackUtils.get(stack, (byte)0, TAG_COLOR_OUTER).byteValue();
        this.skojanzaMode = StackUtils.get(stack, (byte)0, TAG_SKOJANZA_MODE) > 0;
        this.nameTag = StackUtils.get(stack, null, TAG_NAMETAG);
        this.color = StackUtils.get(stack, -1, "color");
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.colorInner, 2);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack holding = player.func_71045_bC();
        if (holding == null) {
            if (this.breakPause > 0) {
                return false;
            }
            this.breakPause = 10 - this.breakProgress / 10;
            if (this.nameTag != null && !player.func_70005_c_().equalsIgnoreCase(this.nameTag)) {
                this.breakPause = 40;
                if (!this.field_145850_b.field_72995_K) {
                    ((EntityPlayerMP)player).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "This present is for " + this.nameTag + ", not you!"));
                }
                return false;
            }
            if ((this.breakProgress += 20) > 100) {
                this.destroyed = true;
            }
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            double x = (double)this.field_145851_c + 0.5;
            double y = (double)this.field_145848_d + 0.5;
            double z = (double)this.field_145849_e + 0.5;
            String sound = Block.field_149775_l.func_150495_a();
            this.field_145850_b.func_72908_a(x, y, z, sound, 0.75f, 0.8f + (float)this.breakProgress / 80.0f);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, sound, 1.0f, 0.4f + (float)this.breakProgress / 160.0f);
            BetterStorage.networkChannel.sendToAllAround(new PacketPresentOpen(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.destroyed), this.field_145850_b, x, y, z, 64.0);
            if (!this.destroyed) {
                return true;
            }
            if (BetterStorageTiles.cardboardBox != null) {
                if (this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)BetterStorageTiles.cardboardBox)) {
                    TileEntityCardboardBox box = WorldUtils.get((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, TileEntityCardboardBox.class);
                    box.uses = ItemCardboardBox.getUses();
                    box.color = this.color;
                    System.arraycopy(this.contents, 0, box.contents, 0, this.contents.length);
                } else {
                    for (ItemStack stack : this.contents) {
                        WorldUtils.dropStackFromBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
                    }
                }
            } else if (this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                for (ItemStack stack : this.contents) {
                    WorldUtils.dropStackFromBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
                }
            }
            return true;
        }
        if (holding.func_77973_b() == Items.field_151057_cb && this.nameTag == null && holding.func_82837_s()) {
            if (holding.func_82833_r().matches("^[a-zA-Z0-9_]{2,16}$")) {
                if (!this.field_145850_b.field_72995_K) {
                    this.nameTag = holding.func_82833_r();
                    --holding.field_77994_a;
                    this.markForUpdate();
                }
                return true;
            }
            if (!this.field_145850_b.field_72995_K) {
                ((EntityPlayerMP)player).func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "The nametag doesn't seem to contain a valid username."));
            }
            return false;
        }
        return false;
    }

    @Override
    public void dropContents() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        this.colorInner = StackUtils.get(stack, (byte)14, TAG_COLOR_INNER).byteValue();
        this.colorOuter = StackUtils.get(stack, (byte)0, TAG_COLOR_OUTER).byteValue();
        this.skojanzaMode = StackUtils.get(stack, (byte)0, TAG_SKOJANZA_MODE) > 0;
        this.nameTag = StackUtils.get(stack, null, TAG_NAMETAG);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.color >= 0) {
            compound.func_74768_a("color", this.color);
        }
        compound.func_74774_a(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.func_74774_a(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.func_74757_a(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.func_74778_a(TAG_NAMETAG, this.nameTag);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        this.colorInner = compound.func_74771_c(TAG_COLOR_INNER);
        this.colorOuter = compound.func_74771_c(TAG_COLOR_OUTER);
        this.skojanzaMode = compound.func_74767_n(TAG_SKOJANZA_MODE);
        this.nameTag = compound.func_74764_b(TAG_NAMETAG) ? compound.func_74779_i(TAG_NAMETAG) : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.colorInner = compound.func_74771_c(TAG_COLOR_INNER);
        this.colorOuter = compound.func_74771_c(TAG_COLOR_OUTER);
        this.skojanzaMode = compound.func_74767_n(TAG_SKOJANZA_MODE);
        this.nameTag = compound.func_74764_b(TAG_NAMETAG) ? compound.func_74779_i(TAG_NAMETAG) : null;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74774_a(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.func_74774_a(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.func_74757_a(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.func_74778_a(TAG_NAMETAG, this.nameTag);
        }
    }
}

