/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.attachment.LockAttachment;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLockableDoor
extends TileEntity
implements ILockable,
IHasAttachments {
    private Attachments attachments = new Attachments(this);
    public LockAttachment lockAttachment;
    public ForgeDirection orientation = ForgeDirection.NORTH;
    private boolean powered = false;
    private boolean swing = false;
    public boolean isOpen = false;
    public boolean isMirrored = false;

    public TileEntityLockableDoor() {
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    private void updateLockPosition() {
        switch (this.orientation) {
            case WEST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(12.5, -1.5, 1.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(1.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                break;
            }
            case EAST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(3.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(14.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                break;
            }
            case SOUTH: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(1.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(12.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                break;
            }
            default: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(14.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(3.5, -1.5, 1.5, 5.0, 6.0, 3.0);
            }
        }
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public ItemStack getLock() {
        return this.lockAttachment.getItem();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock == null || lock.func_77973_b() instanceof ILock;
    }

    @Override
    public void setLock(ItemStack lock) {
        if (lock == null) {
            int rotation;
            this.lockAttachment.setItem(null);
            int n = this.orientation == ForgeDirection.WEST ? 0 : (this.orientation == ForgeDirection.NORTH ? 1 : (rotation = this.orientation == ForgeDirection.EAST ? 2 : 3));
            rotation = this.isMirrored ? (rotation == 0 ? 1 : (rotation == 1 ? 2 : (rotation == 2 ? 3 : 0))) : rotation;
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150454_av, rotation, 2);
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Blocks.field_150454_av, this.isMirrored ? 9 : 8, 2);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150454_av);
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Blocks.field_150454_av);
        } else {
            this.setLockWithUpdate(lock);
        }
    }

    public void setLockWithUpdate(ItemStack lock) {
        this.lockAttachment.setItem(lock);
        this.updateLockPosition();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return false;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        this.isOpen = !this.isOpen;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, this.isOpen ? 1 : 0);
        this.updateLockPosition();
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.canUse(player)) {
            this.useUnlocked(player);
        } else {
            ((ILock)this.getLock().func_77973_b()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
        }
        return true;
    }

    public boolean func_145842_c(int eventID, int par) {
        this.field_145850_b.func_72926_e(1003, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        this.swing = true;
        this.isOpen = par == 1;
        this.updateLockPosition();
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void func_145845_h() {
        this.attachments.update();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isOpen = compound.func_74767_n("isOpen");
        this.isMirrored = compound.func_74767_n("isMirrored");
        this.orientation = ForgeDirection.getOrientation((int)compound.func_74771_c("orientation"));
        if (compound.func_74764_b("lock")) {
            this.lockAttachment.setItem(ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lock")));
        }
        this.updateLockPosition();
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("isOpen", this.isOpen);
        compound.func_74757_a("isMirrored", this.isMirrored);
        compound.func_74774_a("orientation", (byte)this.orientation.ordinal());
        if (this.lockAttachment.getItem() != null) {
            compound.func_74782_a("lock", (NBTBase)this.lockAttachment.getItem().func_77955_b(new NBTTagCompound()));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("isOpen", this.isOpen);
        compound.func_74757_a("isMirrored", this.isMirrored);
        compound.func_74774_a("orientation", (byte)this.orientation.ordinal());
        if (this.lockAttachment.getItem() != null) {
            compound.func_74782_a("lock", (NBTBase)this.lockAttachment.getItem().func_77955_b(new NBTTagCompound()));
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound compound = pkt.func_148857_g();
        if (!compound.func_74764_b("lock")) {
            this.lockAttachment.setItem(null);
        } else {
            this.lockAttachment.setItem(ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lock")));
        }
        this.orientation = ForgeDirection.getOrientation((int)compound.func_74771_c("orientation"));
        this.isOpen = compound.func_74767_n("isOpen");
        this.isMirrored = compound.func_74767_n("isMirrored");
        this.updateLockPosition();
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        if (powered) {
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 10);
        }
        WorldUtils.notifyBlocksAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        WorldUtils.notifyBlocksAround(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }
}

