/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.inventory.InventoryCardboardBox;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityCardboardBox
extends TileEntityContainer {
    public int uses = 1;
    public int color = -1;
    public boolean destroyed = false;

    protected boolean canPickUp() {
        return this.uses >= 0;
    }

    protected ItemStack getItemDropped() {
        return new ItemStack((Block)BetterStorageTiles.cardboardBox);
    }

    protected void onItemDropped(ItemStack stack) {
        if (ItemCardboardBox.getUses() > 0) {
            StackUtils.set(stack, this.uses, "uses");
        }
        if (this.color >= 0) {
            StackUtils.set(stack, this.color, "display", "color");
        }
        if (this.getCustomTitle() != null) {
            stack.func_151001_c(this.getCustomTitle());
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.cardboardBox";
    }

    @Override
    public int getRows() {
        return ItemCardboardBox.getRows();
    }

    @Override
    public InventoryTileEntity makePlayerInventory() {
        return new InventoryTileEntity((TileEntityContainer)this, new InventoryCardboardBox(this.contents));
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        int maxUses;
        super.onBlockPlaced(player, stack);
        if (StackUtils.has(stack, "Items")) {
            ItemStack[] itemContents = StackUtils.getStackContents(stack, this.contents.length);
            System.arraycopy(itemContents, 0, this.contents, 0, itemContents.length);
        }
        if ((maxUses = ItemCardboardBox.getUses()) > 0) {
            this.uses = StackUtils.get(stack, maxUses, "uses");
        }
        this.color = StackUtils.get(stack, -1, "display", "color");
    }

    @Override
    public void onBlockDestroyed() {
        if (!this.canPickUp() || this.destroyed) {
            return;
        }
        boolean empty = StackUtils.isEmpty(this.contents);
        if (!empty) {
            --this.uses;
            if (!this.canPickUp()) {
                this.destroyed = true;
                this.dropContents();
                return;
            }
        }
        ItemStack stack = this.getItemDropped();
        if (!empty) {
            StackUtils.setStackContents(stack, this.contents);
        }
        this.onItemDropped(stack);
        if (!empty || !this.brokenInCreative) {
            WorldUtils.dropStackFromBlock(this, stack);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.color >= 0) {
            compound.func_74768_a("color", this.color);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.color = compound.func_74764_b("color") ? compound.func_74762_e("color") : -1;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.uses = compound.func_74764_b("uses") ? compound.func_74762_e("uses") : ItemCardboardBox.getUses();
        this.color = compound.func_74764_b("color") ? compound.func_74762_e("color") : -1;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (ItemCardboardBox.getUses() > 0) {
            compound.func_74768_a("uses", this.uses);
        }
        if (this.color >= 0) {
            compound.func_74768_a("color", this.color);
        }
    }
}

