/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.EnumAttachmentInteraction;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockableDoor;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileLockableDoor
extends TileBetterStorage {
    private IIcon iconUpper;
    private IIcon iconLower;
    private IIcon iconUpperFlipped;
    private IIcon iconLowerFlipped;

    public TileLockableDoor() {
        super(Material.field_151575_d);
        this.func_149647_a(null);
        this.func_149711_c(8.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 2);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float offset = metadata == 0 ? 0.0f : -1.0f;
        TileEntityLockableDoor te = WorldUtils.get(world, x, y + (int)offset, z, TileEntityLockableDoor.class);
        if (te == null) {
            return;
        }
        switch (te.orientation) {
            case WEST: {
                if (te.isOpen) {
                    this.func_149676_a(0.0f, 0.0f, 3.125E-4f, 1.0f, 1.0f, 0.1871875f);
                    break;
                }
                this.func_149676_a(3.125E-4f, 0.0f, 0.0f, 0.1871875f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                if (te.isOpen) {
                    this.func_149676_a(0.0f, 0.0f, 0.8128125f, 1.0f, 1.0f, 0.9996875f);
                    break;
                }
                this.func_149676_a(0.8128125f, 0.0f, 0.0f, 0.9996875f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                if (te.isOpen) {
                    this.func_149676_a(3.125E-4f, 0.0f, 0.0f, 0.1871875f, 1.0f, 1.0f);
                    break;
                }
                this.func_149676_a(0.0f, 0.0f, 0.8128125f, 1.0f, 1.0f, 0.9996875f);
                break;
            }
            default: {
                if (te.isOpen) {
                    this.func_149676_a(0.8128125f, 0.0f, 0.0f, 0.9996875f, 1.0f, 1.0f);
                    break;
                }
                this.func_149676_a(0.0f, 0.0f, 3.125E-4f, 1.0f, 1.0f, 0.1871875f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconUpper = iconRegister.func_94245_a("door_iron_upper");
        this.iconLower = iconRegister.func_94245_a("door_iron_lower");
        this.iconUpperFlipped = new IconFlipped(this.iconUpper, true, false);
        this.iconLowerFlipped = new IconFlipped(this.iconLower, true, false);
        this.field_149761_L = this.iconUpper;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int face) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 0) {
            --y;
        }
        TileEntityLockableDoor lockable = WorldUtils.get(world, x, y, z, TileEntityLockableDoor.class);
        boolean flip = false;
        IIcon icon = this.iconUpper;
        if (meta == 0 || face == 1) {
            icon = this.iconLower;
        }
        switch (lockable.orientation) {
            case WEST: {
                if (face == 3 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 2 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            case EAST: {
                if (face == 4 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 3 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            case SOUTH: {
                if (face == 2 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 4 || !lockable.isOpen) break;
                flip = true;
                break;
            }
            default: {
                if (face == 3 && !lockable.isOpen) {
                    flip = true;
                    break;
                }
                if (face != 5 || !lockable.isOpen) break;
                flip = true;
            }
        }
        icon = flip ? (icon == this.iconLower ? this.iconLowerFlipped : this.iconUpperFlipped) : icon;
        return icon;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityLockableDoor lockable;
        if (world.func_72805_g(x, y, z) > 0) {
            --y;
        }
        if ((lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class)) != null && lockable.getLock() != null) {
            return -1.0f;
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int persistance;
        if (world.func_72805_g(x, y, z) > 0) {
            --y;
        }
        float modifier = 1.0f;
        TileEntityLockableDoor lockable = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
        if (lockable != null && (persistance = BetterStorageEnchantment.getLevel(lockable.getLock(), "persistance")) > 0) {
            modifier = (float)((double)modifier + Math.pow(2.0, persistance));
        }
        return super.func_149638_a(entity) * modifier;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventPar) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null ? te.func_145842_c(eventId, eventPar) : false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.func_72805_g(x, y, z) > 0) {
            --y;
        }
        TileEntityLockableDoor te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
        return te.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.func_72805_g(x, y, z) > 0) {
            --y;
        }
        Attachments attachments = WorldUtils.get((IBlockAccess)world, x, y, z, IHasAttachments.class).getAttachments();
        boolean abort = attachments.interact(WorldUtils.rayTrace(player, 1.0f), player, EnumAttachmentInteraction.attack);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        int metadata = world.func_72805_g(x, y, z);
        IHasAttachments te = WorldUtils.get((IBlockAccess)world, x, y - (metadata > 0 ? 1 : 0), z, IHasAttachments.class);
        if (te == null) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
        MovingObjectPosition pos = te.getAttachments().rayTrace(world, x, y - (metadata > 0 ? 1 : 0), z, start, end);
        return pos != null ? pos : super.func_149731_a(world, x, y, z, start, end);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(Items.field_151139_aw);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (meta > 0) {
            return;
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int targetMeta;
        int metadata = world.func_72805_g(x, y, z);
        int targetY = y + (metadata == 0 ? 1 : -1);
        int n = targetMeta = metadata == 0 ? 8 : 0;
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a && metadata == 0) {
            world.func_147468_f(x, y, z);
        }
        if (world.func_147439_a(x, targetY, z) == this && world.func_72805_g(x, targetY, z) == targetMeta) {
            return;
        }
        world.func_147468_f(x, y, z);
        if (metadata == 0) {
            WorldUtils.spawnItem(world, x, y, z, new ItemStack(Items.field_151139_aw));
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        if (meta == 0) {
            TileEntityLockableDoor te = WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class);
            WorldUtils.dropStackFromBlock(te, te.getLock());
            te.setLockWithUpdate(null);
        }
        super.func_149725_f(world, x, y, z, meta);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.lockableDoorRenderId;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta == 0 ? 1 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityLockableDoor te;
        if (world.func_72805_g(x, y, z) > 0) {
            --y;
        }
        return (te = WorldUtils.get(world, x, y, z, TileEntityLockableDoor.class)) == null ? 0 : (te.isPowered() ? 15 : 0);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.func_72805_g(x, y, z) != 0) {
            return;
        }
        WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityLockableDoor.class).setPowered(false);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return metadata == 0 ? new TileEntityLockableDoor() : null;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }
}

