/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.IContainerItem;
import net.mcft.copy.betterstorage.item.IDyeableItem;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemCardboardBox
extends ItemBlock
implements IContainerItem,
IDyeableItem {
    public ItemCardboardBox(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int maxUses = ItemCardboardBox.getUses();
        return maxUses > 1 && StackUtils.get(stack, maxUses, "uses") < maxUses;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int maxUses = ItemCardboardBox.getUses();
        return 1.0f - (float)StackUtils.get(stack, maxUses, "uses").intValue() / (float)maxUses;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        return StackUtils.get(stack, 7360560, "display", "color");
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        int i;
        int maxUses = ItemCardboardBox.getUses();
        boolean hasItems = StackUtils.has(stack, "Items");
        if (!hasItems && BetterStorage.globalConfig.getBoolean("general.enableHelpTooltips")) {
            list.add(LanguageUtils.translateTooltip("cardboardBox.useHint" + (maxUses > 0 ? ".reusable" : Integer.valueOf(0)), new String[0]));
        }
        if (maxUses > 1) {
            list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("cardboardBox.uses", "%USES%", StackUtils.get(stack, maxUses, "uses").toString()));
        }
        if (!hasItems) {
            return;
        }
        if (!BetterStorage.globalConfig.getBoolean("general.cardboardBoxShowContents")) {
            list.add(LanguageUtils.translateTooltip("cardboardBox.containsItems", new String[0]));
            return;
        }
        ItemStack[] contents = StackUtils.getStackContents(stack, 27);
        int limit = advancedTooltips || GuiScreen.func_146272_n() ? 6 : 3;
        ArrayList<DisplayNameStack> items = new ArrayList<DisplayNameStack>();
        block0: for (i = 0; i < contents.length; ++i) {
            ItemStack contentStack = contents[i];
            if (contentStack == null) continue;
            for (DisplayNameStack itemsStack : items) {
                if (!itemsStack.matchAndAdd(contentStack)) continue;
                continue block0;
            }
            items.add(new DisplayNameStack(contentStack));
        }
        Collections.sort(items);
        for (i = 0; i < items.size() && i < limit; ++i) {
            list.add(((DisplayNameStack)items.get(i)).toString());
        }
        if (items.size() <= limit) {
            return;
        }
        int count = 0;
        for (int i2 = limit; i2 < items.size(); ++i2) {
            count += ((DisplayNameStack)items.get((int)i2)).stackSize;
        }
        list.add(count + " more item" + (count > 1 ? "s" : "") + " ...");
    }

    @Override
    public ItemStack[] getContainerItemContents(ItemStack container) {
        if (StackUtils.has(container, "Items")) {
            return StackUtils.getStackContents(container, ItemCardboardBox.getRows());
        }
        return null;
    }

    @Override
    public boolean canBeStoredInContainerItem(ItemStack item) {
        return !StackUtils.has(item, "Items");
    }

    public static int getRows() {
        return BetterStorage.globalConfig.getInteger("general.cardboardBoxRows");
    }

    public static int getUses() {
        return BetterStorage.globalConfig.getInteger("general.cardboardBoxUses");
    }

    private static class DisplayNameStack
    implements Comparable<DisplayNameStack> {
        public final String name;
        public int stackSize;

        public DisplayNameStack(ItemStack stack) {
            this.name = stack.func_77973_b().func_77653_i(stack);
            this.stackSize = stack.field_77994_a;
        }

        public boolean matchAndAdd(ItemStack stack) {
            if (this.name.equals(stack.func_77973_b().func_77653_i(stack))) {
                this.stackSize += stack.field_77994_a;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.stackSize + "x " + this.name;
        }

        @Override
        public int compareTo(DisplayNameStack other) {
            return other.stackSize - this.stackSize;
        }
    }
}

