/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageEnchantment;
import net.mcft.copy.betterstorage.api.lock.IKey;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

public class EnchantmentBetterStorage
extends Enchantment {
    private final int maxLevel;
    private final int minBase;
    private final int minScaling;
    private final int maxBase;
    private final int maxScaling;
    private List<Enchantment> incompatible = new ArrayList<Enchantment>(0);

    public static void initialize() {
        Map<String, EnumEnchantmentType> types = BetterStorageEnchantment.enchantmentTypes;
        Map<String, Enchantment> enchs = BetterStorageEnchantment.enchantments;
        if (BetterStorageItems.key != null) {
            EnumEnchantmentType key = EnumHelper.addEnchantmentType((String)"key");
            EnchantmentBetterStorage unlocking = EnchantmentBetterStorage.conditialNew("unlocking", key, "enchantment.unlocking", 8, 5, 5, 10, 30, 0);
            EnchantmentBetterStorage lockpicking = EnchantmentBetterStorage.conditialNew("lockpicking", key, "enchantment.lockpicking", 6, 5, 5, 8, 30, 0);
            EnchantmentBetterStorage morphing = EnchantmentBetterStorage.conditialNew("morphing", key, "enchantment.morphing", 1, 5, 10, 12, 30, 0);
            if (lockpicking != null) {
                lockpicking.setIncompatible(morphing);
            }
            if (morphing != null) {
                morphing.setIncompatible(lockpicking);
            }
            types.put("key", key);
            enchs.put("unlocking", unlocking);
            enchs.put("lockpicking", lockpicking);
            enchs.put("morphing", morphing);
        }
        if (BetterStorageItems.lock != null) {
            EnumEnchantmentType lock = EnumHelper.addEnchantmentType((String)"lock");
            EnchantmentBetterStorage persistance = EnchantmentBetterStorage.conditialNew("persistance", lock, "enchantment.persistance", 20, 5, 1, 8, 30, 0);
            EnchantmentBetterStorage security = EnchantmentBetterStorage.conditialNew("security", lock, "enchantment.security", 16, 5, 1, 10, 30, 0);
            EnchantmentBetterStorage shock = EnchantmentBetterStorage.conditialNew("shock", lock, "enchantment.shock", 5, 3, 5, 15, 30, 0);
            EnchantmentBetterStorage trigger = EnchantmentBetterStorage.conditialNew("trigger", lock, "enchantment.trigger", 10, 1, 15, 0, 30, 0);
            types.put("lock", lock);
            enchs.put("persistance", persistance);
            enchs.put("security", security);
            enchs.put("shock", shock);
            enchs.put("trigger", trigger);
        }
    }

    private static EnchantmentBetterStorage conditialNew(String name, EnumEnchantmentType type, String configName, int weight, int maxLevel, int minBase, int minScaling, int maxBase, int maxScaling) {
        int id = BetterStorage.globalConfig.getInteger(configName);
        if (id <= 0) {
            return null;
        }
        return new EnchantmentBetterStorage(name, type, id, weight, maxLevel, minBase, minScaling, maxBase, maxScaling);
    }

    public EnchantmentBetterStorage(String name, EnumEnchantmentType type, int id, int weight, int maxLevel, int minBase, int minScaling, int maxBase, int maxScaling) {
        super(id, weight, type);
        this.func_77322_b("betterstorage." + type.toString() + "." + name);
        this.maxLevel = maxLevel;
        this.minBase = minBase;
        this.minScaling = minScaling;
        this.maxBase = maxBase;
        this.maxScaling = maxScaling;
    }

    public void setIncompatible(Enchantment ... incompatible) {
        this.incompatible = Arrays.asList(incompatible);
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int level) {
        return this.minBase + (level - 1) * this.minScaling;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + this.maxBase + (level - 1) * this.maxScaling;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (this.field_77351_y == BetterStorageEnchantment.getType("key")) {
            IKey key = stack.func_77973_b() instanceof IKey ? (IKey)stack.func_77973_b() : null;
            return key != null && key.canApplyEnchantment(stack, this);
        }
        if (this.field_77351_y == BetterStorageEnchantment.getType("lock")) {
            ILock lock = stack.func_77973_b() instanceof ILock ? (ILock)stack.func_77973_b() : null;
            return lock != null && lock.canApplyEnchantment(stack, this);
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public boolean func_77326_a(Enchantment other) {
        return super.func_77326_a(other) && !this.incompatible.contains(other);
    }

    public boolean isAllowedOnBooks() {
        return false;
    }
}

