/*
 * Decompiled with CFR 0.152.
 */
package io.github.mathiasdj.endercrop.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.github.mathiasdj.endercrop.block.BlockCropEnder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTilledEndStone
extends BlockFarmland {
    @SideOnly(value=Side.CLIENT)
    private IIcon field_149824_a;
    @SideOnly(value=Side.CLIENT)
    private IIcon field_149823_b;

    public BlockTilledEndStone() {
        this.func_149663_c("tilled_end_stone");
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_149711_c(0.6f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return p_149691_1_ == 1 ? (p_149691_2_ > 0 ? this.field_149824_a : this.field_149823_b) : Blocks.field_150377_bs.func_149733_h(p_149691_1_);
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", "endercrop".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149824_a = p_149651_1_.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a())) + "_wet");
        this.field_149823_b = p_149651_1_.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a())) + "_dry");
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random rand) {
        if (!this.hasWater(worldIn, x, y, z) && !worldIn.func_72951_B(x, y + 1, z)) {
            int l = worldIn.func_72805_g(x, y, z);
            if (l > 0) {
                worldIn.func_72921_c(x, y, z, l - 1, 2);
            } else if (!this.hasCrops(worldIn, x, y, z)) {
                worldIn.func_147449_b(x, y, z, Blocks.field_150377_bs);
            }
        } else {
            worldIn.func_72921_c(x, y, z, 7, 2);
        }
    }

    private boolean hasCrops(World worldIn, int x, int y, int z) {
        int b0 = 0;
        for (int l = x - b0; l <= x + b0; ++l) {
            for (int i1 = z - b0; i1 <= z + b0; ++i1) {
                Block block = worldIn.func_147439_a(l, y + 1, i1);
                if (!(block instanceof IPlantable) || !this.canSustainPlant((IBlockAccess)worldIn, x, y, z, ForgeDirection.UP, (IPlantable)block)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasWater(World worldIn, int x, int y, int z) {
        for (int l = x - 4; l <= x + 4; ++l) {
            for (int i1 = y; i1 <= y + 1; ++i1) {
                for (int j1 = z - 4; j1 <= z + 4; ++j1) {
                    if (worldIn.func_147439_a(l, i1, j1).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockAccess worldIn, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(worldIn, x, y + 1, z);
        return plant instanceof BlockCropEnder;
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block block) {
        super.func_149695_a(worldIn, x, y, z, block);
        Material material = worldIn.func_147439_a(x, y + 1, z).func_149688_o();
        if (material.func_76220_a()) {
            worldIn.func_147449_b(x, y, z, Blocks.field_150377_bs);
        }
    }

    public void func_149746_a(World worldIn, int x, int y, int z, Entity entity, float fallDistance) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextFloat() < fallDistance - 0.5f) {
            if (!(entity instanceof EntityPlayer) && !worldIn.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            worldIn.func_147449_b(x, y, z, Blocks.field_150377_bs);
        }
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) > 0;
    }

    public Item func_149650_a(int p_149650_1_, Random rand, int fortune) {
        return Blocks.field_150377_bs.func_149650_a(p_149650_1_, rand, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)Blocks.field_150377_bs);
    }
}

