/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.Random;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public enum EnumColor {
    BLACK,
    RED,
    GREEN,
    BROWN,
    BLUE,
    PURPLE,
    CYAN,
    LIGHT_GRAY,
    GRAY,
    PINK,
    LIME,
    YELLOW,
    LIGHT_BLUE,
    MAGENTA,
    ORANGE,
    WHITE;

    public static final EnumColor[] VALUES;
    public static final String[] DYES;
    public static final String[] NAMES;
    public static final int[] DARK_HEX;
    public static final int[] LIGHT_HEX;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] brushIcons;

    public int getDarkHex() {
        return DARK_HEX[this.ordinal()];
    }

    public int getLightHex() {
        return LIGHT_HEX[this.ordinal()];
    }

    public static EnumColor fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return WHITE;
        }
        return VALUES[id];
    }

    public static EnumColor fromDye(String dyeTag) {
        for (int id = 0; id < DYES.length; ++id) {
            if (!DYES[id].equals(dyeTag)) continue;
            return VALUES[id];
        }
        return null;
    }

    public static EnumColor fromName(String name) {
        for (int id = 0; id < NAMES.length; ++id) {
            if (!NAMES[id].equals(name)) continue;
            return VALUES[id];
        }
        return null;
    }

    public static EnumColor getRand() {
        return VALUES[new Random().nextInt(VALUES.length)];
    }

    public EnumColor getNext() {
        EnumColor next = VALUES[(this.ordinal() + 1) % VALUES.length];
        return next;
    }

    public EnumColor getPrevious() {
        EnumColor previous = VALUES[(this.ordinal() + VALUES.length - 1) % VALUES.length];
        return previous;
    }

    public EnumColor inverse() {
        return VALUES[15 - this.ordinal()];
    }

    public String getTag() {
        return "color." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public String getBasicTag() {
        return this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return NAMES[this.ordinal()];
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.getTag());
    }

    public String getDye() {
        return DYES[this.ordinal()];
    }

    public String toString() {
        String s = this.name().replace("_", " ");
        String[] words = s.split(" ");
        StringBuilder b = new StringBuilder();
        for (String word : words) {
            b.append(word.charAt(0)).append(word.substring(1).toLowerCase(Locale.ENGLISH)).append(" ");
        }
        return b.toString().trim();
    }

    public static void setIconArray(IIcon[] icons) {
        brushIcons = icons;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return brushIcons[this.ordinal()];
    }

    static {
        VALUES = EnumColor.values();
        DYES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        NAMES = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        DARK_HEX = new int[]{0x2D2D2D, 10696757, 3755038, 6044196, 3424674, 8667071, 3571870, 0x888888, 0x444444, 15041952, 4172342, 13615665, 8362705, 0xFF64FF, 16738816, 0xFFFFFF};
        LIGHT_HEX = new int[]{0x181414, 12462887, 32526, 8998957, 2437523, 8271039, 0x299799, 0xA0A7A7, 0x7A7A7A, 14250393, 3790126, 16767260, 0x66AAFF, 14238662, 15366197, 0xE4E4E4};
    }
}

