/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;

public class IICProxy
implements IImmersiveConnectable {
    private boolean canEnergyPass;
    private int dim;
    private ChunkCoordinates cc;

    public IICProxy(boolean allowPass, int dimension, ChunkCoordinates pos) {
        this.canEnergyPass = allowPass;
        this.dim = dimension;
        this.cc = pos;
    }

    public IICProxy(TileEntity te) {
        if (!(te instanceof IImmersiveConnectable)) {
            throw new IllegalArgumentException("Can't create an IICProxy for a null/non-IIC TileEntity");
        }
        this.dim = te.func_145831_w().field_73011_w.field_76574_g;
        this.canEnergyPass = ((IImmersiveConnectable)te).allowEnergyToPass(null);
        this.cc = Utils.toCC(te);
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection c) {
        return this.canEnergyPass;
    }

    public ChunkCoordinates getPos() {
        return this.cc;
    }

    public int getDimension() {
        return this.dim;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WorldServer w = MinecraftServer.func_71276_C().func_71218_a(this.dim);
        if (w == null) {
            IELogger.warn("Tried to remove a wire in dimension " + this.dim + " which does not exist");
            return;
        }
        TileEntity te = w.func_147438_o(this.cc.field_71574_a, this.cc.field_71572_b, this.cc.field_71573_c);
        if (!(te instanceof IImmersiveConnectable)) {
            return;
        }
        ((IImmersiveConnectable)te).removeCable(connection);
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return false;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return null;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        return null;
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return null;
    }

    public static IICProxy readFromNBT(NBTTagCompound nbt) {
        return new IICProxy(nbt.func_74767_n("pass"), nbt.func_74762_e("dim"), new ChunkCoordinates(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74768_a("dim", this.dim);
        ret.func_74768_a("x", this.cc.field_71574_a);
        ret.func_74768_a("y", this.cc.field_71572_b);
        ret.func_74768_a("z", this.cc.field_71573_c);
        ret.func_74757_a("pass", this.canEnergyPass);
        return ret;
    }
}

